/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.core.rating.service;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.beanutils.BeanComparator;
import org.broadleafcommerce.common.time.SystemTime;
import org.broadleafcommerce.core.rating.dao.RatingSummaryDao;
import org.broadleafcommerce.core.rating.dao.ReviewDetailDao;
import org.broadleafcommerce.core.rating.domain.RatingDetail;
import org.broadleafcommerce.core.rating.domain.RatingDetailImpl;
import org.broadleafcommerce.core.rating.domain.RatingSummary;
import org.broadleafcommerce.core.rating.domain.RatingSummaryImpl;
import org.broadleafcommerce.core.rating.domain.ReviewDetail;
import org.broadleafcommerce.core.rating.domain.ReviewDetailImpl;
import org.broadleafcommerce.core.rating.domain.ReviewFeedback;
import org.broadleafcommerce.core.rating.service.RatingService;
import org.broadleafcommerce.core.rating.service.type.RatingSortType;
import org.broadleafcommerce.core.rating.service.type.RatingType;
import org.broadleafcommerce.profile.core.domain.Customer;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="blRatingService")
public class RatingServiceImpl
implements RatingService {
    @Resource(name="blRatingSummaryDao")
    protected RatingSummaryDao ratingSummaryDao;
    @Resource(name="blReviewDetailDao")
    protected ReviewDetailDao reviewDetailDao;

    @Override
    @Transactional(value="blTransactionManager")
    public void deleteRatingSummary(RatingSummary ratingSummary) {
        this.ratingSummaryDao.deleteRatingSummary(ratingSummary);
    }

    @Override
    @Transactional(value="blTransactionManager")
    public void markReviewHelpful(Long reviewId, Customer customer, Boolean helpful) {
        ReviewDetail reviewDetail = this.reviewDetailDao.readReviewDetailById(reviewId);
        if (reviewDetail != null) {
            ReviewFeedback reviewFeedback = this.reviewDetailDao.createFeedback();
            reviewFeedback.setCustomer(customer);
            reviewFeedback.setIsHelpful(helpful);
            reviewFeedback.setReviewDetail(reviewDetail);
            reviewDetail.getReviewFeedback().add(reviewFeedback);
            this.reviewDetailDao.saveReviewDetail(reviewDetail);
        }
    }

    @Override
    @Transactional(value="blTransactionManager")
    public void rateItem(String itemId, RatingType type, Customer customer, Double rating) {
        RatingDetail ratingDetail;
        RatingSummary ratingSummary = this.readRatingSummary(itemId, type);
        if (ratingSummary == null) {
            ratingSummary = new RatingSummaryImpl(itemId, type);
        }
        if ((ratingDetail = this.ratingSummaryDao.readRating(customer.getId(), ratingSummary.getId())) == null) {
            ratingDetail = new RatingDetailImpl(ratingSummary, rating, SystemTime.asDate(), customer);
        }
        ratingDetail.setRating(rating);
        ratingSummary.getRatings().add(ratingDetail);
        this.ratingSummaryDao.saveRatingSummary(ratingSummary);
    }

    @Override
    public RatingSummary readRatingSummary(String itemId, RatingType type) {
        return this.ratingSummaryDao.readRatingSummary(itemId, type);
    }

    @Override
    public Map<String, RatingSummary> readRatingSummaries(List<String> itemIds, RatingType type) {
        List<RatingSummary> ratings = this.ratingSummaryDao.readRatingSummaries(itemIds, type);
        HashMap<String, RatingSummary> ratingsMap = new HashMap<String, RatingSummary>();
        for (RatingSummary ratingSummary : ratings) {
            ratingsMap.put(ratingSummary.getItemId(), ratingSummary);
        }
        return ratingsMap;
    }

    @Override
    public List<ReviewDetail> readReviews(String itemId, RatingType type, int start, int finish, RatingSortType sortBy) {
        RatingSummary summary = this.readRatingSummary(itemId, type);
        List<ReviewDetail> reviews = summary.getReviews();
        ArrayList<ReviewDetail> reviewsToReturn = new ArrayList<ReviewDetail>();
        int i = 0;
        for (ReviewDetail review : reviews) {
            if (i > finish) break;
            if (i >= start) {
                reviewsToReturn.add(review);
            }
            ++i;
        }
        String sortByBeanProperty = "reviewSubmittedDate";
        if (sortBy == RatingSortType.MOST_HELPFUL) {
            sortByBeanProperty = "helpfulCount";
        }
        Collections.sort(reviewsToReturn, new BeanComparator(sortByBeanProperty));
        return reviewsToReturn;
    }

    @Override
    @Transactional(value="blTransactionManager")
    public RatingSummary saveRatingSummary(RatingSummary ratingSummary) {
        return this.ratingSummaryDao.saveRatingSummary(ratingSummary);
    }

    @Override
    @Transactional(value="blTransactionManager")
    public void reviewItem(String itemId, RatingType type, Customer customer, Double rating, String reviewText) {
        RatingDetail ratingDetail;
        RatingSummary ratingSummary = this.readRatingSummary(itemId, type);
        if (ratingSummary == null) {
            ratingSummary = new RatingSummaryImpl(itemId, type);
        }
        if ((ratingDetail = this.ratingSummaryDao.readRating(customer.getId(), ratingSummary.getId())) == null) {
            ratingDetail = new RatingDetailImpl(ratingSummary, rating, SystemTime.asDate(), customer);
        } else {
            ratingDetail.setRating(rating);
        }
        ratingSummary.getRatings().add(ratingDetail);
        ReviewDetail reviewDetail = this.ratingSummaryDao.readReview(customer.getId(), ratingSummary.getId());
        if (reviewDetail == null) {
            reviewDetail = new ReviewDetailImpl(customer, SystemTime.asDate(), ratingDetail, reviewText, ratingSummary);
        } else {
            reviewDetail.setReviewText(reviewText);
        }
        ratingSummary.getReviews().add(reviewDetail);
        ratingSummary.getReviews().size();
        this.ratingSummaryDao.saveRatingSummary(ratingSummary);
    }

    @Override
    public ReviewDetail readReviewByCustomerAndItem(Customer customer, String itemId) {
        return this.reviewDetailDao.readReviewByCustomerAndItem(customer, itemId);
    }
}

