/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.core.offer.service.discount.domain;

import java.math.BigDecimal;
import org.broadleafcommerce.common.currency.domain.BroadleafCurrency;
import org.broadleafcommerce.common.money.Money;
import org.broadleafcommerce.core.offer.domain.Offer;
import org.broadleafcommerce.core.offer.domain.OrderItemPriceDetailAdjustment;
import org.broadleafcommerce.core.offer.service.discount.domain.AbstractPromotionRounding;
import org.broadleafcommerce.core.offer.service.discount.domain.OfferHolder;
import org.broadleafcommerce.core.offer.service.discount.domain.PromotableCandidateItemOffer;
import org.broadleafcommerce.core.offer.service.discount.domain.PromotableOfferUtility;
import org.broadleafcommerce.core.offer.service.discount.domain.PromotableOrderItemPriceDetail;
import org.broadleafcommerce.core.offer.service.discount.domain.PromotableOrderItemPriceDetailAdjustment;

public class PromotableOrderItemPriceDetailAdjustmentImpl
extends AbstractPromotionRounding
implements PromotableOrderItemPriceDetailAdjustment,
OfferHolder {
    private static final long serialVersionUID = 1L;
    protected PromotableCandidateItemOffer promotableCandidateItemOffer;
    protected PromotableOrderItemPriceDetail promotableOrderItemPriceDetail;
    protected Money saleAdjustmentValue;
    protected Money retailAdjustmentValue;
    protected Money adjustmentValue;
    protected boolean appliedToSalePrice;
    protected Offer offer;

    public PromotableOrderItemPriceDetailAdjustmentImpl(PromotableCandidateItemOffer promotableCandidateItemOffer, PromotableOrderItemPriceDetail orderItemPriceDetail) {
        assert (promotableCandidateItemOffer != null);
        assert (orderItemPriceDetail != null);
        this.promotableCandidateItemOffer = promotableCandidateItemOffer;
        this.promotableOrderItemPriceDetail = orderItemPriceDetail;
        this.offer = promotableCandidateItemOffer.getOffer();
        this.computeAdjustmentValues();
    }

    public PromotableOrderItemPriceDetailAdjustmentImpl(OrderItemPriceDetailAdjustment itemAdjustment, PromotableOrderItemPriceDetail orderItemPriceDetail) {
        assert (orderItemPriceDetail != null);
        this.adjustmentValue = itemAdjustment.getValue();
        this.saleAdjustmentValue = itemAdjustment.getSalesPriceValue();
        this.retailAdjustmentValue = itemAdjustment.getRetailPriceValue();
        this.appliedToSalePrice = itemAdjustment.isAppliedToSalePrice();
        this.promotableOrderItemPriceDetail = orderItemPriceDetail;
        this.offer = itemAdjustment.getOffer();
    }

    protected void computeAdjustmentValues() {
        this.saleAdjustmentValue = new Money(this.getCurrency());
        this.retailAdjustmentValue = new Money(this.getCurrency());
        Money currentPriceDetailRetailValue = this.promotableOrderItemPriceDetail.calculateItemUnitPriceWithAdjustments(false);
        Money currentPriceDetailSalesValue = this.promotableOrderItemPriceDetail.calculateItemUnitPriceWithAdjustments(true);
        if (currentPriceDetailSalesValue == null) {
            currentPriceDetailSalesValue = currentPriceDetailRetailValue;
        }
        BigDecimal offerUnitValue = PromotableOfferUtility.determineOfferUnitValue(this.offer, this.promotableCandidateItemOffer);
        this.retailAdjustmentValue = PromotableOfferUtility.computeAdjustmentValue(currentPriceDetailRetailValue, offerUnitValue, this, this);
        if (this.offer.getApplyDiscountToSalePrice()) {
            this.saleAdjustmentValue = PromotableOfferUtility.computeAdjustmentValue(currentPriceDetailSalesValue, offerUnitValue, this, this);
        }
    }

    @Override
    public Money getRetailAdjustmentValue() {
        return this.retailAdjustmentValue;
    }

    @Override
    public Money getSaleAdjustmentValue() {
        return this.saleAdjustmentValue;
    }

    @Override
    public BroadleafCurrency getCurrency() {
        return this.promotableOrderItemPriceDetail.getPromotableOrderItem().getCurrency();
    }

    @Override
    public PromotableOrderItemPriceDetail getPromotableOrderItemPriceDetail() {
        return this.promotableOrderItemPriceDetail;
    }

    @Override
    public Offer getOffer() {
        return this.offer;
    }

    @Override
    public boolean isCombinable() {
        Boolean combinable = this.offer.isCombinableWithOtherOffers();
        return combinable != null && combinable != false;
    }

    @Override
    public boolean isTotalitarian() {
        Boolean totalitarian = this.offer.isTotalitarianOffer();
        return totalitarian != null && totalitarian != false;
    }

    @Override
    public Long getOfferId() {
        return this.offer.getId();
    }

    @Override
    public Money getAdjustmentValue() {
        return this.adjustmentValue;
    }

    @Override
    public boolean isAppliedToSalePrice() {
        return this.appliedToSalePrice;
    }

    @Override
    public void finalizeAdjustment(boolean useSalePrice) {
        this.appliedToSalePrice = useSalePrice;
        this.adjustmentValue = useSalePrice ? this.saleAdjustmentValue : this.retailAdjustmentValue;
    }

    @Override
    public PromotableOrderItemPriceDetailAdjustment copy() {
        PromotableOrderItemPriceDetailAdjustmentImpl newAdjustment = new PromotableOrderItemPriceDetailAdjustmentImpl(this.promotableCandidateItemOffer, this.promotableOrderItemPriceDetail);
        newAdjustment.adjustmentValue = this.adjustmentValue;
        newAdjustment.saleAdjustmentValue = this.saleAdjustmentValue;
        newAdjustment.retailAdjustmentValue = this.retailAdjustmentValue;
        newAdjustment.appliedToSalePrice = this.appliedToSalePrice;
        return newAdjustment;
    }
}

