/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.core.payment.domain;

import java.math.BigDecimal;
import java.util.Date;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.persistence.TableGenerator;
import org.broadleafcommerce.common.currency.domain.BroadleafCurrency;
import org.broadleafcommerce.common.currency.domain.BroadleafCurrencyImpl;
import org.broadleafcommerce.common.currency.util.BroadleafCurrencyUtils;
import org.broadleafcommerce.common.money.Money;
import org.broadleafcommerce.common.presentation.AdminPresentation;
import org.broadleafcommerce.common.presentation.client.VisibilityEnum;
import org.broadleafcommerce.core.payment.domain.PaymentInfo;
import org.broadleafcommerce.core.payment.domain.PaymentInfoDetail;
import org.broadleafcommerce.core.payment.domain.PaymentInfoDetailType;
import org.broadleafcommerce.core.payment.domain.PaymentInfoImpl;

@Entity
@Inheritance(strategy=InheritanceType.JOINED)
@Table(name="BLC_ORDER_PAYMENT_DETAILS")
public class PaymentInfoDetailImpl
implements PaymentInfoDetail {
    private static final long serialVersionUID = 1L;
    @Id
    @GeneratedValue(generator="PaymentInfoDetailId", strategy=GenerationType.TABLE)
    @TableGenerator(name="PaymentInfoDetailId", table="SEQUENCE_GENERATOR", pkColumnName="ID_NAME", valueColumnName="ID_VAL", pkColumnValue="PaymentInfoDetailImpl", allocationSize=50)
    @Column(name="PAYMENT_DETAIL_ID")
    protected Long id;
    @ManyToOne(targetEntity=PaymentInfoImpl.class, optional=false)
    @JoinColumn(name="PAYMENT_INFO")
    @AdminPresentation(excluded=true, visibility=VisibilityEnum.HIDDEN_ALL)
    protected PaymentInfo paymentInfo;
    @Column(name="PAYMENT_INFO_DETAIL_TYPE")
    @AdminPresentation(friendlyName="PaymentInfoDetailTypeImpl_Type")
    protected PaymentInfoDetailType type;
    @Column(name="PAYMENT_AMOUNT")
    @AdminPresentation(friendlyName="PaymentInfoDetailTypeImpl_Amount")
    protected BigDecimal amount;
    @ManyToOne(targetEntity=BroadleafCurrencyImpl.class)
    @JoinColumn(name="CURRENCY_CODE")
    @AdminPresentation(friendlyName="PaymentInfoDetailTypeImpl_Currency_Code")
    protected BroadleafCurrency currency;
    @Column(name="DATE_RECORDED")
    @AdminPresentation(friendlyName="PaymentInfoDetailTypeImpl_Date")
    protected Date date;

    @Override
    public Long getId() {
        return this.id;
    }

    @Override
    public void setId(Long id) {
        this.id = id;
    }

    @Override
    public PaymentInfo getPaymentInfo() {
        return this.paymentInfo;
    }

    @Override
    public void setPaymentInfo(PaymentInfo paymentInfo) {
        this.paymentInfo = paymentInfo;
    }

    @Override
    public PaymentInfoDetailType getType() {
        return this.type;
    }

    @Override
    public void setType(PaymentInfoDetailType type) {
        this.type = type;
    }

    @Override
    public Money getAmount() {
        return this.amount == null ? BroadleafCurrencyUtils.getMoney((BigDecimal)BigDecimal.ZERO, (BroadleafCurrency)this.getCurrency()) : BroadleafCurrencyUtils.getMoney((BigDecimal)this.amount, (BroadleafCurrency)this.getCurrency());
    }

    @Override
    public void setAmount(Money amount) {
        this.amount = amount.getAmount();
    }

    @Override
    public BroadleafCurrency getCurrency() {
        return this.currency;
    }

    @Override
    public void setCurrency(BroadleafCurrency currency) {
        this.currency = currency;
    }

    @Override
    public Date getDate() {
        return this.date;
    }

    @Override
    public void setDate(Date date) {
        this.date = date;
    }
}

