/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.core.order.fulfillment.domain;

import java.math.BigDecimal;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import org.broadleafcommerce.common.currency.domain.BroadleafCurrency;
import org.broadleafcommerce.common.currency.domain.BroadleafCurrencyImpl;
import org.broadleafcommerce.common.currency.util.BroadleafCurrencyUtils;
import org.broadleafcommerce.common.money.Money;
import org.broadleafcommerce.common.presentation.AdminPresentation;
import org.broadleafcommerce.common.presentation.AdminPresentationClass;
import org.broadleafcommerce.core.order.domain.FulfillmentOptionImpl;
import org.broadleafcommerce.core.order.fulfillment.domain.FixedPriceFulfillmentOption;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;

@Entity
@Inheritance(strategy=InheritanceType.JOINED)
@Table(name="BLC_FULFILLMENT_OPTION_FIXED")
@Cache(usage=CacheConcurrencyStrategy.READ_WRITE, region="blStandardElements")
@AdminPresentationClass(friendlyName="Fixed Price Fulfillment")
public class FixedPriceFulfillmentOptionImpl
extends FulfillmentOptionImpl
implements FixedPriceFulfillmentOption {
    private static final long serialVersionUID = 1L;
    @Column(name="PRICE", precision=19, scale=5, nullable=false)
    protected BigDecimal price;
    @ManyToOne(targetEntity=BroadleafCurrencyImpl.class)
    @JoinColumn(name="CURRENCY_CODE")
    @AdminPresentation(friendlyName="FixedPriceFulfillmentOptionImpl_Currency_Code", order=1, group="FixedPriceFulfillmentOptionImpl_Details", prominent=true)
    protected BroadleafCurrency currency;

    @Override
    public Money getPrice() {
        return this.price == null ? null : BroadleafCurrencyUtils.getMoney((BigDecimal)this.price, (BroadleafCurrency)this.getCurrency());
    }

    @Override
    public void setPrice(Money price) {
        this.price = Money.toAmount((Money)price);
    }

    @Override
    public BroadleafCurrency getCurrency() {
        return this.currency;
    }

    @Override
    public void setCurrency(BroadleafCurrency currency) {
        this.currency = currency;
    }
}

