/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.core.order.dao;

import java.util.ArrayList;
import java.util.List;
import org.broadleafcommerce.core.order.dao.OrderDaoExtensionListener;
import org.broadleafcommerce.core.order.domain.Order;
import org.broadleafcommerce.profile.core.domain.Customer;

public class OrderDaoExtensionManager
implements OrderDaoExtensionListener {
    protected List<OrderDaoExtensionListener> listeners = new ArrayList<OrderDaoExtensionListener>();

    @Override
    public void attachAdditionalDataToNewCart(Customer customer, Order cart) {
        for (OrderDaoExtensionListener listener : this.listeners) {
            listener.attachAdditionalDataToNewCart(customer, cart);
        }
    }

    @Override
    public void applyAdditionalOrderLookupFilter(Customer customer, String name, List<Order> orders) {
        for (OrderDaoExtensionListener listener : this.listeners) {
            listener.applyAdditionalOrderLookupFilter(customer, name, orders);
        }
    }

    public List<OrderDaoExtensionListener> getListeners() {
        return this.listeners;
    }

    public void setListeners(List<OrderDaoExtensionListener> listeners) {
        this.listeners = listeners;
    }
}

