/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.core.offer.service.discount;

import java.io.Serializable;
import java.util.Set;
import org.broadleafcommerce.core.offer.domain.Offer;
import org.broadleafcommerce.core.offer.domain.OfferItemCriteria;
import org.broadleafcommerce.core.offer.service.discount.domain.PromotableCandidateItemOffer;

public class PromotionDiscount
implements Serializable {
    private static final long serialVersionUID = 1L;
    private PromotableCandidateItemOffer candidateItemOffer;
    private Offer promotion;
    private Set<OfferItemCriteria> itemCriteria;
    private int quantity;
    private int finalizedQuantity;

    public Offer getPromotion() {
        return this.promotion;
    }

    public void setPromotion(Offer promotion) {
        this.promotion = promotion;
    }

    public Set<OfferItemCriteria> getItemCriteria() {
        return this.itemCriteria;
    }

    public void setItemCriteria(Set<OfferItemCriteria> itemCriteria) {
        this.itemCriteria = itemCriteria;
    }

    public int getQuantity() {
        return this.quantity;
    }

    public void setQuantity(int quantity) {
        this.quantity = quantity;
    }

    public int getFinalizedQuantity() {
        return this.finalizedQuantity;
    }

    public void setFinalizedQuantity(int finalizedQuantity) {
        this.finalizedQuantity = finalizedQuantity;
    }

    public void incrementQuantity(int quantity) {
        this.quantity += quantity;
    }

    public PromotableCandidateItemOffer getCandidateItemOffer() {
        return this.candidateItemOffer;
    }

    public void setCandidateItemOffer(PromotableCandidateItemOffer candidateItemOffer) {
        this.candidateItemOffer = candidateItemOffer;
    }

    public PromotionDiscount split(int splitQty) {
        PromotionDiscount returnDiscount = this.copy();
        int originalQty = this.finalizedQuantity;
        this.setFinalizedQuantity(splitQty);
        this.setQuantity(splitQty);
        int newDiscountQty = originalQty - splitQty;
        if (newDiscountQty == 0) {
            return null;
        }
        returnDiscount.setQuantity(newDiscountQty);
        returnDiscount.setFinalizedQuantity(newDiscountQty);
        return returnDiscount;
    }

    public PromotionDiscount copy() {
        PromotionDiscount pd = new PromotionDiscount();
        pd.setItemCriteria(this.itemCriteria);
        pd.setPromotion(this.promotion);
        pd.setQuantity(this.quantity);
        pd.setFinalizedQuantity(this.finalizedQuantity);
        pd.setCandidateItemOffer(this.candidateItemOffer);
        return pd;
    }

    public void resetQty(int qty) {
        this.quantity = qty;
        this.finalizedQuantity = qty;
    }
}

