/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.core.offer.domain;

import java.math.BigDecimal;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import org.broadleafcommerce.common.currency.domain.BroadleafCurrency;
import org.broadleafcommerce.common.currency.util.BroadleafCurrencyUtils;
import org.broadleafcommerce.common.money.Money;
import org.broadleafcommerce.common.presentation.AdminPresentation;
import org.broadleafcommerce.common.presentation.AdminPresentationClass;
import org.broadleafcommerce.common.presentation.PopulateToOneFieldsEnum;
import org.broadleafcommerce.common.presentation.client.SupportedFieldType;
import org.broadleafcommerce.common.presentation.override.AdminPresentationOverride;
import org.broadleafcommerce.common.presentation.override.AdminPresentationOverrides;
import org.broadleafcommerce.core.offer.domain.FulfillmentGroupAdjustment;
import org.broadleafcommerce.core.offer.domain.Offer;
import org.broadleafcommerce.core.offer.domain.OfferImpl;
import org.broadleafcommerce.core.order.domain.FulfillmentGroup;
import org.broadleafcommerce.core.order.domain.FulfillmentGroupImpl;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.hibernate.annotations.GenericGenerator;
import org.hibernate.annotations.Index;
import org.hibernate.annotations.Parameter;

@Entity
@Table(name="BLC_FG_ADJUSTMENT")
@Inheritance(strategy=InheritanceType.JOINED)
@Cache(usage=CacheConcurrencyStrategy.NONSTRICT_READ_WRITE, region="blOrderElements")
@AdminPresentationOverrides(value={@AdminPresentationOverride(name="offer.id", value=@AdminPresentation(excluded=true)), @AdminPresentationOverride(name="offer.description", value=@AdminPresentation(excluded=true)), @AdminPresentationOverride(name="offer.discountType", value=@AdminPresentation(excluded=true)), @AdminPresentationOverride(name="offer.value", value=@AdminPresentation(excluded=true)), @AdminPresentationOverride(name="offer.priority", value=@AdminPresentation(excluded=true)), @AdminPresentationOverride(name="offer.startDate", value=@AdminPresentation(excluded=true)), @AdminPresentationOverride(name="offer.endDate", value=@AdminPresentation(excluded=true)), @AdminPresentationOverride(name="offer.stackable", value=@AdminPresentation(excluded=true)), @AdminPresentationOverride(name="offer.targetSystem", value=@AdminPresentation(excluded=true)), @AdminPresentationOverride(name="offer.applyToSalePrice", value=@AdminPresentation(excluded=true)), @AdminPresentationOverride(name="offer.appliesToOrderRules", value=@AdminPresentation(excluded=true)), @AdminPresentationOverride(name="offer.appliesToCustomerRules", value=@AdminPresentation(excluded=true)), @AdminPresentationOverride(name="offer.applyDiscountToMarkedItems", value=@AdminPresentation(excluded=true)), @AdminPresentationOverride(name="offer.combinableWithOtherOffers", value=@AdminPresentation(excluded=true)), @AdminPresentationOverride(name="offer.deliveryType", value=@AdminPresentation(excluded=true)), @AdminPresentationOverride(name="offer.maxUses", value=@AdminPresentation(excluded=true)), @AdminPresentationOverride(name="offer.uses", value=@AdminPresentation(excluded=true)), @AdminPresentationOverride(name="offer.offerItemQualifierRuleType", value=@AdminPresentation(excluded=true)), @AdminPresentationOverride(name="offer.offerItemTargetRuleType", value=@AdminPresentation(excluded=true)), @AdminPresentationOverride(name="offer.targetItemCriteria", value=@AdminPresentation(excluded=true)), @AdminPresentationOverride(name="offer.totalitarianOffer", value=@AdminPresentation(excluded=true)), @AdminPresentationOverride(name="offer.treatAsNewFormat", value=@AdminPresentation(excluded=true))})
@AdminPresentationClass(populateToOneFields=PopulateToOneFieldsEnum.TRUE, friendlyName="FulfillmentGroupAdjustmentImpl_baseFulfillmentGroupAdjustment")
public class FulfillmentGroupAdjustmentImpl
implements FulfillmentGroupAdjustment {
    public static final long serialVersionUID = 1L;
    @Id
    @GeneratedValue(generator="FGAdjustmentId")
    @GenericGenerator(name="FGAdjustmentId", strategy="org.broadleafcommerce.common.persistence.IdOverrideTableGenerator", parameters={@Parameter(name="table_name", value="SEQUENCE_GENERATOR"), @Parameter(name="segment_column_name", value="ID_NAME"), @Parameter(name="value_column_name", value="ID_VAL"), @Parameter(name="segment_value", value="FulfillmentGroupAdjustmentImpl"), @Parameter(name="increment_size", value="50"), @Parameter(name="entity_name", value="org.broadleafcommerce.core.offer.domain.FulfillmentGroupAdjustmentImpl")})
    @Column(name="FG_ADJUSTMENT_ID")
    protected Long id;
    @ManyToOne(targetEntity=FulfillmentGroupImpl.class)
    @JoinColumn(name="FULFILLMENT_GROUP_ID")
    @Index(name="FGADJUSTMENT_INDEX", columnNames={"FULFILLMENT_GROUP_ID"})
    @AdminPresentation(excluded=true)
    protected FulfillmentGroup fulfillmentGroup;
    @ManyToOne(targetEntity=OfferImpl.class, optional=false)
    @JoinColumn(name="OFFER_ID")
    @Index(name="FGADJUSTMENT_OFFER_INDEX", columnNames={"OFFER_ID"})
    protected Offer offer;
    @Column(name="ADJUSTMENT_REASON", nullable=false)
    @AdminPresentation(friendlyName="FulfillmentGroupAdjustmentImpl_FG_Adjustment_Reason", order=1, group="FulfillmentGroupAdjustmentImpl_Description")
    protected String reason;
    @Column(name="ADJUSTMENT_VALUE", nullable=false, precision=19, scale=5)
    @AdminPresentation(friendlyName="FulfillmentGroupAdjustmentImpl_FG_Adjustment_Value", order=2, group="FulfillmentGroupAdjustmentImpl_Description", fieldType=SupportedFieldType.MONEY)
    protected BigDecimal value = Money.ZERO.getAmount();

    @Override
    public void init(FulfillmentGroup fulfillmentGroup, Offer offer, String reason) {
        this.fulfillmentGroup = fulfillmentGroup;
        this.offer = offer;
        this.reason = reason == null ? offer.getName() : reason;
    }

    @Override
    public Long getId() {
        return this.id;
    }

    @Override
    public void setId(Long id) {
        this.id = id;
    }

    @Override
    public FulfillmentGroup getFulfillmentGroup() {
        return this.fulfillmentGroup;
    }

    @Override
    public void setFulfillmentGroup(FulfillmentGroup fulfillmentGroup) {
        this.fulfillmentGroup = fulfillmentGroup;
    }

    @Override
    public Offer getOffer() {
        return this.offer;
    }

    public void setOffer(Offer offer) {
        this.offer = offer;
    }

    @Override
    public String getReason() {
        return this.reason;
    }

    @Override
    public void setReason(String reason) {
        this.reason = reason;
    }

    @Override
    public Money getValue() {
        return this.value == null ? null : BroadleafCurrencyUtils.getMoney((BigDecimal)this.value, (BroadleafCurrency)this.getFulfillmentGroup().getOrder().getCurrency());
    }

    @Override
    public void setValue(Money value) {
        this.value = value.getAmount();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.fulfillmentGroup == null ? 0 : this.fulfillmentGroup.hashCode());
        result = 31 * result + (this.offer == null ? 0 : this.offer.hashCode());
        result = 31 * result + (this.reason == null ? 0 : this.reason.hashCode());
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        FulfillmentGroupAdjustmentImpl other = (FulfillmentGroupAdjustmentImpl)obj;
        if (this.id != null && other.id != null) {
            return this.id.equals(other.id);
        }
        if (this.fulfillmentGroup == null ? other.fulfillmentGroup != null : !this.fulfillmentGroup.equals(other.fulfillmentGroup)) {
            return false;
        }
        if (this.offer == null ? other.offer != null : !this.offer.equals(other.offer)) {
            return false;
        }
        if (this.reason == null ? other.reason != null : !this.reason.equals(other.reason)) {
            return false;
        }
        return !(this.value == null ? other.value != null : !this.value.equals(other.value));
    }
}

