/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.core.catalog.domain;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import org.broadleafcommerce.common.presentation.AdminPresentation;
import org.broadleafcommerce.core.catalog.domain.Category;
import org.broadleafcommerce.core.catalog.domain.CategoryImpl;
import org.broadleafcommerce.core.catalog.domain.FeaturedProduct;
import org.broadleafcommerce.core.catalog.domain.Product;
import org.broadleafcommerce.core.catalog.domain.ProductImpl;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.hibernate.annotations.GenericGenerator;
import org.hibernate.annotations.Index;
import org.hibernate.annotations.Parameter;

@Entity
@Inheritance(strategy=InheritanceType.JOINED)
@Table(name="BLC_PRODUCT_FEATURED")
@Cache(usage=CacheConcurrencyStrategy.READ_WRITE, region="blStandardElements")
public class FeaturedProductImpl
implements FeaturedProduct {
    private static final long serialVersionUID = 1L;
    @Id
    @GeneratedValue(generator="FeaturedProductId")
    @GenericGenerator(name="FeaturedProductId", strategy="org.broadleafcommerce.common.persistence.IdOverrideTableGenerator", parameters={@Parameter(name="table_name", value="SEQUENCE_GENERATOR"), @Parameter(name="segment_column_name", value="ID_NAME"), @Parameter(name="value_column_name", value="ID_VAL"), @Parameter(name="segment_value", value="FeaturedProductImpl"), @Parameter(name="increment_size", value="50"), @Parameter(name="entity_name", value="org.broadleafcommerce.core.catalog.domain.FeaturedProductImpl")})
    @Column(name="FEATURED_PRODUCT_ID")
    protected Long id;
    @Column(name="SEQUENCE")
    protected Long sequence;
    @Column(name="PROMOTION_MESSAGE")
    @AdminPresentation(friendlyName="FeaturedProductImpl_Featured_Product_Promotion_Message", largeEntry=true)
    protected String promotionMessage;
    @ManyToOne(targetEntity=CategoryImpl.class)
    @JoinColumn(name="CATEGORY_ID")
    @Index(name="PRODFEATURED_CATEGORY_INDEX", columnNames={"CATEGORY_ID"})
    protected Category category = new CategoryImpl();
    @ManyToOne(targetEntity=ProductImpl.class)
    @JoinColumn(name="PRODUCT_ID")
    @Index(name="PRODFEATURED_PRODUCT_INDEX", columnNames={"PRODUCT_ID"})
    protected Product product = new ProductImpl();

    @Override
    public Long getId() {
        return this.id;
    }

    @Override
    public void setId(Long id) {
        this.id = id;
    }

    @Override
    public void setSequence(Long sequence) {
        this.sequence = sequence;
    }

    @Override
    public Long getSequence() {
        return this.sequence;
    }

    @Override
    public String getPromotionMessage() {
        return this.promotionMessage;
    }

    @Override
    public void setPromotionMessage(String promotionMessage) {
        this.promotionMessage = promotionMessage;
    }

    @Override
    public Category getCategory() {
        return this.category;
    }

    @Override
    public void setCategory(Category category) {
        this.category = category;
    }

    @Override
    public Product getProduct() {
        return this.product;
    }

    @Override
    public void setProduct(Product product) {
        this.product = product;
    }

    @Override
    public Product getRelatedProduct() {
        return this.product;
    }
}

