/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.core.payment.service.workflow;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.broadleafcommerce.common.money.Money;
import org.broadleafcommerce.core.payment.domain.PaymentInfo;
import org.broadleafcommerce.core.payment.domain.PaymentResponseItem;
import org.broadleafcommerce.core.payment.domain.Referenced;
import org.broadleafcommerce.core.payment.service.PaymentContextImpl;
import org.broadleafcommerce.core.payment.service.PaymentService;
import org.broadleafcommerce.core.payment.service.exception.PaymentException;
import org.broadleafcommerce.core.payment.service.workflow.CombinedPaymentContextSeed;
import org.broadleafcommerce.core.payment.service.workflow.PaymentActionType;
import org.broadleafcommerce.core.payment.service.workflow.WorkflowPaymentContext;
import org.broadleafcommerce.core.workflow.BaseActivity;
import org.broadleafcommerce.core.workflow.ProcessContext;
import org.broadleafcommerce.core.workflow.state.ActivityStateManagerImpl;

public class PaymentActivity
extends BaseActivity {
    public static final String ROLLBACK_PAYMENTCONTEXT = "rollback_paymentcontext";
    public static final String ROLLBACK_RESPONSEITEM = "rollback_responseitem";
    public static final String ROLLBACK_ACTIONTYPE = "rollback_actiontype";
    protected PaymentService paymentService;
    protected String userName;
    protected boolean automaticallyRegisterRollbackHandlerForPayment = true;

    public PaymentActivity() {
        this.setAutomaticallyRegisterRollbackHandler(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ProcessContext execute(ProcessContext context) throws Exception {
        Money remainingTotal;
        Money transactionTotal;
        CombinedPaymentContextSeed seed = ((WorkflowPaymentContext)context).getSeedData();
        Map<PaymentInfo, Referenced> infos = seed.getInfos();
        if (seed.getTransactionAmount() != null) {
            transactionTotal = seed.getTransactionAmount();
            remainingTotal = seed.getTransactionAmount();
        } else {
            transactionTotal = seed.getOrderTotal();
            remainingTotal = seed.getOrderTotal();
        }
        HashMap<PaymentInfo, Referenced> replaceItems = new HashMap<PaymentInfo, Referenced>();
        try {
            Iterator<PaymentInfo> itr = infos.keySet().iterator();
            while (itr.hasNext()) {
                PaymentResponseItem paymentResponseItem;
                PaymentInfo info = itr.next();
                if (!this.paymentService.isValidCandidate(info.getType()).booleanValue()) continue;
                Referenced referenced = infos.get(info);
                itr.remove();
                infos.remove(info);
                PaymentContextImpl paymentContext = new PaymentContextImpl(transactionTotal, remainingTotal, info, referenced, this.userName);
                if (seed.getActionType().equals(PaymentActionType.AUTHORIZE)) {
                    try {
                        paymentResponseItem = this.paymentService.authorize(paymentContext);
                    }
                    finally {
                        referenced.setReferenceNumber(info.getReferenceNumber());
                        replaceItems.put(info, referenced);
                    }
                } else if (seed.getActionType().equals(PaymentActionType.AUTHORIZEANDDEBIT)) {
                    try {
                        paymentResponseItem = this.paymentService.authorizeAndDebit(paymentContext);
                    }
                    finally {
                        referenced.setReferenceNumber(info.getReferenceNumber());
                        replaceItems.put(info, referenced);
                    }
                } else if (seed.getActionType().equals(PaymentActionType.BALANCE)) {
                    try {
                        paymentResponseItem = this.paymentService.balance(paymentContext);
                    }
                    finally {
                        referenced.setReferenceNumber(info.getReferenceNumber());
                        replaceItems.put(info, referenced);
                    }
                } else if (seed.getActionType().equals(PaymentActionType.CREDIT)) {
                    try {
                        paymentResponseItem = this.paymentService.credit(paymentContext);
                    }
                    finally {
                        referenced.setReferenceNumber(info.getReferenceNumber());
                        replaceItems.put(info, referenced);
                    }
                } else if (seed.getActionType().equals(PaymentActionType.DEBIT)) {
                    try {
                        paymentResponseItem = this.paymentService.debit(paymentContext);
                    }
                    finally {
                        referenced.setReferenceNumber(info.getReferenceNumber());
                        replaceItems.put(info, referenced);
                    }
                } else if (seed.getActionType().equals(PaymentActionType.VOID)) {
                    try {
                        paymentResponseItem = this.paymentService.voidPayment(paymentContext);
                    }
                    finally {
                        referenced.setReferenceNumber(info.getReferenceNumber());
                        replaceItems.put(info, referenced);
                    }
                } else if (seed.getActionType().equals(PaymentActionType.REVERSEAUTHORIZE)) {
                    try {
                        paymentResponseItem = this.paymentService.reverseAuthorize(paymentContext);
                    }
                    finally {
                        referenced.setReferenceNumber(info.getReferenceNumber());
                        replaceItems.put(info, referenced);
                    }
                } else if (seed.getActionType().equals(PaymentActionType.PARTIALPAYMENT)) {
                    try {
                        paymentResponseItem = this.paymentService.partialPayment(paymentContext);
                    }
                    finally {
                        referenced.setReferenceNumber(info.getReferenceNumber());
                        replaceItems.put(info, referenced);
                    }
                } else {
                    referenced.setReferenceNumber(info.getReferenceNumber());
                    replaceItems.put(info, referenced);
                    throw new PaymentException("Module (" + this.paymentService.getClass().getName() + ") does not support payment type of: " + seed.getActionType().toString());
                }
                if (this.getRollbackHandler() != null && this.automaticallyRegisterRollbackHandlerForPayment) {
                    HashMap<String, Object> myState = new HashMap<String, Object>();
                    if (this.getStateConfiguration() != null && !this.getStateConfiguration().isEmpty()) {
                        myState.putAll(this.getStateConfiguration());
                    }
                    myState.put(ROLLBACK_ACTIONTYPE, seed.getActionType());
                    myState.put(ROLLBACK_PAYMENTCONTEXT, paymentContext);
                    myState.put(ROLLBACK_RESPONSEITEM, paymentResponseItem);
                    ActivityStateManagerImpl.getStateManager().registerState(this, context, this.getRollbackHandler(), myState);
                }
                if (paymentResponseItem == null) continue;
                if (paymentResponseItem.getTransactionAmount() == null || paymentResponseItem.getTransactionTimestamp() == null || paymentResponseItem.getTransactionSuccess() == null) {
                    throw new PaymentException("The PaymentResponseItem instance did not contain one or more of the following: transactionAmount, transactionTimestamp or transactionSuccess");
                }
                seed.getPaymentResponse().addPaymentResponseItem(info, paymentResponseItem);
                remainingTotal = remainingTotal.subtract(paymentResponseItem.getTransactionAmount());
            }
        }
        finally {
            infos.putAll(replaceItems);
        }
        return context;
    }

    public PaymentService getPaymentService() {
        return this.paymentService;
    }

    public void setPaymentService(PaymentService paymentService) {
        this.paymentService = paymentService;
    }

    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public boolean getAutomaticallyRegisterRollbackHandlerForPayment() {
        return this.automaticallyRegisterRollbackHandlerForPayment;
    }

    public void setAutomaticallyRegisterRollbackHandlerForPayment(boolean automaticallyRegisterRollbackHandlerForPayment) {
        this.automaticallyRegisterRollbackHandlerForPayment = automaticallyRegisterRollbackHandlerForPayment;
    }
}

