/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.core.offer.service.processor;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import org.broadleafcommerce.common.money.Money;
import org.broadleafcommerce.core.offer.domain.Offer;
import org.broadleafcommerce.core.offer.domain.OfferItemCriteria;
import org.broadleafcommerce.core.offer.service.discount.CandidatePromotionItems;
import org.broadleafcommerce.core.offer.service.discount.ItemOfferComparator;
import org.broadleafcommerce.core.offer.service.discount.OrderOfferComparator;
import org.broadleafcommerce.core.offer.service.discount.PromotionDiscount;
import org.broadleafcommerce.core.offer.service.discount.domain.PromotableCandidateItemOffer;
import org.broadleafcommerce.core.offer.service.discount.domain.PromotableCandidateOrderOffer;
import org.broadleafcommerce.core.offer.service.discount.domain.PromotableFulfillmentGroup;
import org.broadleafcommerce.core.offer.service.discount.domain.PromotableOrder;
import org.broadleafcommerce.core.offer.service.discount.domain.PromotableOrderItem;
import org.broadleafcommerce.core.offer.service.discount.domain.PromotableOrderItemPriceDetail;
import org.broadleafcommerce.core.offer.service.discount.domain.PromotableOrderItemPriceDetailAdjustment;
import org.broadleafcommerce.core.offer.service.processor.ItemOfferProcessor;
import org.broadleafcommerce.core.offer.service.processor.OrderOfferProcessorImpl;
import org.broadleafcommerce.core.offer.service.type.OfferType;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service(value="blItemOfferProcessor")
public class ItemOfferProcessorImpl
extends OrderOfferProcessorImpl
implements ItemOfferProcessor {
    @Override
    public void filterItemLevelOffer(PromotableOrder order, List<PromotableCandidateItemOffer> qualifiedItemOffers, Offer offer) {
        boolean isNewFormat = !CollectionUtils.isEmpty(offer.getQualifyingItemCriteria()) || !CollectionUtils.isEmpty(offer.getTargetItemCriteria());
        boolean itemLevelQualification = false;
        boolean offerCreated = false;
        block0: for (PromotableOrderItem promotableOrderItem : order.getDiscountableOrderItems()) {
            if (this.couldOfferApplyToOrder(offer, order, promotableOrderItem)) {
                if (!isNewFormat) {
                    PromotableCandidateItemOffer candidate = this.createCandidateItemOffer(qualifiedItemOffers, offer, order);
                    if (!candidate.getCandidateTargets().contains(promotableOrderItem)) {
                        candidate.getCandidateTargets().add(promotableOrderItem);
                    }
                    offerCreated = true;
                    continue;
                }
                itemLevelQualification = true;
                break;
            }
            for (PromotableFulfillmentGroup fulfillmentGroup : order.getFulfillmentGroups()) {
                if (!this.couldOfferApplyToOrder(offer, order, promotableOrderItem, fulfillmentGroup)) continue;
                if (!isNewFormat) {
                    PromotableCandidateItemOffer candidate = this.createCandidateItemOffer(qualifiedItemOffers, offer, order);
                    if (!candidate.getCandidateTargets().contains(promotableOrderItem)) {
                        candidate.getCandidateTargets().add(promotableOrderItem);
                    }
                    offerCreated = true;
                    continue;
                }
                itemLevelQualification = true;
                continue block0;
            }
        }
        if (itemLevelQualification && !offerCreated) {
            CandidatePromotionItems candidates = this.couldOfferApplyToOrderItems(offer, order.getDiscountableOrderItems(offer.getApplyDiscountToSalePrice()));
            PromotableCandidateItemOffer candidateOffer = null;
            if (candidates.isMatchedQualifier()) {
                candidateOffer = this.createCandidateItemOffer(qualifiedItemOffers, offer, order);
                candidateOffer.getCandidateQualifiersMap().putAll(candidates.getCandidateQualifiersMap());
            }
            if (candidates.isMatchedTarget() && candidates.isMatchedQualifier()) {
                if (candidateOffer == null) {
                    candidateOffer = this.createCandidateItemOffer(qualifiedItemOffers, offer, order);
                }
                candidateOffer.getCandidateTargets().addAll(candidates.getCandidateTargets());
            }
        }
    }

    protected PromotableCandidateItemOffer createCandidateItemOffer(List<PromotableCandidateItemOffer> qualifiedItemOffers, Offer offer, PromotableOrder promotableOrder) {
        PromotableCandidateItemOffer promotableCandidateItemOffer = this.promotableItemFactory.createPromotableCandidateItemOffer(promotableOrder, offer);
        qualifiedItemOffers.add(promotableCandidateItemOffer);
        return promotableCandidateItemOffer;
    }

    @Override
    public void applyAllItemOffers(List<PromotableCandidateItemOffer> itemOffers, PromotableOrder order) {
        for (PromotableCandidateItemOffer itemOffer : itemOffers) {
            if (!this.offerMeetsSubtotalRequirements(order, itemOffer)) continue;
            this.applyItemOffer(order, itemOffer);
        }
    }

    protected boolean offerMeetsSubtotalRequirements(PromotableOrder order, PromotableCandidateItemOffer itemOffer) {
        return itemOffer.getOffer().getQualifyingItemSubTotal() == null || itemOffer.getOffer().getQualifyingItemSubTotal().lessThanOrEqual(Money.ZERO);
    }

    protected boolean isTotalitarianOfferAppliedToAnyItem(PromotableOrder order) {
        List<PromotableOrderItemPriceDetail> allPriceDetails = order.getAllPromotableOrderItemPriceDetails();
        for (PromotableOrderItemPriceDetail targetItem : allPriceDetails) {
            if (!targetItem.isTotalitarianOfferApplied()) continue;
            return true;
        }
        return false;
    }

    protected void applyOrderItemAdjustment(PromotableCandidateItemOffer itemOffer, PromotableOrderItemPriceDetail itemPriceDetail) {
        PromotableOrderItemPriceDetailAdjustment promotableOrderItemPriceDetailAdjustment = this.promotableItemFactory.createPromotableOrderItemPriceDetailAdjustment(itemOffer, itemPriceDetail);
        itemPriceDetail.addCandidateItemPriceDetailAdjustment(promotableOrderItemPriceDetailAdjustment);
    }

    protected void applyAdjustments(PromotableOrder order, PromotableCandidateItemOffer itemOffer) {
        List<PromotableOrderItemPriceDetail> itemPriceDetails = order.getAllPromotableOrderItemPriceDetails();
        block0: for (PromotableOrderItemPriceDetail itemPriceDetail : itemPriceDetails) {
            for (PromotionDiscount discount : itemPriceDetail.getPromotionDiscounts()) {
                if (!discount.getPromotion().equals(itemOffer.getOffer())) continue;
                if ((itemOffer.getOffer().isTotalitarianOffer().booleanValue() || !itemOffer.getOffer().isCombinableWithOtherOffers()) && this.adjustmentIsNotGoodEnoughToBeApplied(itemOffer, itemPriceDetail)) continue block0;
                this.applyOrderItemAdjustment(itemOffer, itemPriceDetail);
                continue block0;
            }
        }
    }

    protected void applyLegacyAdjustments(PromotableOrder order, PromotableCandidateItemOffer itemOffer) {
        for (PromotableOrderItem item : itemOffer.getCandidateTargets()) {
            for (PromotableOrderItemPriceDetail itemPriceDetail : item.getPromotableOrderItemPriceDetails()) {
                if (!itemOffer.getOffer().isStackable() || !itemOffer.getOffer().isCombinableWithOtherOffers() ? itemPriceDetail.getCandidateItemAdjustments().size() != 0 : itemPriceDetail.hasNonCombinableAdjustments()) continue;
                this.applyOrderItemAdjustment(itemOffer, itemPriceDetail);
            }
        }
    }

    protected boolean adjustmentIsNotGoodEnoughToBeApplied(PromotableCandidateItemOffer itemOffer, PromotableOrderItemPriceDetail detail) {
        if (!itemOffer.getOffer().getApplyDiscountToSalePrice()) {
            Money salePrice = detail.getPromotableOrderItem().getSalePriceBeforeAdjustments();
            Money retailPrice = detail.getPromotableOrderItem().getRetailPriceBeforeAdjustments();
            Money savings = itemOffer.calculateSavingsForOrderItem(detail.getPromotableOrderItem(), 1);
            if (salePrice != null && salePrice.lessThan(retailPrice.subtract(savings))) {
                return true;
            }
        }
        return false;
    }

    protected boolean itemOfferCanBeApplied(PromotableOrder order, PromotableCandidateItemOffer itemOffer) {
        for (PromotableOrderItemPriceDetail detail : order.getAllPromotableOrderItemPriceDetails()) {
            for (PromotableOrderItemPriceDetailAdjustment adjustment : detail.getCandidateItemAdjustments()) {
                if (adjustment.isTotalitarian() || itemOffer.getOffer().isTotalitarianOffer().booleanValue()) {
                    return false;
                }
                if (itemOffer.isLegacyOffer() || adjustment.isCombinable() && itemOffer.getOffer().isCombinableWithOtherOffers()) continue;
                return false;
            }
        }
        return true;
    }

    protected void applyItemOffer(PromotableOrder order, PromotableCandidateItemOffer itemOffer) {
        if (this.itemOfferCanBeApplied(order, itemOffer)) {
            this.applyItemQualifiersAndTargets(itemOffer, order);
            if (itemOffer.isLegacyOffer()) {
                this.applyLegacyAdjustments(order, itemOffer);
            } else {
                this.applyAdjustments(order, itemOffer);
            }
        }
    }

    protected void chooseSaleOrRetailAdjustments(PromotableOrder order) {
        List<PromotableOrderItemPriceDetail> itemPriceDetails = order.getAllPromotableOrderItemPriceDetails();
        for (PromotableOrderItemPriceDetail itemDetail : itemPriceDetails) {
            itemDetail.chooseSaleOrRetailAdjustments();
        }
        this.mergePriceDetails(order);
    }

    protected void mergePriceDetails(PromotableOrder order) {
        List<PromotableOrderItem> items = order.getAllOrderItems();
        for (PromotableOrderItem item : items) {
            item.mergeLikeDetails();
        }
    }

    protected void applyItemQualifiersAndTargets(PromotableCandidateItemOffer itemOffer, PromotableOrder order) {
        if (itemOffer.isLegacyOffer()) {
            return;
        }
        this.markQualifiersAndTargets(order, itemOffer);
        this.splitDetailsIfNecessary(order.getAllPromotableOrderItemPriceDetails());
    }

    protected List<PromotableOrderItemPriceDetail> buildPriceDetailListFromOrderItems(List<PromotableOrderItem> items) {
        ArrayList<PromotableOrderItemPriceDetail> itemPriceDetails = new ArrayList<PromotableOrderItemPriceDetail>();
        for (PromotableOrderItem item : items) {
            for (PromotableOrderItemPriceDetail detail : item.getPromotableOrderItemPriceDetails()) {
                itemPriceDetails.add(detail);
            }
        }
        return itemPriceDetails;
    }

    protected boolean markQualifiers(PromotableCandidateItemOffer itemOffer, PromotableOrder order) {
        for (OfferItemCriteria itemCriteria : itemOffer.getCandidateQualifiersMap().keySet()) {
            List<PromotableOrderItem> promotableItems = itemOffer.getCandidateQualifiersMap().get(itemCriteria);
            List<PromotableOrderItemPriceDetail> priceDetails = this.buildPriceDetailListFromOrderItems(promotableItems);
            Collections.sort(priceDetails, this.getQualifierItemComparator(itemOffer.getOffer().getApplyDiscountToSalePrice()));
            int qualifierQtyNeeded = itemCriteria.getQuantity();
            for (PromotableOrderItemPriceDetail detail : priceDetails) {
                int itemQtyAvailableToBeUsedAsQualifier;
                if (qualifierQtyNeeded > 0 && (itemQtyAvailableToBeUsedAsQualifier = detail.getQuantityAvailableToBeUsedAsQualifier(itemOffer)) > 0) {
                    int qtyToMarkAsQualifier = Math.min(qualifierQtyNeeded, itemQtyAvailableToBeUsedAsQualifier);
                    qualifierQtyNeeded -= qtyToMarkAsQualifier;
                    detail.addPromotionQualifier(itemOffer, itemCriteria, qtyToMarkAsQualifier);
                }
                if (qualifierQtyNeeded != 0) continue;
                break;
            }
            if (qualifierQtyNeeded == 0) continue;
            return false;
        }
        return true;
    }

    protected boolean markTargets(PromotableCandidateItemOffer itemOffer, PromotableOrder order) {
        Offer promotion = itemOffer.getOffer();
        List<PromotableOrderItem> promotableItems = itemOffer.getCandidateTargets();
        List<PromotableOrderItemPriceDetail> priceDetails = this.buildPriceDetailListFromOrderItems(promotableItems);
        int receiveQtyNeeded = 0;
        for (OfferItemCriteria targetCriteria : itemOffer.getOffer().getTargetItemCriteria()) {
            receiveQtyNeeded += targetCriteria.getQuantity().intValue();
        }
        Collections.sort(priceDetails, this.getTargetItemComparator(promotion.getApplyDiscountToSalePrice()));
        for (PromotableOrderItemPriceDetail priceDetail : priceDetails) {
            int itemQtyAvailableToBeUsedAsTarget;
            if (receiveQtyNeeded > 0 && (itemQtyAvailableToBeUsedAsTarget = priceDetail.getQuantityAvailableToBeUsedAsTarget(itemOffer)) > 0 && (promotion.getMaxUses() == 0 || itemOffer.getUses() < promotion.getMaxUses())) {
                int qtyToMarkAsTarget = Math.min(receiveQtyNeeded, itemQtyAvailableToBeUsedAsTarget);
                receiveQtyNeeded -= qtyToMarkAsTarget;
                priceDetail.addPromotionDiscount(itemOffer, itemOffer.getOffer().getTargetItemCriteria(), qtyToMarkAsTarget);
            }
            if (receiveQtyNeeded != 0) continue;
            itemOffer.addUse();
            break;
        }
        return receiveQtyNeeded == 0;
    }

    protected Comparator<PromotableOrderItemPriceDetail> getQualifierItemComparator(final boolean applyToSalePrice) {
        return new Comparator<PromotableOrderItemPriceDetail>(){

            @Override
            public int compare(PromotableOrderItemPriceDetail o1, PromotableOrderItemPriceDetail o2) {
                Money price = o1.getPromotableOrderItem().getPriceBeforeAdjustments(applyToSalePrice);
                Money price2 = o2.getPromotableOrderItem().getPriceBeforeAdjustments(applyToSalePrice);
                return price2.compareTo(price);
            }
        };
    }

    protected Comparator<PromotableOrderItemPriceDetail> getTargetItemComparator(final boolean applyToSalePrice) {
        return new Comparator<PromotableOrderItemPriceDetail>(){

            @Override
            public int compare(PromotableOrderItemPriceDetail o1, PromotableOrderItemPriceDetail o2) {
                Money price = o1.getPromotableOrderItem().getPriceBeforeAdjustments(applyToSalePrice);
                Money price2 = o2.getPromotableOrderItem().getPriceBeforeAdjustments(applyToSalePrice);
                return price2.compareTo(price);
            }
        };
    }

    @Override
    public void filterOffers(PromotableOrder order, List<Offer> filteredOffers, List<PromotableCandidateOrderOffer> qualifiedOrderOffers, List<PromotableCandidateItemOffer> qualifiedItemOffers) {
        order.setOrderSubTotalToPriceWithoutAdjustments();
        for (Offer offer : filteredOffers) {
            if (offer.getType().equals(OfferType.ORDER)) {
                this.filterOrderLevelOffer(order, qualifiedOrderOffers, offer);
                continue;
            }
            if (!offer.getType().equals(OfferType.ORDER_ITEM)) continue;
            this.filterItemLevelOffer(order, qualifiedItemOffers, offer);
        }
    }

    protected void calculatePotentialSavings(List<PromotableCandidateItemOffer> itemOffers, PromotableOrder order) {
        if (itemOffers.size() > 1) {
            for (PromotableCandidateItemOffer itemOffer : itemOffers) {
                Money potentialSavings = new Money(order.getOrderCurrency());
                if (itemOffer.isLegacyOffer()) {
                    for (PromotableOrderItem item : itemOffer.getCandidateTargets()) {
                        potentialSavings = potentialSavings.add(itemOffer.calculateSavingsForOrderItem(item, item.getQuantity()));
                    }
                } else {
                    this.markQualifiersAndTargets(order, itemOffer);
                    for (PromotableOrderItemPriceDetail detail : order.getAllPromotableOrderItemPriceDetails()) {
                        PromotableOrderItem item = detail.getPromotableOrderItem();
                        for (PromotionDiscount discount : detail.getPromotionDiscounts()) {
                            potentialSavings = potentialSavings.add(itemOffer.calculateSavingsForOrderItem(item, discount.getQuantity()));
                        }
                        detail.getPromotionDiscounts().clear();
                        detail.getPromotionQualifiers().clear();
                    }
                }
                itemOffer.setPotentialSavings(potentialSavings);
            }
        }
    }

    protected void markQualifiersAndTargets(PromotableOrder order, PromotableCandidateItemOffer itemOffer) {
        boolean matchFound = true;
        if (itemOffer.getOffer().getQualifyingItemCriteria().isEmpty() && itemOffer.getOffer().getTargetItemCriteria().isEmpty()) {
            return;
        }
        boolean count = true;
        do {
            boolean qualifiersFound = this.markQualifiers(itemOffer, order);
            boolean targetsFound = this.markTargets(itemOffer, order);
            if (!qualifiersFound || !targetsFound) {
                this.clearAllNonFinalizedQuantities(order.getAllPromotableOrderItemPriceDetails());
                matchFound = false;
                break;
            }
            this.finalizeQuantities(order.getAllPromotableOrderItemPriceDetails());
        } while (matchFound);
    }

    protected boolean offerListStartsWithNonCombinable(List<PromotableCandidateItemOffer> offerList) {
        PromotableCandidateItemOffer offer;
        return offerList.size() > 1 && ((offer = offerList.get(0)).getOffer().isTotalitarianOffer() != false || !offer.getOffer().isCombinableWithOtherOffers());
    }

    protected List<List<PromotableCandidateItemOffer>> buildItemOfferPermutations(List<PromotableCandidateItemOffer> offers) {
        ArrayList<List<PromotableCandidateItemOffer>> listOfOfferLists = new ArrayList<List<PromotableCandidateItemOffer>>();
        listOfOfferLists.add(offers);
        if (this.offerListStartsWithNonCombinable(offers)) {
            ArrayList<PromotableCandidateItemOffer> listWithoutTotalitarianOrNonCombinables = new ArrayList<PromotableCandidateItemOffer>(offers);
            Iterator offerIterator = listWithoutTotalitarianOrNonCombinables.iterator();
            while (offerIterator.hasNext()) {
                PromotableCandidateItemOffer offer = (PromotableCandidateItemOffer)offerIterator.next();
                if (!offer.getOffer().isTotalitarianOffer().booleanValue() && offer.getOffer().isCombinableWithOtherOffers()) continue;
                offerIterator.remove();
            }
            if (listWithoutTotalitarianOrNonCombinables.size() > 0) {
                listOfOfferLists.add(listWithoutTotalitarianOrNonCombinables);
            }
        }
        return listOfOfferLists;
    }

    protected void determineBestPermutation(List<PromotableCandidateItemOffer> itemOffers, PromotableOrder order) {
        List<List<PromotableCandidateItemOffer>> permutations = this.buildItemOfferPermutations(itemOffers);
        List<PromotableCandidateItemOffer> bestOfferList = null;
        Money lowestSubtotal = null;
        if (permutations.size() > 1) {
            for (List<PromotableCandidateItemOffer> offerList : permutations) {
                this.applyAllItemOffers(offerList, order);
                this.chooseSaleOrRetailAdjustments(order);
                Money testSubtotal = order.calculateSubtotalWithAdjustments();
                if (lowestSubtotal == null || testSubtotal.lessThan(lowestSubtotal)) {
                    lowestSubtotal = testSubtotal;
                    bestOfferList = offerList;
                }
                for (PromotableOrderItem item : order.getDiscountableOrderItems()) {
                    item.resetPriceDetails();
                }
            }
        } else {
            bestOfferList = permutations.get(0);
        }
        this.applyAllItemOffers(bestOfferList, order);
    }

    @Override
    public void applyAndCompareOrderAndItemOffers(PromotableOrder order, List<PromotableCandidateOrderOffer> qualifiedOrderOffers, List<PromotableCandidateItemOffer> qualifiedItemOffers) {
        if (!qualifiedItemOffers.isEmpty()) {
            this.calculatePotentialSavings(qualifiedItemOffers, order);
            Collections.sort(qualifiedItemOffers, ItemOfferComparator.INSTANCE);
            if (qualifiedItemOffers.size() > 1) {
                this.determineBestPermutation(qualifiedItemOffers, order);
            } else {
                this.applyAllItemOffers(qualifiedItemOffers, order);
            }
        }
        this.chooseSaleOrRetailAdjustments(order);
        order.setOrderSubTotalToPriceWithAdjustments();
        if (!qualifiedOrderOffers.isEmpty()) {
            Collections.sort(qualifiedOrderOffers, OrderOfferComparator.INSTANCE);
            this.applyAllOrderOffers(qualifiedOrderOffers, order);
        }
        order.setOrderSubTotalToPriceWithAdjustments();
        if (!qualifiedOrderOffers.isEmpty() && !qualifiedItemOffers.isEmpty()) {
            ArrayList<PromotableCandidateOrderOffer> finalQualifiedOrderOffers = new ArrayList<PromotableCandidateOrderOffer>();
            order.removeAllCandidateOrderOfferAdjustments();
            for (PromotableCandidateOrderOffer candidateOrderOffer : qualifiedOrderOffers) {
                if (!this.couldOfferApplyToOrder(candidateOrderOffer.getOffer(), order)) continue;
                finalQualifiedOrderOffers.add(candidateOrderOffer);
            }
            Collections.sort(finalQualifiedOrderOffers, OrderOfferComparator.INSTANCE);
            if (!finalQualifiedOrderOffers.isEmpty()) {
                this.applyAllOrderOffers(finalQualifiedOrderOffers, order);
                order.setOrderSubTotalToPriceWithAdjustments();
            }
        }
    }

    private void removeTrailingNonCombinableOrTotalitarianOffers(List<PromotableCandidateItemOffer> qualifiedItemOffers) {
        boolean first = true;
        Iterator<PromotableCandidateItemOffer> offerIterator = qualifiedItemOffers.iterator();
        if (offerIterator.hasNext()) {
            offerIterator.next();
        }
        while (offerIterator.hasNext()) {
            PromotableCandidateItemOffer itemOffer = offerIterator.next();
            if (itemOffer.getOffer().isTotalitarianOffer().booleanValue()) {
                offerIterator.remove();
                continue;
            }
            if (itemOffer.isLegacyOffer() || itemOffer.getOffer().isCombinableWithOtherOffers()) continue;
            offerIterator.remove();
        }
    }
}

