/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.core.offer.service.discount.domain;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.List;
import org.broadleafcommerce.common.currency.domain.BroadleafCurrency;
import org.broadleafcommerce.common.currency.util.BroadleafCurrencyUtils;
import org.broadleafcommerce.common.money.Money;
import org.broadleafcommerce.core.offer.domain.Offer;
import org.broadleafcommerce.core.offer.domain.OfferItemCriteria;
import org.broadleafcommerce.core.offer.service.discount.domain.PromotableCandidateOrderOffer;
import org.broadleafcommerce.core.offer.service.discount.domain.PromotableOrder;
import org.broadleafcommerce.core.offer.service.discount.domain.PromotableOrderItem;
import org.broadleafcommerce.core.offer.service.type.OfferDiscountType;

public class PromotableCandidateOrderOfferImpl
implements PromotableCandidateOrderOffer {
    private static final long serialVersionUID = 1L;
    protected HashMap<OfferItemCriteria, List<PromotableOrderItem>> candidateQualifiersMap = new HashMap();
    protected Offer offer;
    protected PromotableOrder promotableOrder;
    protected Money potentialSavings;

    public PromotableCandidateOrderOfferImpl(PromotableOrder promotableOrder, Offer offer) {
        assert (offer != null);
        assert (promotableOrder != null);
        this.promotableOrder = promotableOrder;
        this.offer = offer;
        this.calculatePotentialSavings();
    }

    @Override
    public HashMap<OfferItemCriteria, List<PromotableOrderItem>> getCandidateQualifiersMap() {
        return this.candidateQualifiersMap;
    }

    protected void calculatePotentialSavings() {
        Money amountBeforeAdjustments = this.promotableOrder.calculateSubtotalWithoutAdjustments();
        this.potentialSavings = BroadleafCurrencyUtils.getMoney((BigDecimal)BigDecimal.ZERO, (BroadleafCurrency)this.getCurrency());
        if (this.getOffer().getDiscountType().equals(OfferDiscountType.AMOUNT_OFF)) {
            this.potentialSavings = BroadleafCurrencyUtils.getMoney((BigDecimal)this.getOffer().getValue(), (BroadleafCurrency)this.getCurrency());
        } else if (this.getOffer().getDiscountType().equals(OfferDiscountType.FIX_PRICE)) {
            this.potentialSavings = amountBeforeAdjustments.subtract(BroadleafCurrencyUtils.getMoney((BigDecimal)this.getOffer().getValue(), (BroadleafCurrency)this.getCurrency()));
        } else if (this.getOffer().getDiscountType().equals(OfferDiscountType.PERCENT_OFF)) {
            this.potentialSavings = amountBeforeAdjustments.multiply(this.getOffer().getValue().divide(new BigDecimal("100")));
        }
        if (this.potentialSavings.greaterThan(amountBeforeAdjustments)) {
            this.potentialSavings = amountBeforeAdjustments;
        }
    }

    @Override
    public Offer getOffer() {
        return this.offer;
    }

    @Override
    public PromotableOrder getPromotableOrder() {
        return this.promotableOrder;
    }

    public BroadleafCurrency getCurrency() {
        return this.promotableOrder.getOrderCurrency();
    }

    @Override
    public Money getPotentialSavings() {
        return this.potentialSavings;
    }

    @Override
    public boolean isCombinable() {
        Boolean combinable = this.offer.isCombinableWithOtherOffers();
        return combinable != null && combinable != false;
    }

    @Override
    public boolean isTotalitarian() {
        Boolean totalitarian = this.offer.isTotalitarianOffer();
        return totalitarian != null && totalitarian != false;
    }

    @Override
    public int getPriority() {
        return this.offer.getPriority();
    }
}

