/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.core.catalog.domain;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Embedded;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import javax.persistence.OrderBy;
import javax.persistence.Table;
import javax.persistence.Transient;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.Predicate;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.broadleafcommerce.common.persistence.ArchiveStatus;
import org.broadleafcommerce.common.persistence.Status;
import org.broadleafcommerce.common.presentation.AdminPresentation;
import org.broadleafcommerce.common.presentation.AdminPresentationAdornedTargetCollection;
import org.broadleafcommerce.common.presentation.AdminPresentationClass;
import org.broadleafcommerce.common.presentation.AdminPresentationCollection;
import org.broadleafcommerce.common.presentation.AdminPresentationToOneLookup;
import org.broadleafcommerce.common.presentation.PopulateToOneFieldsEnum;
import org.broadleafcommerce.common.presentation.RequiredOverride;
import org.broadleafcommerce.common.presentation.client.AddMethodType;
import org.broadleafcommerce.common.presentation.client.VisibilityEnum;
import org.broadleafcommerce.common.util.BLCMapUtils;
import org.broadleafcommerce.common.util.DateUtil;
import org.broadleafcommerce.common.util.TypedClosure;
import org.broadleafcommerce.common.vendor.service.type.ContainerShapeType;
import org.broadleafcommerce.common.vendor.service.type.ContainerSizeType;
import org.broadleafcommerce.core.catalog.domain.Category;
import org.broadleafcommerce.core.catalog.domain.CategoryImpl;
import org.broadleafcommerce.core.catalog.domain.CrossSaleProductImpl;
import org.broadleafcommerce.core.catalog.domain.Dimension;
import org.broadleafcommerce.core.catalog.domain.Product;
import org.broadleafcommerce.core.catalog.domain.ProductAttribute;
import org.broadleafcommerce.core.catalog.domain.ProductAttributeImpl;
import org.broadleafcommerce.core.catalog.domain.ProductOption;
import org.broadleafcommerce.core.catalog.domain.ProductOptionImpl;
import org.broadleafcommerce.core.catalog.domain.RelatedProduct;
import org.broadleafcommerce.core.catalog.domain.Sku;
import org.broadleafcommerce.core.catalog.domain.SkuImpl;
import org.broadleafcommerce.core.catalog.domain.UpSaleProductImpl;
import org.broadleafcommerce.core.catalog.domain.Weight;
import org.broadleafcommerce.core.media.domain.Media;
import org.hibernate.annotations.BatchSize;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.hibernate.annotations.Cascade;
import org.hibernate.annotations.GenericGenerator;
import org.hibernate.annotations.Index;
import org.hibernate.annotations.Parameter;
import org.hibernate.annotations.SQLDelete;

@Entity
@Inheritance(strategy=InheritanceType.JOINED)
@Table(name="BLC_PRODUCT")
@Cache(usage=CacheConcurrencyStrategy.READ_WRITE, region="blStandardElements")
@AdminPresentationClass(populateToOneFields=PopulateToOneFieldsEnum.TRUE, friendlyName="baseProduct")
@SQLDelete(sql="UPDATE BLC_PRODUCT SET ARCHIVED = 'Y' WHERE PRODUCT_ID = ?")
public class ProductImpl
implements Product,
Status {
    private static final Log LOG = LogFactory.getLog(ProductImpl.class);
    private static final long serialVersionUID = 1L;
    @Id
    @GeneratedValue(generator="ProductId")
    @GenericGenerator(name="ProductId", strategy="org.broadleafcommerce.common.persistence.IdOverrideTableGenerator", parameters={@Parameter(name="table_name", value="SEQUENCE_GENERATOR"), @Parameter(name="segment_column_name", value="ID_NAME"), @Parameter(name="value_column_name", value="ID_VAL"), @Parameter(name="segment_value", value="ProductImpl"), @Parameter(name="increment_size", value="50"), @Parameter(name="entity_name", value="org.broadleafcommerce.core.catalog.domain.ProductImpl")})
    @Column(name="PRODUCT_ID")
    @AdminPresentation(friendlyName="ProductImpl_Product_ID", group="ProductImpl_Primary_Key", visibility=VisibilityEnum.HIDDEN_ALL)
    protected Long id;
    @Column(name="URL")
    @AdminPresentation(friendlyName="ProductImpl_Product_Url", order=1, group="Seo_Group", groupOrder=2, requiredOverride=RequiredOverride.REQUIRED)
    protected String url;
    @Column(name="URL_KEY")
    @AdminPresentation(friendlyName="ProductImpl_Product_UrlKey", order=2, group="Seo_Group", groupOrder=2)
    protected String urlKey;
    @Column(name="DISPLAY_TEMPLATE")
    @AdminPresentation(friendlyName="ProductImpl_Product_Display_Template", order=9, group="ProductImpl_Product_Description", groupOrder=1)
    protected String displayTemplate;
    @Column(name="MODEL")
    @AdminPresentation(friendlyName="ProductImpl_Product_Model", order=7, group="ProductImpl_Product_Description", prominent=true, groupOrder=1)
    protected String model;
    @Column(name="MANUFACTURE")
    @AdminPresentation(friendlyName="ProductImpl_Product_Manufacturer", order=6, group="ProductImpl_Product_Description", prominent=true, groupOrder=1)
    protected String manufacturer;
    @Column(name="IS_FEATURED_PRODUCT", nullable=false)
    @AdminPresentation(friendlyName="ProductImpl_Is_Featured_Product", order=5, group="ProductImpl_Product_Description", prominent=false, groupOrder=1)
    protected Boolean isFeaturedProduct = false;
    @OneToOne(optional=false, targetEntity=SkuImpl.class, cascade={CascadeType.ALL}, mappedBy="defaultProduct")
    @Cascade(value={org.hibernate.annotations.CascadeType.ALL})
    protected Sku defaultSku;
    @Column(name="CAN_SELL_WITHOUT_OPTIONS")
    @AdminPresentation(friendlyName="ProductImpl_Can_Sell_Without_Options", order=8, group="ProductImpl_Product_Description", prominent=false, groupOrder=1)
    protected Boolean canSellWithoutOptions = false;
    @Transient
    protected List<Sku> skus = new ArrayList<Sku>();
    @Transient
    protected String promoMessage;
    @OneToMany(mappedBy="product", targetEntity=CrossSaleProductImpl.class, cascade={CascadeType.ALL})
    @Cascade(value={org.hibernate.annotations.CascadeType.ALL, org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
    @Cache(usage=CacheConcurrencyStrategy.READ_WRITE, region="blStandardElements")
    @AdminPresentationAdornedTargetCollection(targetObjectProperty="relatedSaleProduct", friendlyName="crossSaleProductsTitle", targetUIElementId="productSkuCrossLayout", sortProperty="sequence", dataSourceName="crossSaleProductsDS", maintainedAdornedTargetFields={"promotionMessage"}, gridVisibleFields={"defaultSku.name", "promotionMessage"})
    protected List<RelatedProduct> crossSaleProducts = new ArrayList<RelatedProduct>();
    @OneToMany(mappedBy="product", targetEntity=UpSaleProductImpl.class, cascade={CascadeType.ALL})
    @Cascade(value={org.hibernate.annotations.CascadeType.ALL, org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
    @Cache(usage=CacheConcurrencyStrategy.READ_WRITE, region="blStandardElements")
    @OrderBy(value="sequence")
    @AdminPresentationAdornedTargetCollection(targetObjectProperty="relatedSaleProduct", friendlyName="upsaleProductsTitle", targetUIElementId="productSkuCrossLayout", sortProperty="sequence", dataSourceName="upSaleProductsDS", maintainedAdornedTargetFields={"promotionMessage"}, gridVisibleFields={"defaultSku.name", "promotionMessage"})
    protected List<RelatedProduct> upSaleProducts = new ArrayList<RelatedProduct>();
    @OneToMany(fetch=FetchType.LAZY, targetEntity=SkuImpl.class, mappedBy="product")
    @Cache(usage=CacheConcurrencyStrategy.READ_WRITE, region="blStandardElements")
    @BatchSize(size=50)
    protected List<Sku> additionalSkus = new ArrayList<Sku>();
    @ManyToOne(targetEntity=CategoryImpl.class)
    @JoinColumn(name="DEFAULT_CATEGORY_ID")
    @Index(name="PRODUCT_CATEGORY_INDEX", columnNames={"DEFAULT_CATEGORY_ID"})
    @AdminPresentation(friendlyName="ProductImpl_Product_Default_Category", order=4, group="ProductImpl_Product_Description", requiredOverride=RequiredOverride.REQUIRED, groupOrder=1)
    @AdminPresentationToOneLookup
    protected Category defaultCategory;
    @ManyToMany(fetch=FetchType.LAZY, targetEntity=CategoryImpl.class, cascade={CascadeType.MERGE, CascadeType.PERSIST})
    @JoinTable(name="BLC_CATEGORY_PRODUCT_XREF", joinColumns={@JoinColumn(name="PRODUCT_ID")}, inverseJoinColumns={@JoinColumn(name="CATEGORY_ID", referencedColumnName="CATEGORY_ID", nullable=true)})
    @Cascade(value={org.hibernate.annotations.CascadeType.MERGE, org.hibernate.annotations.CascadeType.PERSIST})
    @Cache(usage=CacheConcurrencyStrategy.READ_WRITE, region="blStandardElements")
    @BatchSize(size=50)
    protected List<Category> allParentCategories = new ArrayList<Category>();
    @OneToMany(mappedBy="product", targetEntity=ProductAttributeImpl.class, cascade={CascadeType.ALL})
    @Cascade(value={org.hibernate.annotations.CascadeType.ALL, org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
    @Cache(usage=CacheConcurrencyStrategy.READ_WRITE, region="blStandardElements")
    @BatchSize(size=50)
    @AdminPresentationCollection(addType=AddMethodType.PERSIST, friendlyName="productAttributesTitle", dataSourceName="productAttributeDS")
    protected List<ProductAttribute> productAttributes = new ArrayList<ProductAttribute>();
    @ManyToMany(fetch=FetchType.LAZY, targetEntity=ProductOptionImpl.class)
    @JoinTable(name="BLC_PRODUCT_OPTION_XREF", joinColumns={@JoinColumn(name="PRODUCT_ID", referencedColumnName="PRODUCT_ID")}, inverseJoinColumns={@JoinColumn(name="PRODUCT_OPTION_ID", referencedColumnName="PRODUCT_OPTION_ID")})
    @Cache(usage=CacheConcurrencyStrategy.READ_WRITE, region="blStandardElements")
    @BatchSize(size=50)
    protected List<ProductOption> productOptions = new ArrayList<ProductOption>();
    @Embedded
    protected ArchiveStatus archiveStatus = new ArchiveStatus();

    @Override
    public Long getId() {
        return this.id;
    }

    @Override
    public void setId(Long id) {
        this.id = id;
    }

    @Override
    public String getName() {
        return this.getDefaultSku().getName();
    }

    @Override
    public void setName(String name) {
        this.getDefaultSku().setName(name);
    }

    @Override
    public String getDescription() {
        return this.getDefaultSku().getDescription();
    }

    @Override
    public void setDescription(String description) {
        this.getDefaultSku().setDescription(description);
    }

    @Override
    public String getLongDescription() {
        return this.getDefaultSku().getLongDescription();
    }

    @Override
    public void setLongDescription(String longDescription) {
        this.getDefaultSku().setLongDescription(longDescription);
    }

    @Override
    public Date getActiveStartDate() {
        return this.getDefaultSku().getActiveStartDate();
    }

    @Override
    public void setActiveStartDate(Date activeStartDate) {
        this.getDefaultSku().setActiveStartDate(activeStartDate);
    }

    @Override
    public Date getActiveEndDate() {
        return this.getDefaultSku().getActiveEndDate();
    }

    @Override
    public void setActiveEndDate(Date activeEndDate) {
        this.getDefaultSku().setActiveEndDate(activeEndDate);
    }

    @Override
    public boolean isActive() {
        if (LOG.isDebugEnabled()) {
            if (!DateUtil.isActive((Date)this.getActiveStartDate(), (Date)this.getActiveEndDate(), (boolean)true)) {
                LOG.debug((Object)("product, " + this.id + ", inactive due to date"));
            }
            if ('Y' == this.getArchived().charValue()) {
                LOG.debug((Object)("product, " + this.id + ", inactive due to archived status"));
            }
        }
        return DateUtil.isActive((Date)this.getActiveStartDate(), (Date)this.getActiveEndDate(), (boolean)true) && 'Y' != this.getArchived().charValue();
    }

    @Override
    public String getModel() {
        return this.model;
    }

    @Override
    public void setModel(String model) {
        this.model = model;
    }

    @Override
    public String getManufacturer() {
        return this.manufacturer;
    }

    @Override
    public void setManufacturer(String manufacturer) {
        this.manufacturer = manufacturer;
    }

    @Override
    public boolean isFeaturedProduct() {
        return this.isFeaturedProduct;
    }

    @Override
    public void setFeaturedProduct(boolean isFeaturedProduct) {
        this.isFeaturedProduct = isFeaturedProduct;
    }

    @Override
    public Sku getDefaultSku() {
        return this.defaultSku;
    }

    @Override
    public Boolean getCanSellWithoutOptions() {
        return this.canSellWithoutOptions == null ? false : this.canSellWithoutOptions;
    }

    @Override
    public void setCanSellWithoutOptions(Boolean canSellWithoutOptions) {
        this.canSellWithoutOptions = canSellWithoutOptions;
    }

    @Override
    public void setDefaultSku(Sku defaultSku) {
        defaultSku.setDefaultProduct(this);
        this.defaultSku = defaultSku;
    }

    @Override
    public String getPromoMessage() {
        return this.promoMessage;
    }

    @Override
    public void setPromoMessage(String promoMessage) {
        this.promoMessage = promoMessage;
    }

    @Override
    public List<Sku> getAllSkus() {
        ArrayList<Sku> allSkus = new ArrayList<Sku>();
        allSkus.add(this.getDefaultSku());
        for (Sku additionalSku : this.additionalSkus) {
            if (additionalSku.getId().equals(this.getDefaultSku().getId())) continue;
            allSkus.add(additionalSku);
        }
        return allSkus;
    }

    @Override
    public List<Sku> getSkus() {
        if (this.skus.size() == 0) {
            List<Sku> additionalSkus = this.getAdditionalSkus();
            for (Sku sku : additionalSkus) {
                if (!sku.isActive()) continue;
                this.skus.add(sku);
            }
        }
        return this.skus;
    }

    @Override
    public List<Sku> getAdditionalSkus() {
        return this.additionalSkus;
    }

    @Override
    public void setAdditionalSkus(List<Sku> skus) {
        this.additionalSkus.clear();
        for (Sku sku : skus) {
            this.additionalSkus.add(sku);
        }
    }

    @Override
    public Category getDefaultCategory() {
        return this.defaultCategory;
    }

    @Override
    public Map<String, Media> getMedia() {
        return this.getDefaultSku().getSkuMedia();
    }

    @Override
    public void setMedia(Map<String, Media> media) {
        this.getDefaultSku().setSkuMedia(media);
    }

    @Override
    public Map<String, Media> getAllSkuMedia() {
        HashMap<String, Media> result = new HashMap<String, Media>();
        result.putAll(this.getMedia());
        for (Sku additionalSku : this.getAdditionalSkus()) {
            if (additionalSku.getId() == this.getDefaultSku().getId()) continue;
            result.putAll(additionalSku.getSkuMedia());
        }
        return result;
    }

    @Override
    public void setDefaultCategory(Category defaultCategory) {
        this.defaultCategory = defaultCategory;
    }

    @Override
    public List<Category> getAllParentCategories() {
        return this.allParentCategories;
    }

    @Override
    public void setAllParentCategories(List<Category> allParentCategories) {
        this.allParentCategories.clear();
        for (Category category : allParentCategories) {
            this.allParentCategories.add(category);
        }
    }

    @Override
    public Dimension getDimension() {
        return this.getDefaultSku().getDimension();
    }

    @Override
    public void setDimension(Dimension dimension) {
        this.getDefaultSku().setDimension(dimension);
    }

    @Override
    public BigDecimal getWidth() {
        return this.getDefaultSku().getDimension().getWidth();
    }

    @Override
    public void setWidth(BigDecimal width) {
        this.getDefaultSku().getDimension().setWidth(width);
    }

    @Override
    public BigDecimal getHeight() {
        return this.getDefaultSku().getDimension().getHeight();
    }

    @Override
    public void setHeight(BigDecimal height) {
        this.getDefaultSku().getDimension().setHeight(height);
    }

    @Override
    public BigDecimal getDepth() {
        return this.getDefaultSku().getDimension().getDepth();
    }

    @Override
    public void setDepth(BigDecimal depth) {
        this.getDefaultSku().getDimension().setDepth(depth);
    }

    @Override
    public BigDecimal getGirth() {
        return this.getDefaultSku().getDimension().getGirth();
    }

    @Override
    public void setGirth(BigDecimal girth) {
        this.getDefaultSku().getDimension().setGirth(girth);
    }

    @Override
    public ContainerSizeType getSize() {
        return this.getDefaultSku().getDimension().getSize();
    }

    @Override
    public void setSize(ContainerSizeType size) {
        this.getDefaultSku().getDimension().setSize(size);
    }

    @Override
    public ContainerShapeType getContainer() {
        return this.getDefaultSku().getDimension().getContainer();
    }

    @Override
    public void setContainer(ContainerShapeType container) {
        this.getDefaultSku().getDimension().setContainer(container);
    }

    @Override
    public String getDimensionString() {
        return this.getDefaultSku().getDimension().getDimensionString();
    }

    @Override
    public Weight getWeight() {
        return this.getDefaultSku().getWeight();
    }

    @Override
    public void setWeight(Weight weight) {
        this.getDefaultSku().setWeight(weight);
    }

    @Override
    public List<RelatedProduct> getCrossSaleProducts() {
        ArrayList<RelatedProduct> returnProducts = new ArrayList<RelatedProduct>();
        if (this.crossSaleProducts != null) {
            returnProducts.addAll(this.crossSaleProducts);
            CollectionUtils.filter(returnProducts, (Predicate)new Predicate(){

                public boolean evaluate(Object arg) {
                    return 'Y' != ((Status)((CrossSaleProductImpl)arg).getRelatedProduct()).getArchived().charValue();
                }
            });
        }
        return returnProducts;
    }

    @Override
    public void setCrossSaleProducts(List<RelatedProduct> crossSaleProducts) {
        this.crossSaleProducts.clear();
        for (RelatedProduct relatedProduct : crossSaleProducts) {
            this.crossSaleProducts.add(relatedProduct);
        }
    }

    @Override
    public List<RelatedProduct> getUpSaleProducts() {
        ArrayList<RelatedProduct> returnProducts = new ArrayList<RelatedProduct>();
        if (this.upSaleProducts != null) {
            returnProducts.addAll(this.upSaleProducts);
            CollectionUtils.filter(returnProducts, (Predicate)new Predicate(){

                public boolean evaluate(Object arg) {
                    return 'Y' != ((Status)((UpSaleProductImpl)arg).getRelatedProduct()).getArchived().charValue();
                }
            });
        }
        return returnProducts;
    }

    @Override
    public void setUpSaleProducts(List<RelatedProduct> upSaleProducts) {
        this.upSaleProducts.clear();
        for (RelatedProduct relatedProduct : upSaleProducts) {
            this.upSaleProducts.add(relatedProduct);
        }
        this.upSaleProducts = upSaleProducts;
    }

    @Override
    public List<RelatedProduct> getCumulativeCrossSaleProducts() {
        List<RelatedProduct> categoryProducts;
        List<RelatedProduct> returnProducts = this.getCrossSaleProducts();
        if (this.defaultCategory != null && (categoryProducts = this.defaultCategory.getCumulativeCrossSaleProducts()) != null) {
            returnProducts.addAll(categoryProducts);
        }
        Iterator<RelatedProduct> itr = returnProducts.iterator();
        while (itr.hasNext()) {
            RelatedProduct relatedProduct = itr.next();
            if (!relatedProduct.getRelatedProduct().equals(this)) continue;
            itr.remove();
        }
        return returnProducts;
    }

    @Override
    public List<RelatedProduct> getCumulativeUpSaleProducts() {
        List<RelatedProduct> categoryProducts;
        List<RelatedProduct> returnProducts = this.getUpSaleProducts();
        if (this.defaultCategory != null && (categoryProducts = this.defaultCategory.getCumulativeUpSaleProducts()) != null) {
            returnProducts.addAll(categoryProducts);
        }
        Iterator<RelatedProduct> itr = returnProducts.iterator();
        while (itr.hasNext()) {
            RelatedProduct relatedProduct = itr.next();
            if (!relatedProduct.getRelatedProduct().equals(this)) continue;
            itr.remove();
        }
        return returnProducts;
    }

    @Override
    public List<ProductAttribute> getProductAttributes() {
        return this.productAttributes;
    }

    @Override
    public void setProductAttributes(List<ProductAttribute> productAttributes) {
        this.productAttributes = productAttributes;
    }

    @Override
    public List<ProductOption> getProductOptions() {
        return this.productOptions;
    }

    @Override
    public void setProductOptions(List<ProductOption> productOptions) {
        this.productOptions = productOptions;
    }

    @Override
    public String getUrl() {
        if (this.url == null) {
            return this.getGeneratedUrl();
        }
        return this.url;
    }

    @Override
    public void setUrl(String url) {
        this.url = url;
    }

    @Override
    public String getDisplayTemplate() {
        return this.displayTemplate;
    }

    @Override
    public void setDisplayTemplate(String displayTemplate) {
        this.displayTemplate = displayTemplate;
    }

    @Override
    public ProductAttribute getProductAttributeByName(String name) {
        for (ProductAttribute attribute : this.getProductAttributes()) {
            if (!attribute.getName().equals(name)) continue;
            return attribute;
        }
        return null;
    }

    @Override
    public Map<String, ProductAttribute> getMappedProductAttributes() {
        return BLCMapUtils.keyedMap(this.getProductAttributes(), (TypedClosure)new TypedClosure<String, ProductAttribute>(){

            public String getKey(ProductAttribute value) {
                return value.getName();
            }
        });
    }

    public Character getArchived() {
        if (this.archiveStatus == null) {
            this.archiveStatus = new ArchiveStatus();
        }
        return this.archiveStatus.getArchived();
    }

    public void setArchived(Character archived) {
        if (this.archiveStatus == null) {
            this.archiveStatus = new ArchiveStatus();
        }
        this.archiveStatus.setArchived(archived);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.skus == null ? 0 : ((Object)this.skus).hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ProductImpl other = (ProductImpl)obj;
        if (this.id != null && other.id != null) {
            return this.id.equals(other.id);
        }
        return !(this.skus == null ? other.skus != null : !((Object)this.skus).equals(other.skus));
    }

    @Override
    public String getUrlKey() {
        if (this.urlKey != null) {
            return this.urlKey;
        }
        if (this.getName() != null) {
            String returnKey = this.getName().toLowerCase();
            returnKey = returnKey.replaceAll(" ", "-");
            return returnKey.replaceAll("[^A-Za-z0-9/-]", "");
        }
        return null;
    }

    @Override
    public void setUrlKey(String urlKey) {
        this.urlKey = urlKey;
    }

    @Override
    public String getGeneratedUrl() {
        if (this.getDefaultCategory() != null && this.getDefaultCategory().getGeneratedUrl() != null) {
            String generatedUrl = this.getDefaultCategory().getGeneratedUrl();
            if (generatedUrl.endsWith("//")) {
                return generatedUrl + this.getUrlKey();
            }
            return generatedUrl + "//" + this.getUrlKey();
        }
        return null;
    }

    @Override
    public void clearDynamicPrices() {
        for (Sku sku : this.getAllSkus()) {
            sku.clearDynamicPrices();
        }
    }
}

