/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.core.payment.domain;

import java.math.BigDecimal;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.persistence.TableGenerator;
import org.broadleafcommerce.core.payment.domain.AmountItem;
import org.broadleafcommerce.core.payment.domain.PaymentInfo;
import org.broadleafcommerce.core.payment.domain.PaymentInfoImpl;
import org.hibernate.annotations.Index;

@Entity
@Inheritance(strategy=InheritanceType.JOINED)
@Table(name="BLC_AMOUNT_ITEM")
public class AmountItemImpl
implements AmountItem {
    private static final long serialVersionUID = 1L;
    @Id
    @GeneratedValue(generator="AmountItemId", strategy=GenerationType.TABLE)
    @TableGenerator(name="AmountItemId", table="SEQUENCE_GENERATOR", pkColumnName="ID_NAME", valueColumnName="ID_VAL", pkColumnValue="AmountItemImpl", allocationSize=50)
    @Column(name="AMOUNT_ITEM_ID")
    protected Long id;
    @Column(name="SHORT_DESCRIPTION", nullable=true)
    @Index(name="SHORT_DESCRIPTION_INDEX", columnNames={"SHORT_DESCRIPTION"})
    protected String shortDescription;
    @Column(name="DESCRIPTION")
    protected String description;
    @Column(name="UNIT_PRICE", nullable=false, precision=19, scale=5)
    protected BigDecimal unitPrice;
    @Column(name="QUANTITY", nullable=false)
    protected Long quantity;
    @Column(name="SYSTEM_ID")
    protected String systemId;
    @ManyToOne(targetEntity=PaymentInfoImpl.class, optional=true)
    @JoinColumn(name="PAYMENT_ID")
    @Index(name="AMOUNTITEM_PAYMENTINFO_INDEX", columnNames={"PAYMENT_ID"})
    protected PaymentInfo paymentInfo;

    @Override
    public Long getId() {
        return this.id;
    }

    @Override
    public void setId(Long id) {
        this.id = id;
    }

    @Override
    public String getShortDescription() {
        return this.shortDescription;
    }

    @Override
    public void setShortDescription(String shortDescription) {
        this.shortDescription = shortDescription;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public void setDescription(String description) {
        this.description = description;
    }

    @Override
    public BigDecimal getUnitPrice() {
        return this.unitPrice;
    }

    @Override
    public void setUnitPrice(BigDecimal unitPrice) {
        this.unitPrice = unitPrice;
    }

    @Override
    public Long getQuantity() {
        return this.quantity;
    }

    @Override
    public void setQuantity(Long quantity) {
        this.quantity = quantity;
    }

    @Override
    public PaymentInfo getPaymentInfo() {
        return this.paymentInfo;
    }

    @Override
    public void setPaymentInfo(PaymentInfo paymentInfo) {
        this.paymentInfo = paymentInfo;
    }

    @Override
    public String getSystemId() {
        return this.systemId;
    }

    @Override
    public void setSystemId(String systemId) {
        this.systemId = systemId;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.description == null ? 0 : this.description.hashCode());
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        result = 31 * result + (this.quantity == null ? 0 : this.quantity.hashCode());
        result = 31 * result + (this.shortDescription == null ? 0 : this.shortDescription.hashCode());
        result = 31 * result + (this.unitPrice == null ? 0 : this.unitPrice.hashCode());
        result = 31 * result + (this.systemId == null ? 0 : this.systemId.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AmountItemImpl other = (AmountItemImpl)obj;
        if (this.id != null && other.id != null) {
            return this.id.equals(other.id);
        }
        if (this.description == null ? other.description != null : !this.description.equals(other.description)) {
            return false;
        }
        if (this.quantity == null ? other.quantity != null : !this.quantity.equals(other.quantity)) {
            return false;
        }
        if (this.shortDescription == null ? other.shortDescription != null : !this.shortDescription.equals(other.shortDescription)) {
            return false;
        }
        if (this.unitPrice == null ? other.unitPrice != null : !this.unitPrice.equals(other.unitPrice)) {
            return false;
        }
        return !(this.systemId == null ? other.systemId != null : !this.systemId.equals(other.systemId));
    }
}

