/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.core.catalog.service;

import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.broadleafcommerce.core.catalog.dao.CategoryDao;
import org.broadleafcommerce.core.catalog.dao.ProductDao;
import org.broadleafcommerce.core.catalog.dao.ProductOptionDao;
import org.broadleafcommerce.core.catalog.dao.SkuDao;
import org.broadleafcommerce.core.catalog.domain.Category;
import org.broadleafcommerce.core.catalog.domain.Product;
import org.broadleafcommerce.core.catalog.domain.ProductBundle;
import org.broadleafcommerce.core.catalog.domain.ProductBundleComparator;
import org.broadleafcommerce.core.catalog.domain.ProductOption;
import org.broadleafcommerce.core.catalog.domain.ProductOptionValue;
import org.broadleafcommerce.core.catalog.domain.Sku;
import org.broadleafcommerce.core.catalog.domain.SkuFee;
import org.broadleafcommerce.core.catalog.service.CatalogService;
import org.broadleafcommerce.core.catalog.service.type.ProductType;
import org.broadleafcommerce.core.search.domain.ProductSearchCriteria;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="blCatalogService")
public class CatalogServiceImpl
implements CatalogService {
    @Resource(name="blCategoryDao")
    protected CategoryDao categoryDao;
    @Resource(name="blProductDao")
    protected ProductDao productDao;
    @Resource(name="blSkuDao")
    protected SkuDao skuDao;
    @Resource(name="blProductOptionDao")
    protected ProductOptionDao productOptionDao;

    @Override
    public Product findProductById(Long productId) {
        return this.productDao.readProductById(productId);
    }

    @Override
    public List<Product> findProductsByName(String searchName) {
        return this.productDao.readProductsByName(searchName);
    }

    @Override
    public List<Product> findProductsByName(String searchName, int limit, int offset) {
        return this.productDao.readProductsByName(searchName, limit, offset);
    }

    @Override
    public List<Product> findActiveProductsByCategory(Category category, Date currentDate) {
        return this.productDao.readActiveProductsByCategory(category.getId(), currentDate);
    }

    @Override
    public List<Product> findFilteredActiveProductsByCategory(Category category, Date currentDate, ProductSearchCriteria searchCriteria) {
        return this.productDao.readFilteredActiveProductsByCategory(category.getId(), currentDate, searchCriteria);
    }

    @Override
    public List<Product> findFilteredActiveProductsByQuery(String query, Date currentDate, ProductSearchCriteria searchCriteria) {
        return this.productDao.readFilteredActiveProductsByQuery(query, currentDate, searchCriteria);
    }

    @Override
    public List<Product> findActiveProductsByCategory(Category category, Date currentDate, int limit, int offset) {
        return this.productDao.readActiveProductsByCategory(category.getId(), currentDate, limit, offset);
    }

    @Override
    public List<ProductBundle> findAutomaticProductBundles() {
        List<ProductBundle> bundles = this.productDao.readAutomaticProductBundles();
        Collections.sort(bundles, new ProductBundleComparator());
        return bundles;
    }

    @Override
    @Transactional(value="blTransactionManager")
    public Product saveProduct(Product product) {
        return this.productDao.save(product);
    }

    @Override
    public Category findCategoryById(Long categoryId) {
        return this.categoryDao.readCategoryById(categoryId);
    }

    @Override
    @Deprecated
    public Category findCategoryByName(String categoryName) {
        return this.categoryDao.readCategoryByName(categoryName);
    }

    @Override
    public List<Category> findCategoriesByName(String categoryName) {
        return this.categoryDao.readCategoriesByName(categoryName);
    }

    @Override
    public List<Category> findCategoriesByName(String categoryName, int limit, int offset) {
        return this.categoryDao.readCategoriesByName(categoryName, limit, offset);
    }

    @Override
    @Transactional(value="blTransactionManager")
    public Category saveCategory(Category category) {
        return this.categoryDao.save(category);
    }

    @Override
    @Transactional(value="blTransactionManager")
    public void removeCategory(Category category) {
        this.categoryDao.delete(category);
    }

    @Override
    public List<Category> findAllCategories() {
        return this.categoryDao.readAllCategories();
    }

    @Override
    public List<Category> findAllCategories(int limit, int offset) {
        return this.categoryDao.readAllCategories(limit, offset);
    }

    @Override
    public List<Category> findAllSubCategories(Category category) {
        return this.categoryDao.readAllSubCategories(category);
    }

    @Override
    public List<Category> findAllSubCategories(Category category, int limit, int offset) {
        return this.categoryDao.readAllSubCategories(category, limit, offset);
    }

    @Override
    public List<Category> findActiveSubCategoriesByCategory(Category category) {
        return this.categoryDao.readActiveSubCategoriesByCategory(category);
    }

    @Override
    public List<Category> findActiveSubCategoriesByCategory(Category category, int limit, int offset) {
        return this.categoryDao.readActiveSubCategoriesByCategory(category, limit, offset);
    }

    @Override
    public List<Product> findAllProducts() {
        return this.categoryDao.readAllProducts();
    }

    @Override
    public List<Product> findAllProducts(int limit, int offset) {
        return this.categoryDao.readAllProducts(limit, offset);
    }

    @Override
    public List<Sku> findAllSkus() {
        return this.skuDao.readAllSkus();
    }

    @Override
    public Sku findSkuById(Long skuId) {
        return this.skuDao.readSkuById(skuId);
    }

    @Override
    @Transactional(value="blTransactionManager")
    public Sku saveSku(Sku sku) {
        return this.skuDao.save(sku);
    }

    @Override
    @Transactional(value="blTransactionManager")
    public SkuFee saveSkuFee(SkuFee fee) {
        return this.skuDao.saveSkuFee(fee);
    }

    @Override
    public List<Sku> findSkusByIds(List<Long> ids) {
        return this.skuDao.readSkusById(ids);
    }

    public void setProductDao(ProductDao productDao) {
        this.productDao = productDao;
    }

    public void setSkuDao(SkuDao skuDao) {
        this.skuDao = skuDao;
    }

    @Override
    public List<Product> findProductsForCategory(Category category) {
        return this.productDao.readProductsByCategory(category.getId());
    }

    @Override
    public List<Product> findProductsForCategory(Category category, int limit, int offset) {
        return this.productDao.readProductsByCategory(category.getId(), limit, offset);
    }

    public void setCategoryDao(CategoryDao categoryDao) {
        this.categoryDao = categoryDao;
    }

    @Override
    public Map<String, List<Long>> getChildCategoryURLMapByCategoryId(Long categoryId) {
        Category category = this.findCategoryById(categoryId);
        if (category != null) {
            return category.getChildCategoryURLMap();
        }
        return null;
    }

    @Override
    public Category createCategory() {
        return this.categoryDao.create();
    }

    @Override
    public Sku createSku() {
        return this.skuDao.create();
    }

    @Override
    public Product createProduct(ProductType productType) {
        return this.productDao.create(productType);
    }

    @Override
    public List<ProductOption> readAllProductOptions() {
        return this.productOptionDao.readAllProductOptions();
    }

    @Override
    public ProductOption findProductOptionById(Long productOptionId) {
        return this.productOptionDao.readProductOptionById(productOptionId);
    }

    @Override
    public ProductOptionValue findProductOptionValueById(Long productOptionValueId) {
        return this.productOptionDao.readProductOptionValueById(productOptionValueId);
    }

    @Override
    public Category findCategoryByURI(String uri) {
        return this.categoryDao.findCategoryByURI(uri);
    }

    @Override
    public Product findProductByURI(String uri) {
        List<Product> products = this.productDao.findProductByURI(uri);
        if (products == null || products.size() == 0) {
            return null;
        }
        if (products.size() == 1) {
            return products.get(0);
        }
        for (Product product : products) {
            if (!uri.equals(product.getUrl())) continue;
            return product;
        }
        for (Product product : products) {
            if (!uri.equals(product.getGeneratedUrl())) continue;
            return product;
        }
        return products.get(0);
    }
}

