/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.core.pricing.service.fulfillment.provider;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.broadleafcommerce.common.money.Money;
import org.broadleafcommerce.common.util.UnitOfMeasureUtil;
import org.broadleafcommerce.common.util.WeightUnitOfMeasureType;
import org.broadleafcommerce.common.vendor.service.exception.FulfillmentPriceException;
import org.broadleafcommerce.core.catalog.domain.Sku;
import org.broadleafcommerce.core.order.domain.BundleOrderItem;
import org.broadleafcommerce.core.order.domain.DiscreteOrderItem;
import org.broadleafcommerce.core.order.domain.FulfillmentGroup;
import org.broadleafcommerce.core.order.domain.FulfillmentGroupItem;
import org.broadleafcommerce.core.order.domain.FulfillmentOption;
import org.broadleafcommerce.core.order.fulfillment.domain.BandedPriceFulfillmentOption;
import org.broadleafcommerce.core.order.fulfillment.domain.BandedWeightFulfillmentOption;
import org.broadleafcommerce.core.order.fulfillment.domain.FulfillmentBand;
import org.broadleafcommerce.core.order.fulfillment.domain.FulfillmentPriceBand;
import org.broadleafcommerce.core.order.fulfillment.domain.FulfillmentWeightBand;
import org.broadleafcommerce.core.order.service.type.FulfillmentBandResultAmountType;
import org.broadleafcommerce.core.pricing.service.fulfillment.provider.FulfillmentEstimationResponse;
import org.broadleafcommerce.core.pricing.service.fulfillment.provider.FulfillmentPricingProvider;

public class BandedFulfillmentPricingProvider
implements FulfillmentPricingProvider {
    protected static final Log LOG = LogFactory.getLog(BandedFulfillmentPricingProvider.class);

    @Override
    public boolean canCalculateCostForFulfillmentGroup(FulfillmentGroup fulfillmentGroup, FulfillmentOption option) {
        return option instanceof BandedPriceFulfillmentOption || option instanceof BandedWeightFulfillmentOption;
    }

    @Override
    public FulfillmentGroup calculateCostForFulfillmentGroup(FulfillmentGroup fulfillmentGroup) throws FulfillmentPriceException {
        if (fulfillmentGroup.getFulfillmentGroupItems().size() == 0) {
            LOG.warn((Object)("fulfillment group (" + fulfillmentGroup.getId() + ") does not contain any fulfillment group items. Unable to price banded shipping"));
            fulfillmentGroup.setShippingPrice(Money.ZERO);
            fulfillmentGroup.setSaleShippingPrice(Money.ZERO);
            fulfillmentGroup.setRetailShippingPrice(Money.ZERO);
            return fulfillmentGroup;
        }
        if (this.canCalculateCostForFulfillmentGroup(fulfillmentGroup, fulfillmentGroup.getFulfillmentOption())) {
            HashSet<FulfillmentOption> options = new HashSet<FulfillmentOption>();
            options.add(fulfillmentGroup.getFulfillmentOption());
            FulfillmentEstimationResponse response = this.estimateCostForFulfillmentGroup(fulfillmentGroup, options);
            fulfillmentGroup.setSaleShippingPrice(response.getFulfillmentOptionPrices().get(fulfillmentGroup.getFulfillmentOption()));
            fulfillmentGroup.setRetailShippingPrice(response.getFulfillmentOptionPrices().get(fulfillmentGroup.getFulfillmentOption()));
            fulfillmentGroup.setShippingPrice(response.getFulfillmentOptionPrices().get(fulfillmentGroup.getFulfillmentOption()));
            return fulfillmentGroup;
        }
        throw new FulfillmentPriceException("An unsupported FulfillmentOption was passed to the calculateCostForFulfillmentGroup method");
    }

    @Override
    public FulfillmentEstimationResponse estimateCostForFulfillmentGroup(FulfillmentGroup fulfillmentGroup, Set<FulfillmentOption> options) throws FulfillmentPriceException {
        FulfillmentEstimationResponse res = new FulfillmentEstimationResponse();
        HashMap<FulfillmentOption, Money> shippingPrices = new HashMap<FulfillmentOption, Money>();
        res.setFulfillmentOptionPrices(shippingPrices);
        for (FulfillmentOption option : options) {
            if (!this.canCalculateCostForFulfillmentGroup(fulfillmentGroup, option)) continue;
            List<FulfillmentBand> bands = null;
            if (option instanceof BandedPriceFulfillmentOption) {
                bands = ((BandedPriceFulfillmentOption)option).getBands();
            } else if (option instanceof BandedWeightFulfillmentOption) {
                bands = ((BandedWeightFulfillmentOption)option).getBands();
            }
            if (bands == null || bands.isEmpty()) {
                throw new IllegalStateException("There were no Fulfillment Price Bands configured for a BandedPriceFulfillmentOption with ID: " + option.getId());
            }
            BigDecimal retailTotal = BigDecimal.ZERO;
            BigDecimal flatTotal = BigDecimal.ZERO;
            BigDecimal weightTotal = BigDecimal.ZERO;
            for (FulfillmentGroupItem fulfillmentGroupItem : fulfillmentGroup.getFulfillmentGroupItems()) {
                BigDecimal price;
                BigDecimal rate;
                boolean addToTotal = true;
                Sku sku = null;
                if (fulfillmentGroupItem.getOrderItem() instanceof DiscreteOrderItem) {
                    sku = ((DiscreteOrderItem)fulfillmentGroupItem.getOrderItem()).getSku();
                } else if (fulfillmentGroupItem.getOrderItem() instanceof BundleOrderItem) {
                    sku = ((BundleOrderItem)fulfillmentGroupItem.getOrderItem()).getSku();
                }
                if (sku != null && option.getUseFlatRates().booleanValue() && (rate = sku.getFulfillmentFlatRates().get(option)) != null) {
                    addToTotal = false;
                    flatTotal = flatTotal.add(rate);
                }
                if (!addToTotal) continue;
                BigDecimal bigDecimal = price = fulfillmentGroupItem.getPrice() != null ? fulfillmentGroupItem.getPrice().getAmount().multiply(BigDecimal.valueOf(fulfillmentGroupItem.getQuantity())) : null;
                if (price == null) {
                    price = fulfillmentGroupItem.getOrderItem().getPrice().getAmount().multiply(BigDecimal.valueOf(fulfillmentGroupItem.getQuantity()));
                }
                retailTotal = retailTotal.add(price);
                if (sku == null || sku.getWeight() == null || sku.getWeight().getWeight() == null) continue;
                BigDecimal convertedWeight = this.convertWeight(sku.getWeight().getWeight(), sku.getWeight().getWeightUnitOfMeasure()).multiply(BigDecimal.valueOf(fulfillmentGroupItem.getQuantity()));
                weightTotal = weightTotal.add(convertedWeight);
            }
            BigDecimal lowestBandFulfillmentPrice = null;
            BigDecimal lowestBandFulfillmentPriceMinimumAmount = BigDecimal.ZERO;
            for (FulfillmentBand band : bands) {
                BigDecimal bandMinimumAmount = BigDecimal.ZERO;
                boolean foundMatch = false;
                if (band instanceof FulfillmentPriceBand) {
                    bandMinimumAmount = ((FulfillmentPriceBand)band).getRetailPriceMinimumAmount();
                    foundMatch = retailTotal.compareTo(bandMinimumAmount) >= 0;
                } else if (band instanceof FulfillmentWeightBand) {
                    bandMinimumAmount = ((FulfillmentWeightBand)band).getMinimumWeight();
                    boolean bl = foundMatch = weightTotal.compareTo(bandMinimumAmount) >= 0;
                }
                if (!foundMatch) continue;
                FulfillmentBandResultAmountType resultAmountType = band.getResultAmountType();
                BigDecimal bandFulfillmentPrice = null;
                if (FulfillmentBandResultAmountType.RATE.equals(resultAmountType)) {
                    bandFulfillmentPrice = band.getResultAmount();
                } else if (FulfillmentBandResultAmountType.PERCENTAGE.equals(resultAmountType)) {
                    bandFulfillmentPrice = retailTotal.multiply(band.getResultAmount());
                } else {
                    LOG.warn((Object)("Unknown FulfillmentBandResultAmountType: " + resultAmountType.getType() + " Should be RATE or PERCENTAGE. Ignoring."));
                }
                if (bandFulfillmentPrice != null) {
                    if (lowestBandFulfillmentPrice == null) {
                        lowestBandFulfillmentPrice = bandFulfillmentPrice;
                        lowestBandFulfillmentPriceMinimumAmount = bandMinimumAmount;
                    }
                    if (lowestBandFulfillmentPriceMinimumAmount.compareTo(bandMinimumAmount) == 0) {
                        if (bandFulfillmentPrice.compareTo(lowestBandFulfillmentPrice) > 0) continue;
                        lowestBandFulfillmentPrice = bandFulfillmentPrice;
                        lowestBandFulfillmentPriceMinimumAmount = bandMinimumAmount;
                        continue;
                    }
                    if (bandMinimumAmount.compareTo(lowestBandFulfillmentPriceMinimumAmount) <= 0) continue;
                    lowestBandFulfillmentPrice = bandFulfillmentPrice;
                    lowestBandFulfillmentPriceMinimumAmount = bandMinimumAmount;
                    continue;
                }
                throw new IllegalStateException("Bands must have a non-null fulfillment price");
            }
            if (lowestBandFulfillmentPrice == null) {
                lowestBandFulfillmentPrice = BigDecimal.ZERO;
            }
            lowestBandFulfillmentPrice = lowestBandFulfillmentPrice.add(flatTotal);
            shippingPrices.put(option, new Money(lowestBandFulfillmentPrice));
        }
        return res;
    }

    protected BigDecimal convertWeight(BigDecimal weight, WeightUnitOfMeasureType type) {
        return UnitOfMeasureUtil.findPounds((BigDecimal)weight, (WeightUnitOfMeasureType)type);
    }
}

