/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.core.offer.service.processor;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import junit.framework.TestCase;
import org.broadleafcommerce.core.offer.dao.CustomerOfferDao;
import org.broadleafcommerce.core.offer.dao.OfferCodeDao;
import org.broadleafcommerce.core.offer.dao.OfferDao;
import org.broadleafcommerce.core.offer.domain.CandidateFulfillmentGroupOffer;
import org.broadleafcommerce.core.offer.domain.CandidateFulfillmentGroupOfferImpl;
import org.broadleafcommerce.core.offer.domain.CandidateItemOffer;
import org.broadleafcommerce.core.offer.domain.CandidateItemOfferImpl;
import org.broadleafcommerce.core.offer.domain.FulfillmentGroupAdjustment;
import org.broadleafcommerce.core.offer.domain.FulfillmentGroupAdjustmentImpl;
import org.broadleafcommerce.core.offer.domain.Offer;
import org.broadleafcommerce.core.offer.domain.OfferItemCriteria;
import org.broadleafcommerce.core.offer.domain.OrderItemAdjustment;
import org.broadleafcommerce.core.offer.domain.OrderItemAdjustmentImpl;
import org.broadleafcommerce.core.offer.service.OfferDataItemProvider;
import org.broadleafcommerce.core.offer.service.OfferServiceImpl;
import org.broadleafcommerce.core.offer.service.OrderItemMergeService;
import org.broadleafcommerce.core.offer.service.OrderItemMergeServiceImpl;
import org.broadleafcommerce.core.offer.service.discount.CandidatePromotionItems;
import org.broadleafcommerce.core.offer.service.discount.domain.PromotableCandidateFulfillmentGroupOffer;
import org.broadleafcommerce.core.offer.service.discount.domain.PromotableFulfillmentGroup;
import org.broadleafcommerce.core.offer.service.discount.domain.PromotableItemFactory;
import org.broadleafcommerce.core.offer.service.discount.domain.PromotableItemFactoryImpl;
import org.broadleafcommerce.core.offer.service.discount.domain.PromotableOrder;
import org.broadleafcommerce.core.offer.service.discount.domain.PromotableOrderItem;
import org.broadleafcommerce.core.offer.service.processor.FulfillmentGroupOfferProcessor;
import org.broadleafcommerce.core.offer.service.processor.FulfillmentGroupOfferProcessorImpl;
import org.broadleafcommerce.core.offer.service.processor.ItemOfferProcessor;
import org.broadleafcommerce.core.offer.service.processor.ItemOfferProcessorImpl;
import org.broadleafcommerce.core.offer.service.processor.OrderOfferProcessor;
import org.broadleafcommerce.core.offer.service.processor.OrderOfferProcessorImpl;
import org.broadleafcommerce.core.offer.service.type.OfferDiscountType;
import org.broadleafcommerce.core.order.dao.FulfillmentGroupItemDao;
import org.broadleafcommerce.core.order.domain.FulfillmentGroup;
import org.broadleafcommerce.core.order.domain.FulfillmentGroupItem;
import org.broadleafcommerce.core.order.domain.Order;
import org.broadleafcommerce.core.order.domain.OrderItem;
import org.broadleafcommerce.core.order.domain.OrderMultishipOption;
import org.broadleafcommerce.core.order.domain.OrderMultishipOptionImpl;
import org.broadleafcommerce.core.order.service.FulfillmentGroupService;
import org.broadleafcommerce.core.order.service.OrderItemService;
import org.broadleafcommerce.core.order.service.OrderMultishipOptionService;
import org.broadleafcommerce.core.order.service.OrderService;
import org.broadleafcommerce.core.order.service.call.FulfillmentGroupItemRequest;
import org.broadleafcommerce.profile.core.domain.Address;
import org.easymock.EasyMock;
import org.easymock.IAnswer;

public class FulfillmentGroupOfferProcessorTest
extends TestCase {
    private OfferDao offerDaoMock;
    private OfferServiceImpl offerService;
    private OfferDataItemProvider dataProvider = new OfferDataItemProvider();
    private OrderService orderServiceMock;
    private OrderItemService orderItemServiceMock;
    private FulfillmentGroupItemDao fgItemDaoMock;
    private FulfillmentGroupService fgServiceMock;
    private OrderMultishipOptionService multishipOptionServiceMock;
    private FulfillmentGroupOfferProcessorImpl fgProcessor;

    protected void setUp() throws Exception {
        this.offerService = new OfferServiceImpl();
        CustomerOfferDao customerOfferDaoMock = (CustomerOfferDao)EasyMock.createMock(CustomerOfferDao.class);
        OfferCodeDao offerCodeDaoMock = (OfferCodeDao)EasyMock.createMock(OfferCodeDao.class);
        this.orderServiceMock = (OrderService)EasyMock.createMock(OrderService.class);
        this.orderItemServiceMock = (OrderItemService)EasyMock.createMock(OrderItemService.class);
        this.fgItemDaoMock = (FulfillmentGroupItemDao)EasyMock.createMock(FulfillmentGroupItemDao.class);
        this.offerDaoMock = (OfferDao)EasyMock.createMock(OfferDao.class);
        this.fgServiceMock = (FulfillmentGroupService)EasyMock.createMock(FulfillmentGroupService.class);
        this.multishipOptionServiceMock = (OrderMultishipOptionService)EasyMock.createMock(OrderMultishipOptionService.class);
        OrderItemMergeServiceImpl orderItemMergeService = new OrderItemMergeServiceImpl();
        orderItemMergeService.setOrderService(this.orderServiceMock);
        orderItemMergeService.setFulfillmentGroupItemDao(this.fgItemDaoMock);
        orderItemMergeService.setFulfillmentGroupService(this.fgServiceMock);
        orderItemMergeService.setOrderItemService(this.orderItemServiceMock);
        orderItemMergeService.setOrderMultishipOptionService(this.multishipOptionServiceMock);
        orderItemMergeService.setPromotableItemFactory((PromotableItemFactory)new PromotableItemFactoryImpl());
        this.fgProcessor = new FulfillmentGroupOfferProcessorImpl();
        this.fgProcessor.setOfferDao(this.offerDaoMock);
        this.fgProcessor.setPromotableItemFactory((PromotableItemFactory)new PromotableItemFactoryImpl());
        this.fgProcessor.setOrderItemMergeService((OrderItemMergeService)orderItemMergeService);
        OrderOfferProcessorImpl orderProcessor = new OrderOfferProcessorImpl();
        orderProcessor.setOfferDao(this.offerDaoMock);
        orderProcessor.setPromotableItemFactory((PromotableItemFactory)new PromotableItemFactoryImpl());
        orderProcessor.setOrderItemMergeService((OrderItemMergeService)orderItemMergeService);
        ItemOfferProcessorImpl itemProcessor = new ItemOfferProcessorImpl();
        itemProcessor.setOfferDao(this.offerDaoMock);
        itemProcessor.setPromotableItemFactory((PromotableItemFactory)new PromotableItemFactoryImpl());
        itemProcessor.setOrderItemMergeService((OrderItemMergeService)orderItemMergeService);
        this.offerService.setCustomerOfferDao(customerOfferDaoMock);
        this.offerService.setOfferCodeDao(offerCodeDaoMock);
        this.offerService.setOfferDao(this.offerDaoMock);
        this.offerService.setOrderOfferProcessor((OrderOfferProcessor)orderProcessor);
        this.offerService.setItemOfferProcessor((ItemOfferProcessor)itemProcessor);
        this.offerService.setFulfillmentGroupOfferProcessor((FulfillmentGroupOfferProcessor)this.fgProcessor);
        this.offerService.setPromotableItemFactory((PromotableItemFactory)new PromotableItemFactoryImpl());
        this.offerService.setOrderItemMergeService((OrderItemMergeService)orderItemMergeService);
        this.offerService.setOrderService(this.orderServiceMock);
    }

    public void replay() {
        EasyMock.replay((Object[])new Object[]{this.offerDaoMock});
        EasyMock.replay((Object[])new Object[]{this.orderServiceMock});
        EasyMock.replay((Object[])new Object[]{this.orderItemServiceMock});
        EasyMock.replay((Object[])new Object[]{this.fgItemDaoMock});
        EasyMock.replay((Object[])new Object[]{this.fgServiceMock});
        EasyMock.replay((Object[])new Object[]{this.multishipOptionServiceMock});
    }

    public void verify() {
        EasyMock.verify((Object[])new Object[]{this.offerDaoMock});
        EasyMock.verify((Object[])new Object[]{this.orderServiceMock});
        EasyMock.verify((Object[])new Object[]{this.orderItemServiceMock});
        EasyMock.verify((Object[])new Object[]{this.fgItemDaoMock});
        EasyMock.verify((Object[])new Object[]{this.fgServiceMock});
        EasyMock.verify((Object[])new Object[]{this.multishipOptionServiceMock});
    }

    public void testApplyAllFulfillmentGroupOffersWithOrderItemOffers() throws Exception {
        final ThreadLocal<Order> myOrder = new ThreadLocal<Order>();
        CandidateFulfillmentGroupOfferAnswer candidateFGOfferAnswer = new CandidateFulfillmentGroupOfferAnswer();
        EasyMock.expect((Object)this.offerDaoMock.createCandidateFulfillmentGroupOffer()).andAnswer((IAnswer)candidateFGOfferAnswer).times(6);
        FulfillmentGroupAdjustmentAnswer fgAdjustmentAnswer = new FulfillmentGroupAdjustmentAnswer();
        EasyMock.expect((Object)this.offerDaoMock.createFulfillmentGroupAdjustment()).andAnswer((IAnswer)fgAdjustmentAnswer).times(5);
        CandidateItemOfferAnswer candidateItemOfferAnswer = new CandidateItemOfferAnswer();
        OrderItemAdjustmentAnswer orderItemAdjustmentAnswer = new OrderItemAdjustmentAnswer();
        EasyMock.expect((Object)this.offerDaoMock.createCandidateItemOffer()).andAnswer((IAnswer)candidateItemOfferAnswer).times(2);
        EasyMock.expect((Object)this.offerDaoMock.createOrderItemAdjustment()).andAnswer((IAnswer)orderItemAdjustmentAnswer).times(4);
        EasyMock.expect((Object)this.fgServiceMock.addItemToFulfillmentGroup((FulfillmentGroupItemRequest)EasyMock.isA(FulfillmentGroupItemRequest.class), EasyMock.eq((boolean)false))).andAnswer(OfferDataItemProvider.getAddItemToFulfillmentGroupAnswer()).anyTimes();
        EasyMock.expect((Object)this.orderServiceMock.removeItem((Long)EasyMock.isA(Long.class), (Long)EasyMock.isA(Long.class), EasyMock.eq((boolean)false))).andAnswer(OfferDataItemProvider.getRemoveItemFromOrderAnswer()).anyTimes();
        EasyMock.expect((Object)this.orderServiceMock.save((Order)EasyMock.isA(Order.class), (Boolean)EasyMock.isA(Boolean.class))).andAnswer(OfferDataItemProvider.getSaveOrderAnswer()).anyTimes();
        EasyMock.expect((Object)this.orderServiceMock.getAutomaticallyMergeLikeItems()).andReturn((Object)true).anyTimes();
        EasyMock.expect((Object)this.orderItemServiceMock.saveOrderItem((OrderItem)EasyMock.isA(OrderItem.class))).andAnswer(OfferDataItemProvider.getSaveOrderItemAnswer()).anyTimes();
        EasyMock.expect((Object)this.fgItemDaoMock.save((FulfillmentGroupItem)EasyMock.isA(FulfillmentGroupItem.class))).andAnswer(OfferDataItemProvider.getSaveFulfillmentGroupItemAnswer()).anyTimes();
        EasyMock.expect((Object)this.orderServiceMock.findOrderById((Long)EasyMock.isA(Long.class))).andAnswer((IAnswer)new IAnswer<Order>(){

            public Order answer() throws Throwable {
                return (Order)myOrder.get();
            }
        }).anyTimes();
        EasyMock.expect((Object)this.multishipOptionServiceMock.findOrderMultishipOptions((Long)EasyMock.isA(Long.class))).andAnswer((IAnswer)new IAnswer<List<OrderMultishipOption>>(){

            public List<OrderMultishipOption> answer() throws Throwable {
                ArrayList<OrderMultishipOption> options = new ArrayList<OrderMultishipOption>();
                PromotableOrder order = FulfillmentGroupOfferProcessorTest.this.dataProvider.createBasicOrder();
                for (FulfillmentGroup fg : order.getDelegate().getFulfillmentGroups()) {
                    Address address = fg.getAddress();
                    for (FulfillmentGroupItem fgItem : fg.getFulfillmentGroupItems()) {
                        for (int j = 0; j < fgItem.getQuantity(); ++j) {
                            OrderMultishipOptionImpl option = new OrderMultishipOptionImpl();
                            option.setOrder(order.getDelegate());
                            option.setAddress(address);
                            option.setOrderItem(fgItem.getOrderItem());
                            options.add((OrderMultishipOption)option);
                        }
                    }
                }
                return options;
            }
        }).anyTimes();
        this.multishipOptionServiceMock.deleteAllOrderMultishipOptions((Order)EasyMock.isA(Order.class));
        EasyMock.expectLastCall().anyTimes();
        EasyMock.expect((Object)this.fgServiceMock.collapseToOneFulfillmentGroup((Order)EasyMock.isA(Order.class), EasyMock.eq((boolean)false))).andAnswer((IAnswer)new IAnswer<Order>(){

            public Order answer() throws Throwable {
                Order order = (Order)EasyMock.getCurrentArguments()[0];
                ((FulfillmentGroup)order.getFulfillmentGroups().get(0)).getFulfillmentGroupItems().addAll(((FulfillmentGroup)order.getFulfillmentGroups().get(1)).getFulfillmentGroupItems());
                order.getFulfillmentGroups().remove(order.getFulfillmentGroups().get(1));
                return order;
            }
        }).anyTimes();
        EasyMock.expect((Object)this.fgItemDaoMock.create()).andAnswer(OfferDataItemProvider.getCreateFulfillmentGroupItemAnswer()).anyTimes();
        this.fgItemDaoMock.delete((FulfillmentGroupItem)EasyMock.isA(FulfillmentGroupItem.class));
        EasyMock.expectLastCall().anyTimes();
        this.replay();
        PromotableOrder order = this.dataProvider.createBasicOrder();
        myOrder.set(order.getDelegate());
        ArrayList qualifiedOffers = new ArrayList();
        List<Offer> offers = this.dataProvider.createFGBasedOffer("order.subTotal.getAmount()>20", "fulfillmentGroup.address.postalCode==75244", OfferDiscountType.PERCENT_OFF);
        offers.addAll(this.dataProvider.createFGBasedOfferWithItemCriteria("order.subTotal.getAmount()>20", "fulfillmentGroup.address.postalCode==75244", OfferDiscountType.PERCENT_OFF, "([MVEL.eval(\"toUpperCase()\",\"test1\")] contains MVEL.eval(\"toUpperCase()\", discreteOrderItem.category.name))"));
        offers.get(1).setName("secondOffer");
        offers.get(0).setTotalitarianOffer(Boolean.valueOf(true));
        offers.addAll(this.dataProvider.createItemBasedOfferWithItemCriteria("order.subTotal.getAmount()>20", OfferDiscountType.PERCENT_OFF, "([MVEL.eval(\"toUpperCase()\",\"test1\"), MVEL.eval(\"toUpperCase()\",\"test2\")] contains MVEL.eval(\"toUpperCase()\", discreteOrderItem.category.name))", "([MVEL.eval(\"toUpperCase()\",\"test1\"), MVEL.eval(\"toUpperCase()\",\"test2\")] contains MVEL.eval(\"toUpperCase()\", discreteOrderItem.category.name))"));
        this.offerService.applyOffersToOrder(offers, order.getDelegate());
        order.getDelegate().getFulfillmentGroups().clear();
        order.getDelegate().getFulfillmentGroups().addAll(this.dataProvider.createBasicOrder().getDelegate().getFulfillmentGroups());
        this.fgProcessor.filterFulfillmentGroupLevelOffer(order, qualifiedOffers, offers.get(0));
        this.fgProcessor.filterFulfillmentGroupLevelOffer(order, qualifiedOffers, offers.get(1));
        boolean offerApplied = this.fgProcessor.applyAllFulfillmentGroupOffers(qualifiedOffers, order);
        FulfillmentGroupOfferProcessorTest.assertTrue((boolean)offerApplied);
        int fgAdjustmentCount = 0;
        for (PromotableFulfillmentGroup fg : order.getFulfillmentGroups()) {
            fgAdjustmentCount += fg.getDelegate().getFulfillmentGroupAdjustments().size();
        }
        FulfillmentGroupOfferProcessorTest.assertTrue((fgAdjustmentCount == 1 ? 1 : 0) != 0);
        order = this.dataProvider.createBasicOrder();
        myOrder.set(order.getDelegate());
        offers.get(2).setValue(new BigDecimal("1"));
        this.offerService.applyOffersToOrder(offers, order.getDelegate());
        order.getDelegate().getFulfillmentGroups().clear();
        order.getDelegate().getFulfillmentGroups().addAll(this.dataProvider.createBasicOrder().getDelegate().getFulfillmentGroups());
        qualifiedOffers = new ArrayList();
        this.fgProcessor.filterFulfillmentGroupLevelOffer(order, qualifiedOffers, offers.get(0));
        this.fgProcessor.filterFulfillmentGroupLevelOffer(order, qualifiedOffers, offers.get(1));
        offerApplied = this.fgProcessor.applyAllFulfillmentGroupOffers(qualifiedOffers, order);
        FulfillmentGroupOfferProcessorTest.assertTrue((boolean)offerApplied);
        fgAdjustmentCount = 0;
        for (PromotableFulfillmentGroup fg : order.getFulfillmentGroups()) {
            fgAdjustmentCount += fg.getDelegate().getFulfillmentGroupAdjustments().size();
        }
        FulfillmentGroupOfferProcessorTest.assertTrue((fgAdjustmentCount == 2 ? 1 : 0) != 0);
        int itemAdjustmentCount = 0;
        for (PromotableOrderItem item : order.getDiscreteOrderItems()) {
            itemAdjustmentCount += item.getDelegate().getOrderItemAdjustments().size();
        }
        FulfillmentGroupOfferProcessorTest.assertTrue((itemAdjustmentCount == 0 ? 1 : 0) != 0);
        this.verify();
    }

    public void testApplyAllFulfillmentGroupOffers() {
        CandidateFulfillmentGroupOfferAnswer answer = new CandidateFulfillmentGroupOfferAnswer();
        EasyMock.expect((Object)this.offerDaoMock.createCandidateFulfillmentGroupOffer()).andAnswer((IAnswer)answer).times(5);
        FulfillmentGroupAdjustmentAnswer answer2 = new FulfillmentGroupAdjustmentAnswer();
        EasyMock.expect((Object)this.offerDaoMock.createFulfillmentGroupAdjustment()).andAnswer((IAnswer)answer2).times(5);
        this.replay();
        PromotableOrder order = this.dataProvider.createBasicOrder();
        ArrayList qualifiedOffers = new ArrayList();
        List<Offer> offers = this.dataProvider.createFGBasedOffer("order.subTotal.getAmount()>20", "fulfillmentGroup.address.postalCode==75244", OfferDiscountType.PERCENT_OFF);
        this.fgProcessor.filterFulfillmentGroupLevelOffer(order, qualifiedOffers, offers.get(0));
        boolean offerApplied = this.fgProcessor.applyAllFulfillmentGroupOffers(qualifiedOffers, order);
        FulfillmentGroupOfferProcessorTest.assertTrue((boolean)offerApplied);
        order = this.dataProvider.createBasicOrder();
        qualifiedOffers = new ArrayList();
        offers = this.dataProvider.createFGBasedOffer("order.subTotal.getAmount()>20", "fulfillmentGroup.address.postalCode==75244", OfferDiscountType.PERCENT_OFF);
        offers.addAll(this.dataProvider.createFGBasedOfferWithItemCriteria("order.subTotal.getAmount()>20", "fulfillmentGroup.address.postalCode==75244", OfferDiscountType.PERCENT_OFF, "([MVEL.eval(\"toUpperCase()\",\"test1\")] contains MVEL.eval(\"toUpperCase()\", discreteOrderItem.category.name))"));
        offers.get(1).setName("secondOffer");
        this.fgProcessor.filterFulfillmentGroupLevelOffer(order, qualifiedOffers, offers.get(0));
        this.fgProcessor.filterFulfillmentGroupLevelOffer(order, qualifiedOffers, offers.get(1));
        offerApplied = this.fgProcessor.applyAllFulfillmentGroupOffers(qualifiedOffers, order);
        FulfillmentGroupOfferProcessorTest.assertTrue((boolean)offerApplied);
        int fgAdjustmentCount = 0;
        for (PromotableFulfillmentGroup fg : order.getFulfillmentGroups()) {
            fgAdjustmentCount += fg.getDelegate().getFulfillmentGroupAdjustments().size();
        }
        FulfillmentGroupOfferProcessorTest.assertTrue((fgAdjustmentCount == 3 ? 1 : 0) != 0);
        this.verify();
    }

    public void testFilterFulfillmentGroupLevelOffer() {
        CandidateFulfillmentGroupOfferAnswer answer = new CandidateFulfillmentGroupOfferAnswer();
        EasyMock.expect((Object)this.offerDaoMock.createCandidateFulfillmentGroupOffer()).andAnswer((IAnswer)answer).times(3);
        this.replay();
        PromotableOrder order = this.dataProvider.createBasicOrder();
        ArrayList qualifiedOffers = new ArrayList();
        List<Offer> offers = this.dataProvider.createFGBasedOffer("order.subTotal.getAmount()>20", "fulfillmentGroup.address.postalCode==75244", OfferDiscountType.PERCENT_OFF);
        this.fgProcessor.filterFulfillmentGroupLevelOffer(order, qualifiedOffers, offers.get(0));
        FulfillmentGroupOfferProcessorTest.assertTrue((qualifiedOffers.size() == 2 && ((PromotableCandidateFulfillmentGroupOffer)qualifiedOffers.get(0)).getOffer().equals(offers.get(0)) ? 1 : 0) != 0);
        qualifiedOffers = new ArrayList();
        offers = this.dataProvider.createFGBasedOfferWithItemCriteria("order.subTotal.getAmount()>20", "fulfillmentGroup.address.postalCode==75244", OfferDiscountType.PERCENT_OFF, "([MVEL.eval(\"toUpperCase()\",\"test1\")] contains MVEL.eval(\"toUpperCase()\", discreteOrderItem.category.name))");
        this.fgProcessor.filterFulfillmentGroupLevelOffer(order, qualifiedOffers, offers.get(0));
        FulfillmentGroupOfferProcessorTest.assertTrue((qualifiedOffers.size() == 1 && ((PromotableCandidateFulfillmentGroupOffer)qualifiedOffers.get(0)).getOffer().equals(offers.get(0)) ? 1 : 0) != 0);
        qualifiedOffers = new ArrayList();
        offers = this.dataProvider.createFGBasedOfferWithItemCriteria("order.subTotal.getAmount()>20", "fulfillmentGroup.address.postalCode==75240", OfferDiscountType.PERCENT_OFF, "([MVEL.eval(\"toUpperCase()\",\"test1\"),MVEL.eval(\"toUpperCase()\",\"test2\")] contains MVEL.eval(\"toUpperCase()\", discreteOrderItem.category.name))");
        this.fgProcessor.filterFulfillmentGroupLevelOffer(order, qualifiedOffers, offers.get(0));
        FulfillmentGroupOfferProcessorTest.assertTrue((qualifiedOffers.size() == 0 ? 1 : 0) != 0);
        qualifiedOffers = new ArrayList();
        offers = this.dataProvider.createFGBasedOfferWithItemCriteria("order.subTotal.getAmount()>20", "fulfillmentGroup.address.postalCode==75244", OfferDiscountType.PERCENT_OFF, "([MVEL.eval(\"toUpperCase()\",\"test5\"),MVEL.eval(\"toUpperCase()\",\"test6\")] contains MVEL.eval(\"toUpperCase()\", discreteOrderItem.category.name))");
        this.fgProcessor.filterFulfillmentGroupLevelOffer(order, qualifiedOffers, offers.get(0));
        FulfillmentGroupOfferProcessorTest.assertTrue((qualifiedOffers.size() == 0 ? 1 : 0) != 0);
        this.verify();
    }

    public void testCouldOfferApplyToFulfillmentGroup() {
        this.replay();
        PromotableOrder order = this.dataProvider.createBasicOrder();
        List<Offer> offers = this.dataProvider.createFGBasedOffer("order.subTotal.getAmount()>20", "fulfillmentGroup.address.postalCode==75244", OfferDiscountType.PERCENT_OFF);
        boolean couldApply = this.fgProcessor.couldOfferApplyToFulfillmentGroup(offers.get(0), (PromotableFulfillmentGroup)order.getFulfillmentGroups().get(0));
        FulfillmentGroupOfferProcessorTest.assertTrue((boolean)couldApply);
        offers = this.dataProvider.createFGBasedOffer("order.subTotal.getAmount()>20", "fulfillmentGroup.address.postalCode==75240", OfferDiscountType.PERCENT_OFF);
        couldApply = this.fgProcessor.couldOfferApplyToFulfillmentGroup(offers.get(0), (PromotableFulfillmentGroup)order.getFulfillmentGroups().get(0));
        FulfillmentGroupOfferProcessorTest.assertFalse((boolean)couldApply);
        this.verify();
    }

    public void testCouldOrderItemMeetOfferRequirement() {
        this.replay();
        PromotableOrder order = this.dataProvider.createBasicOrder();
        List<Offer> offers = this.dataProvider.createFGBasedOfferWithItemCriteria("order.subTotal.getAmount()>20", "fulfillmentGroup.address.postalCode==75244", OfferDiscountType.PERCENT_OFF, "([MVEL.eval(\"toUpperCase()\",\"test1\"), MVEL.eval(\"toUpperCase()\",\"test2\")] contains MVEL.eval(\"toUpperCase()\", discreteOrderItem.category.name))");
        boolean couldApply = this.fgProcessor.couldOrderItemMeetOfferRequirement((OfferItemCriteria)offers.get(0).getQualifyingItemCriteria().iterator().next(), (PromotableOrderItem)order.getDiscreteOrderItems().get(0));
        FulfillmentGroupOfferProcessorTest.assertTrue((boolean)couldApply);
        offers = this.dataProvider.createFGBasedOfferWithItemCriteria("order.subTotal.getAmount()>20", "fulfillmentGroup.address.postalCode==75244", OfferDiscountType.PERCENT_OFF, "([MVEL.eval(\"toUpperCase()\",\"test5\"), MVEL.eval(\"toUpperCase()\",\"test6\")] contains MVEL.eval(\"toUpperCase()\", discreteOrderItem.category.name))");
        couldApply = this.fgProcessor.couldOrderItemMeetOfferRequirement((OfferItemCriteria)offers.get(0).getQualifyingItemCriteria().iterator().next(), (PromotableOrderItem)order.getDiscreteOrderItems().get(0));
        FulfillmentGroupOfferProcessorTest.assertFalse((boolean)couldApply);
        this.verify();
    }

    public void testCouldOfferApplyToOrderItems() {
        this.replay();
        PromotableOrder order = this.dataProvider.createBasicOrder();
        ArrayList<PromotableOrderItem> orderItems = new ArrayList<PromotableOrderItem>();
        for (PromotableOrderItem orderItem : order.getDiscountableDiscreteOrderItems()) {
            orderItems.add(orderItem);
        }
        List<Offer> offers = this.dataProvider.createFGBasedOfferWithItemCriteria("order.subTotal.getAmount()>20", "fulfillmentGroup.address.postalCode==75244", OfferDiscountType.PERCENT_OFF, "([MVEL.eval(\"toUpperCase()\",\"test1\"), MVEL.eval(\"toUpperCase()\",\"test2\")] contains MVEL.eval(\"toUpperCase()\", discreteOrderItem.category.name))");
        CandidatePromotionItems candidates = this.fgProcessor.couldOfferApplyToOrderItems(offers.get(0), orderItems);
        FulfillmentGroupOfferProcessorTest.assertTrue((candidates.isMatchedQualifier() && candidates.getCandidateQualifiersMap().size() == 1 ? 1 : 0) != 0);
        offers = this.dataProvider.createFGBasedOfferWithItemCriteria("order.subTotal.getAmount()>20", "fulfillmentGroup.address.postalCode==75244", OfferDiscountType.PERCENT_OFF, "([MVEL.eval(\"toUpperCase()\",\"test5\"), MVEL.eval(\"toUpperCase()\",\"test6\")] contains MVEL.eval(\"toUpperCase()\", discreteOrderItem.category.name))");
        candidates = this.fgProcessor.couldOfferApplyToOrderItems(offers.get(0), orderItems);
        FulfillmentGroupOfferProcessorTest.assertFalse((candidates.isMatchedQualifier() && candidates.getCandidateQualifiersMap().size() == 1 ? 1 : 0) != 0);
        this.verify();
    }

    public class OrderItemAdjustmentAnswer
    implements IAnswer<OrderItemAdjustment> {
        public OrderItemAdjustment answer() throws Throwable {
            return new OrderItemAdjustmentImpl();
        }
    }

    public class CandidateItemOfferAnswer
    implements IAnswer<CandidateItemOffer> {
        public CandidateItemOffer answer() throws Throwable {
            return new CandidateItemOfferImpl();
        }
    }

    public class FulfillmentGroupAdjustmentAnswer
    implements IAnswer<FulfillmentGroupAdjustment> {
        public FulfillmentGroupAdjustment answer() throws Throwable {
            return new FulfillmentGroupAdjustmentImpl();
        }
    }

    public class CandidateFulfillmentGroupOfferAnswer
    implements IAnswer<CandidateFulfillmentGroupOffer> {
        public CandidateFulfillmentGroupOffer answer() throws Throwable {
            return new CandidateFulfillmentGroupOfferImpl();
        }
    }
}

