/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.core.offer.service.discount.domain;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.List;
import org.broadleafcommerce.common.money.Money;
import org.broadleafcommerce.core.offer.domain.CandidateOrderOffer;
import org.broadleafcommerce.core.offer.domain.Offer;
import org.broadleafcommerce.core.offer.domain.OfferItemCriteria;
import org.broadleafcommerce.core.offer.service.discount.domain.PromotableCandidateOrderOffer;
import org.broadleafcommerce.core.offer.service.discount.domain.PromotableOrder;
import org.broadleafcommerce.core.offer.service.discount.domain.PromotableOrderItem;
import org.broadleafcommerce.core.offer.service.type.OfferDiscountType;
import org.broadleafcommerce.core.order.domain.Order;

public class PromotableCandidateOrderOfferImpl
implements PromotableCandidateOrderOffer {
    private static final long serialVersionUID = 1L;
    protected HashMap<OfferItemCriteria, List<PromotableOrderItem>> candidateQualifiersMap = new HashMap();
    protected CandidateOrderOffer delegate;
    protected PromotableOrder order;

    public PromotableCandidateOrderOfferImpl(CandidateOrderOffer candidateOrderOffer, PromotableOrder order) {
        this.delegate = candidateOrderOffer;
        this.order = order;
    }

    @Override
    public HashMap<OfferItemCriteria, List<PromotableOrderItem>> getCandidateQualifiersMap() {
        return this.candidateQualifiersMap;
    }

    @Override
    public void setCandidateQualifiersMap(HashMap<OfferItemCriteria, List<PromotableOrderItem>> candidateItemsMap) {
        this.candidateQualifiersMap = candidateItemsMap;
    }

    @Override
    public void computeDiscountedPriceAndAmount() {
        if (this.getOffer() != null && this.getOrder() != null && this.getOrder().getSubTotal() != null) {
            Money priceToUse = this.getOrder().getSubTotal();
            Money discountAmount = new Money(0);
            if (this.getOffer().getDiscountType().equals(OfferDiscountType.AMOUNT_OFF)) {
                discountAmount = new Money(this.getOffer().getValue());
            } else if (this.getOffer().getDiscountType().equals(OfferDiscountType.FIX_PRICE)) {
                discountAmount = priceToUse.subtract(new Money(this.getOffer().getValue()));
            } else if (this.getOffer().getDiscountType().equals(OfferDiscountType.PERCENT_OFF)) {
                discountAmount = priceToUse.multiply(this.getOffer().getValue().divide(new BigDecimal("100")));
            }
            if (discountAmount.greaterThan(priceToUse)) {
                discountAmount = priceToUse;
            }
            priceToUse = priceToUse.subtract(discountAmount);
            this.setDiscountedPrice(priceToUse);
        }
    }

    @Override
    public void reset() {
        this.delegate = null;
    }

    @Override
    public CandidateOrderOffer getDelegate() {
        return this.delegate;
    }

    @Override
    public PromotableOrder getOrder() {
        return this.order;
    }

    @Override
    public Offer getOffer() {
        return this.delegate.getOffer();
    }

    public Money getDiscountedPrice() {
        if (this.delegate.getDiscountedPrice() == null) {
            this.computeDiscountedPriceAndAmount();
        }
        return this.delegate.getDiscountedPrice();
    }

    public void setDiscountedPrice(Money discountedPrice) {
        this.delegate.setDiscountedPrice(discountedPrice);
    }

    public Long getId() {
        return this.delegate.getId();
    }

    public void setId(Long id) {
        this.delegate.setId(id);
    }

    public void setOrder(Order order) {
        this.order = (PromotableOrder)((Object)order);
        this.delegate.setOrder(this.order.getDelegate());
    }

    public void setOffer(Offer offer) {
        this.delegate.setOffer(offer);
    }

    public int getPriority() {
        return this.delegate.getPriority();
    }
}

