/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.core.catalog.dao;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Resource;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;
import javax.persistence.TypedQuery;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.From;
import javax.persistence.criteria.Join;
import javax.persistence.criteria.Order;
import javax.persistence.criteria.Path;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Selection;
import org.apache.commons.lang.StringUtils;
import org.broadleafcommerce.common.persistence.EntityConfiguration;
import org.broadleafcommerce.common.persistence.Status;
import org.broadleafcommerce.common.time.SystemTime;
import org.broadleafcommerce.core.catalog.dao.ProductDao;
import org.broadleafcommerce.core.catalog.domain.CategoryImpl;
import org.broadleafcommerce.core.catalog.domain.Product;
import org.broadleafcommerce.core.catalog.domain.ProductBundle;
import org.broadleafcommerce.core.catalog.domain.ProductImpl;
import org.broadleafcommerce.core.catalog.domain.Sku;
import org.broadleafcommerce.core.catalog.service.type.ProductType;
import org.broadleafcommerce.core.search.domain.ProductSearchCriteria;
import org.springframework.stereotype.Repository;

@Repository(value="blProductDao")
public class ProductDaoImpl
implements ProductDao {
    @PersistenceContext(unitName="blPU")
    protected EntityManager em;
    @Resource(name="blEntityConfiguration")
    protected EntityConfiguration entityConfiguration;
    protected Long currentDateResolution = 10000L;
    private Date currentDate = SystemTime.asDate();
    private String DATE_LOCK = "DATE_LOCK";

    @Override
    public Product save(Product product) {
        return (Product)this.em.merge((Object)product);
    }

    @Override
    public Product readProductById(Long productId) {
        return (Product)this.em.find(ProductImpl.class, (Object)productId);
    }

    @Override
    public List<Product> readProductsByIds(List<Long> productIds) {
        if (productIds == null || productIds.size() == 0) {
            return null;
        }
        CriteriaBuilder builder = this.em.getCriteriaBuilder();
        CriteriaQuery criteria = builder.createQuery(Product.class);
        Root product = criteria.from(ProductImpl.class);
        criteria.select((Selection)product);
        criteria.where((Expression)product.get("id").as(Long.class).in(productIds));
        return this.em.createQuery(criteria).getResultList();
    }

    @Override
    public List<Product> readProductsByName(String searchName) {
        TypedQuery query = this.em.createNamedQuery("BC_READ_PRODUCTS_BY_NAME", Product.class);
        query.setParameter("name", (Object)(searchName + '%'));
        query.setHint("org.hibernate.cacheable", (Object)true);
        return query.getResultList();
    }

    @Override
    public List<Product> readProductsByName(@Nonnull String searchName, @Nonnull int limit, @Nonnull int offset) {
        TypedQuery query = this.em.createNamedQuery("BC_READ_PRODUCTS_BY_NAME", Product.class);
        query.setParameter("name", (Object)(searchName + '%'));
        query.setFirstResult(offset);
        query.setMaxResults(limit);
        return query.getResultList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Date getDateFactoringInDateResolution(Date currentDate) {
        Date myDate;
        Long myCurrentDateResolution = this.currentDateResolution;
        String string = this.DATE_LOCK;
        synchronized (string) {
            if (currentDate.getTime() - this.currentDate.getTime() > myCurrentDateResolution) {
                this.currentDate = new Date(currentDate.getTime());
                myDate = currentDate;
            } else {
                myDate = this.currentDate;
            }
        }
        return myDate;
    }

    @Override
    public List<Product> readActiveProductsByCategory(Long categoryId, Date currentDate) {
        Date myDate = this.getDateFactoringInDateResolution(currentDate);
        TypedQuery query = this.em.createNamedQuery("BC_READ_ACTIVE_PRODUCTS_BY_CATEGORY", Product.class);
        query.setParameter("categoryId", (Object)categoryId);
        query.setParameter("currentDate", (Object)myDate);
        query.setHint("org.hibernate.cacheable", (Object)true);
        query.setHint("org.hibernate.cacheRegion", (Object)"query.Catalog");
        return query.getResultList();
    }

    @Override
    public List<Product> readFilteredActiveProductsByQuery(String query, Date currentDate, ProductSearchCriteria searchCriteria) {
        CriteriaBuilder builder = this.em.getCriteriaBuilder();
        CriteriaQuery criteria = builder.createQuery(Product.class);
        Root product = criteria.from(ProductImpl.class);
        Join sku = product.join("defaultSku");
        criteria.select((Selection)product);
        ArrayList<Predicate> restrictions = new ArrayList<Predicate>();
        String lq = query.toLowerCase();
        restrictions.add(builder.or((Expression)builder.like(builder.lower(sku.get("name").as(String.class)), '%' + lq + '%'), (Expression)builder.like(builder.lower(sku.get("longDescription").as(String.class)), '%' + lq + '%')));
        this.attachProductSearchCriteria(searchCriteria, (From<?, ? extends Product>)product, (From<?, ? extends Sku>)sku, (List<Predicate>)restrictions);
        this.attachActiveRestriction(currentDate, (Path<? extends Product>)product, (Path<? extends Sku>)sku, restrictions);
        this.attachOrderBy(searchCriteria, (From<?, ? extends Product>)product, (Path<? extends Sku>)sku, (CriteriaQuery<?>)criteria);
        criteria.where(restrictions.toArray(new Predicate[restrictions.size()]));
        return this.em.createQuery(criteria).getResultList();
    }

    @Override
    public List<Product> readFilteredActiveProductsByCategory(Long categoryId, Date currentDate, ProductSearchCriteria searchCriteria) {
        CriteriaBuilder builder = this.em.getCriteriaBuilder();
        CriteriaQuery criteria = builder.createQuery(Product.class);
        Root category = criteria.from(CategoryImpl.class);
        Join product = category.join("allProducts");
        Join sku = product.join("defaultSku");
        criteria.select((Selection)product);
        ArrayList<Predicate> restrictions = new ArrayList<Predicate>();
        restrictions.add(builder.equal((Expression)category.get("id"), (Object)categoryId));
        this.attachProductSearchCriteria(searchCriteria, (From<?, ? extends Product>)product, (From<?, ? extends Sku>)sku, (List<Predicate>)restrictions);
        this.attachActiveRestriction(currentDate, (Path<? extends Product>)product, (Path<? extends Sku>)sku, restrictions);
        this.attachOrderBy(searchCriteria, (From<?, ? extends Product>)product, (Path<? extends Sku>)sku, (CriteriaQuery<?>)criteria);
        criteria.where(restrictions.toArray(new Predicate[restrictions.size()]));
        return this.em.createQuery(criteria).getResultList();
    }

    protected void attachActiveRestriction(Date currentDate, Path<? extends Product> product, Path<? extends Sku> sku, List<Predicate> restrictions) {
        CriteriaBuilder builder = this.em.getCriteriaBuilder();
        restrictions.add(builder.or((Expression)builder.isNull((Expression)product.get("archiveStatus").get("archived")), (Expression)builder.equal((Expression)product.get("archiveStatus").get("archived"), (Object)Character.valueOf('N'))));
        Date myDate = this.getDateFactoringInDateResolution(currentDate);
        restrictions.add(builder.lessThan(sku.get("activeStartDate").as(Date.class), (Comparable)myDate));
        restrictions.add(builder.or((Expression)builder.isNull((Expression)sku.get("activeEndDate")), (Expression)builder.greaterThan(sku.get("activeEndDate").as(Date.class), (Comparable)myDate)));
    }

    protected void attachOrderBy(ProductSearchCriteria searchCriteria, From<?, ? extends Product> product, Path<? extends Sku> sku, CriteriaQuery<?> criteria) {
        if (StringUtils.isNotBlank((String)searchCriteria.getSortQuery())) {
            CriteriaBuilder builder = this.em.getCriteriaBuilder();
            ArrayList<Order> sorts = new ArrayList<Order>();
            String sortQueries = searchCriteria.getSortQuery();
            for (String sortQuery : sortQueries.split(",")) {
                Path<? extends Sku> pathToUse;
                String[] sort = sortQuery.split(" ");
                if (sort.length != 2) continue;
                String key = sort[0];
                boolean asc = sort[1].toLowerCase().contains("asc");
                if (key.contains("defaultSku.")) {
                    pathToUse = sku;
                    key = key.substring("defaultSku.".length());
                } else {
                    if (!key.contains("product.")) continue;
                    pathToUse = product;
                    key = key.substring("product.".length());
                }
                if (asc) {
                    sorts.add(builder.asc((Expression)pathToUse.get(key)));
                    continue;
                }
                sorts.add(builder.desc((Expression)pathToUse.get(key)));
            }
            criteria.orderBy(sorts.toArray(new Order[sorts.size()]));
        }
    }

    protected void attachProductSearchCriteria(ProductSearchCriteria searchCriteria, From<?, ? extends Product> product, From<?, ? extends Sku> sku, List<Predicate> restrictions) {
        CriteriaBuilder builder = this.em.getCriteriaBuilder();
        for (Map.Entry<String, String[]> entry : searchCriteria.getFilterCriteria().entrySet()) {
            From<?, ? extends Product> pathToUse;
            String key = entry.getKey();
            ArrayList<String> eqValues = new ArrayList<String>();
            ArrayList<String[]> rangeValues = new ArrayList<String[]>();
            if (key.contains("defaultSku.")) {
                pathToUse = sku;
                key = key.substring("defaultSku.".length());
            } else if (key.contains("productAttributes.")) {
                pathToUse = product.join("productAttributes");
                key = key.substring("productAttributes.".length());
                restrictions.add(builder.equal(pathToUse.get("name").as(String.class), (Object)key));
                key = "value";
            } else {
                if (!key.contains("product.")) continue;
                pathToUse = product;
                key = key.substring("product.".length());
            }
            for (String value : entry.getValue()) {
                if (value.contains("range[")) {
                    String[] rangeValue = new String[]{value.substring(value.indexOf("[") + 1, value.indexOf(":")), value.substring(value.indexOf(":") + 1, value.indexOf("]"))};
                    rangeValues.add(rangeValue);
                    continue;
                }
                eqValues.add(value);
            }
            if (eqValues.size() > 0) {
                restrictions.add(pathToUse.get(key).in(eqValues));
            }
            ArrayList<Predicate> rangeRestrictions = new ArrayList<Predicate>();
            for (String[] range : rangeValues) {
                BigDecimal min = new BigDecimal(range[0]);
                BigDecimal max = null;
                if (range[1] != null && !range[1].equals("null")) {
                    max = new BigDecimal(range[1]);
                }
                Predicate minRange = builder.greaterThan(pathToUse.get(key).as(BigDecimal.class), (Comparable)min);
                Predicate maxRange = null;
                if (max != null) {
                    maxRange = builder.lessThan(pathToUse.get(key).as(BigDecimal.class), (Comparable)max);
                    rangeRestrictions.add(builder.and((Expression)minRange, (Expression)maxRange));
                    continue;
                }
                rangeRestrictions.add(minRange);
            }
            if (rangeRestrictions.size() <= 0) continue;
            restrictions.add(builder.or(rangeRestrictions.toArray(new Predicate[rangeRestrictions.size()])));
        }
    }

    @Override
    public List<Product> readActiveProductsByCategory(Long categoryId, Date currentDate, int limit, int offset) {
        Date myDate = this.getDateFactoringInDateResolution(currentDate);
        TypedQuery query = this.em.createNamedQuery("BC_READ_ACTIVE_PRODUCTS_BY_CATEGORY", Product.class);
        query.setParameter("categoryId", (Object)categoryId);
        query.setParameter("currentDate", (Object)myDate);
        query.setFirstResult(offset);
        query.setMaxResults(limit);
        return query.getResultList();
    }

    @Override
    public List<Product> readProductsByCategory(Long categoryId) {
        TypedQuery query = this.em.createNamedQuery("BC_READ_PRODUCTS_BY_CATEGORY", Product.class);
        query.setParameter("categoryId", (Object)categoryId);
        query.setHint("org.hibernate.cacheable", (Object)true);
        query.setHint("org.hibernate.cacheRegion", (Object)"query.Catalog");
        return query.getResultList();
    }

    @Override
    public List<Product> readProductsByCategory(Long categoryId, int limit, int offset) {
        TypedQuery query = this.em.createNamedQuery("BC_READ_PRODUCTS_BY_CATEGORY", Product.class);
        query.setParameter("categoryId", (Object)categoryId);
        query.setFirstResult(offset);
        query.setMaxResults(limit);
        return query.getResultList();
    }

    @Override
    public void delete(Product product) {
        ((Status)product).setArchived(Character.valueOf('Y'));
        this.em.merge((Object)product);
    }

    @Override
    public Product create(ProductType productType) {
        return (Product)this.entityConfiguration.createEntityInstance(productType.getType());
    }

    @Override
    public List<ProductBundle> readAutomaticProductBundles() {
        Date myDate = this.getDateFactoringInDateResolution(this.currentDate);
        TypedQuery query = this.em.createNamedQuery("BC_READ_AUTOMATIC_PRODUCT_BUNDLES", ProductBundle.class);
        query.setParameter("currentDate", (Object)myDate);
        query.setParameter("autoBundle", (Object)Boolean.TRUE);
        query.setHint("org.hibernate.cacheable", (Object)true);
        return query.getResultList();
    }

    public Long getCurrentDateResolution() {
        return this.currentDateResolution;
    }

    public void setCurrentDateResolution(Long currentDateResolution) {
        this.currentDateResolution = currentDateResolution;
    }

    @Override
    public List<Product> findProductByURI(String uri) {
        String urlKey = uri.substring(uri.lastIndexOf(47));
        Query query = this.em.createNamedQuery("BC_READ_PRODUCTS_BY_OUTGOING_URL");
        query.setParameter("url", (Object)uri);
        query.setParameter("urlKey", (Object)urlKey);
        List results = query.getResultList();
        return results;
    }

    @Override
    public List<Product> readAllActiveProducts(Date currentDate) {
        CriteriaBuilder builder = this.em.getCriteriaBuilder();
        CriteriaQuery criteria = builder.createQuery(Product.class);
        Root product = criteria.from(ProductImpl.class);
        Join sku = product.join("defaultSku");
        criteria.select((Selection)product);
        ArrayList<Predicate> restrictions = new ArrayList<Predicate>();
        this.attachActiveRestriction(currentDate, (Path<? extends Product>)product, (Path<? extends Sku>)sku, restrictions);
        criteria.where(restrictions.toArray(new Predicate[restrictions.size()]));
        return this.em.createQuery(criteria).getResultList();
    }
}

