/*
 * Copyright 2012 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.broadleafcommerce.core.order.service.workflow;

import org.broadleafcommerce.core.order.domain.Order;
import org.broadleafcommerce.core.order.domain.OrderItem;
import org.broadleafcommerce.core.order.service.call.OrderItemRequestDTO;

/**
 * This class represents the basic context necessary for the execution
 * of a particular order process workflow operation.
 * 
 * @author apazzolini
 */
public class CartOperationRequest {

	protected OrderItemRequestDTO itemRequest;
	
	protected Order order;
	
	protected boolean priceOrder;
	
	// Set during the course of the workflow for use in subsequent workflow steps
	protected OrderItem addedOrderItem;
	
	// Set during the course of the workflow for use in subsequent workflow steps
	protected Integer orderItemQuantityDelta;
	
	public CartOperationRequest(Order order, OrderItemRequestDTO itemRequest, boolean priceOrder) {
		setOrder(order);
		setItemRequest(itemRequest);
		setPriceOrder(priceOrder);
	}
	
	public OrderItemRequestDTO getItemRequest() {
		return itemRequest;
	}

	public void setItemRequest(OrderItemRequestDTO itemRequest) {
		this.itemRequest = itemRequest;
	}

	public Order getOrder() {
		return order;
	}

	public void setOrder(Order order) {
		this.order = order;
	}

	public boolean isPriceOrder() {
		return priceOrder;
	}

	public void setPriceOrder(boolean priceOrder) {
		this.priceOrder = priceOrder;
	}

	public OrderItem getAddedOrderItem() {
		return addedOrderItem;
	}

	public void setAddedOrderItem(OrderItem addedOrderItem) {
		this.addedOrderItem = addedOrderItem;
	}

	public Integer getOrderItemQuantityDelta() {
		return orderItemQuantityDelta;
	}

	public void setOrderItemQuantityDelta(Integer orderItemQuantityDelta) {
		this.orderItemQuantityDelta = orderItemQuantityDelta;
	}
	
}
