/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.core.order.domain;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import org.broadleafcommerce.common.money.Money;
import org.broadleafcommerce.common.presentation.AdminPresentation;
import org.broadleafcommerce.common.presentation.AdminPresentationClass;
import org.broadleafcommerce.common.presentation.client.SupportedFieldType;
import org.broadleafcommerce.core.catalog.domain.Product;
import org.broadleafcommerce.core.catalog.domain.ProductBundle;
import org.broadleafcommerce.core.catalog.domain.ProductBundleImpl;
import org.broadleafcommerce.core.catalog.domain.Sku;
import org.broadleafcommerce.core.catalog.domain.SkuImpl;
import org.broadleafcommerce.core.catalog.service.type.ProductBundlePricingModelType;
import org.broadleafcommerce.core.order.domain.BundleOrderItem;
import org.broadleafcommerce.core.order.domain.BundleOrderItemFeePrice;
import org.broadleafcommerce.core.order.domain.BundleOrderItemFeePriceImpl;
import org.broadleafcommerce.core.order.domain.DiscreteOrderItem;
import org.broadleafcommerce.core.order.domain.DiscreteOrderItemImpl;
import org.broadleafcommerce.core.order.domain.OrderItem;
import org.broadleafcommerce.core.order.domain.OrderItemImpl;
import org.broadleafcommerce.core.order.service.manipulation.OrderItemVisitor;
import org.broadleafcommerce.core.pricing.service.exception.PricingException;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.hibernate.annotations.Cascade;
import org.hibernate.annotations.NotFound;
import org.hibernate.annotations.NotFoundAction;

@Entity
@Inheritance(strategy=InheritanceType.JOINED)
@Table(name="BLC_BUNDLE_ORDER_ITEM")
@Cache(usage=CacheConcurrencyStrategy.NONSTRICT_READ_WRITE, region="blOrderElements")
@AdminPresentationClass(friendlyName="BundleOrderItemImpl_bundleOrderItem")
public class BundleOrderItemImpl
extends OrderItemImpl
implements BundleOrderItem {
    private static final long serialVersionUID = 1L;
    @OneToMany(mappedBy="bundleOrderItem", targetEntity=DiscreteOrderItemImpl.class, cascade={CascadeType.ALL})
    @Cache(usage=CacheConcurrencyStrategy.NONSTRICT_READ_WRITE, region="blOrderElements")
    protected List<DiscreteOrderItem> discreteOrderItems = new ArrayList<DiscreteOrderItem>();
    @OneToMany(mappedBy="bundleOrderItem", targetEntity=BundleOrderItemFeePriceImpl.class, cascade={CascadeType.ALL})
    @Cascade(value={org.hibernate.annotations.CascadeType.ALL, org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
    @Cache(usage=CacheConcurrencyStrategy.NONSTRICT_READ_WRITE, region="blOrderElements")
    protected List<BundleOrderItemFeePrice> bundleOrderItemFeePrices = new ArrayList<BundleOrderItemFeePrice>();
    @Column(name="BASE_RETAIL_PRICE", precision=19, scale=5)
    @AdminPresentation(friendlyName="BundleOrderItemImpl_Base_Retail_Price", order=2, group="BundleOrderItemImpl_Pricing", fieldType=SupportedFieldType.MONEY)
    protected BigDecimal baseRetailPrice;
    @Column(name="BASE_SALE_PRICE", precision=19, scale=5)
    @AdminPresentation(friendlyName="BundleOrderItemImpl_Base_Sale_Price", order=2, group="BundleOrderItemImpl_Pricing", fieldType=SupportedFieldType.MONEY)
    protected BigDecimal baseSalePrice;
    @ManyToOne(targetEntity=SkuImpl.class)
    @JoinColumn(name="SKU_ID")
    @NotFound(action=NotFoundAction.IGNORE)
    protected Sku sku;
    @ManyToOne(targetEntity=ProductBundleImpl.class)
    @JoinColumn(name="PRODUCT_BUNDLE_ID")
    @AdminPresentation(excluded=true)
    protected ProductBundle productBundle;

    @Override
    public Sku getSku() {
        return this.sku;
    }

    @Override
    public void setSku(Sku sku) {
        this.sku = sku;
        if (sku != null) {
            if (sku.getRetailPrice() != null) {
                this.baseRetailPrice = sku.getRetailPrice().getAmount();
            }
            if (sku.getSalePrice() != null) {
                this.baseSalePrice = sku.getSalePrice().getAmount();
            }
            this.itemTaxable = sku.isTaxable();
            this.setName(sku.getName());
        }
    }

    @Override
    public ProductBundle getProductBundle() {
        return this.productBundle;
    }

    @Override
    public void setProductBundle(ProductBundle productBundle) {
        this.productBundle = productBundle;
    }

    @Override
    public List<DiscreteOrderItem> getDiscreteOrderItems() {
        return this.discreteOrderItems;
    }

    @Override
    public void setDiscreteOrderItems(List<DiscreteOrderItem> discreteOrderItems) {
        this.discreteOrderItems = discreteOrderItems;
    }

    @Override
    public List<BundleOrderItemFeePrice> getBundleOrderItemFeePrices() {
        return this.bundleOrderItemFeePrices;
    }

    @Override
    public void setBundleOrderItemFeePrices(List<BundleOrderItemFeePrice> bundleOrderItemFeePrices) {
        this.bundleOrderItemFeePrices = bundleOrderItemFeePrices;
    }

    @Override
    public void removeAllCandidateItemOffers() {
        if (this.shouldSumItems()) {
            for (DiscreteOrderItem discreteOrderItem : this.discreteOrderItems) {
                discreteOrderItem.removeAllCandidateItemOffers();
            }
        } else {
            super.removeAllCandidateItemOffers();
        }
    }

    @Override
    public int removeAllAdjustments() {
        if (this.shouldSumItems()) {
            int removedAdjustmentCount = 0;
            for (DiscreteOrderItem discreteOrderItem : this.discreteOrderItems) {
                removedAdjustmentCount += discreteOrderItem.removeAllAdjustments();
            }
            return removedAdjustmentCount;
        }
        return super.removeAllAdjustments();
    }

    @Override
    public void assignFinalPrice() {
        if (this.shouldSumItems()) {
            for (DiscreteOrderItem discreteOrderItem : this.discreteOrderItems) {
                discreteOrderItem.assignFinalPrice();
            }
        }
        this.price = this.getCurrentPrice().getAmount();
    }

    @Override
    public Money getTaxablePrice() {
        if (this.shouldSumItems()) {
            Money currentBundleTaxablePrice = new Money();
            for (DiscreteOrderItem discreteOrderItem : this.discreteOrderItems) {
                Money currentItemTaxablePrice = discreteOrderItem.getTaxablePrice();
                currentBundleTaxablePrice = currentBundleTaxablePrice.add(new Money(currentItemTaxablePrice.doubleValue() * (double)discreteOrderItem.getQuantity()));
            }
            for (BundleOrderItemFeePrice fee : this.getBundleOrderItemFeePrices()) {
                if (!fee.isTaxable().booleanValue()) continue;
                currentBundleTaxablePrice = currentBundleTaxablePrice.add(fee.getAmount());
            }
            return currentBundleTaxablePrice;
        }
        Money taxablePrice = new Money(0.0);
        if (this.sku != null && this.sku.isTaxable() == null || this.sku.isTaxable().booleanValue()) {
            taxablePrice = this.getPrice();
        }
        return taxablePrice;
    }

    @Override
    public boolean shouldSumItems() {
        if (this.productBundle != null) {
            return ProductBundlePricingModelType.ITEM_SUM.equals(this.productBundle.getPricingModel());
        }
        return true;
    }

    @Override
    public Money getRetailPrice() {
        if (this.shouldSumItems()) {
            Money bundleRetailPrice = new Money();
            for (DiscreteOrderItem discreteOrderItem : this.discreteOrderItems) {
                Money itemRetailPrice = discreteOrderItem.getRetailPrice();
                bundleRetailPrice = bundleRetailPrice.add(new Money(itemRetailPrice.doubleValue() * (double)discreteOrderItem.getQuantity()));
            }
            for (BundleOrderItemFeePrice fee : this.getBundleOrderItemFeePrices()) {
                bundleRetailPrice = bundleRetailPrice.add(fee.getAmount());
            }
            return bundleRetailPrice;
        }
        return super.getRetailPrice();
    }

    @Override
    public Money getSalePrice() {
        if (this.shouldSumItems()) {
            Money bundleSalePrice = null;
            if (this.hasSaleItems()) {
                bundleSalePrice = new Money();
                for (DiscreteOrderItem discreteOrderItem : this.discreteOrderItems) {
                    Money itemSalePrice = null;
                    itemSalePrice = discreteOrderItem.getSalePrice() != null ? discreteOrderItem.getSalePrice() : discreteOrderItem.getRetailPrice();
                    bundleSalePrice = bundleSalePrice.add(new Money(itemSalePrice.doubleValue() * (double)discreteOrderItem.getQuantity()));
                }
                for (BundleOrderItemFeePrice fee : this.getBundleOrderItemFeePrices()) {
                    bundleSalePrice = bundleSalePrice.add(fee.getAmount());
                }
            }
            return bundleSalePrice;
        }
        return super.getSalePrice();
    }

    @Override
    public Money getBaseRetailPrice() {
        return this.baseRetailPrice != null ? new Money(this.baseRetailPrice) : null;
    }

    @Override
    public void setBaseRetailPrice(Money baseRetailPrice) {
        this.baseRetailPrice = baseRetailPrice == null ? null : baseRetailPrice.getAmount();
    }

    @Override
    public Money getBaseSalePrice() {
        return this.baseSalePrice != null ? new Money(this.baseRetailPrice) : null;
    }

    @Override
    public void setBaseSalePrice(Money baseSalePrice) {
        this.baseSalePrice = baseSalePrice == null ? null : baseSalePrice.getAmount();
    }

    private boolean hasSaleItems() {
        for (DiscreteOrderItem discreteOrderItem : this.discreteOrderItems) {
            if (discreteOrderItem.getSalePrice() == null) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean hasAdjustedItems() {
        for (DiscreteOrderItem discreteOrderItem : this.discreteOrderItems) {
            if (!discreteOrderItem.getAdjustmentValue().greaterThan(new Money(0.0))) continue;
            return true;
        }
        return false;
    }

    @Override
    public Money getCurrentPrice() {
        if (this.shouldSumItems()) {
            Money currentBundlePrice = new Money();
            for (DiscreteOrderItem discreteOrderItem : this.discreteOrderItems) {
                Money currentItemPrice = discreteOrderItem.getCurrentPrice();
                currentBundlePrice = currentBundlePrice.add(new Money(currentItemPrice.doubleValue() * (double)discreteOrderItem.getQuantity()));
            }
            return currentBundlePrice;
        }
        return super.getCurrentPrice();
    }

    @Override
    public boolean updatePrices() {
        boolean updated = false;
        if (!this.shouldSumItems()) {
            if (this.getSku() != null && !this.getSku().getRetailPrice().equals((Object)this.getRetailPrice())) {
                this.setBaseRetailPrice(this.getSku().getRetailPrice());
                this.setRetailPrice(this.getSku().getRetailPrice());
                updated = true;
            }
            if (this.getSku() != null && this.getSku().getSalePrice() != null && !this.getSku().getSalePrice().equals((Object)this.getSalePrice())) {
                this.setBaseSalePrice(this.getSku().getSalePrice());
                this.setSalePrice(this.getSku().getSalePrice());
                updated = true;
            }
        }
        return updated;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BundleOrderItemImpl other = (BundleOrderItemImpl)obj;
        if (!super.equals(obj)) {
            return false;
        }
        if (this.id != null && other.id != null) {
            return this.id.equals(other.id);
        }
        return !(this.name == null ? other.name != null : !this.name.equals(other.name));
    }

    @Override
    public Product getProduct() {
        return this.getProductBundle();
    }

    @Override
    public OrderItem clone() {
        BundleOrderItemImpl orderItem = (BundleOrderItemImpl)super.clone();
        if (this.getDiscreteOrderItems() != null) {
            for (DiscreteOrderItem discreteOrderItem : this.getDiscreteOrderItems()) {
                DiscreteOrderItem temp = (DiscreteOrderItem)discreteOrderItem.clone();
                temp.setBundleOrderItem(orderItem);
                orderItem.getDiscreteOrderItems().add(temp);
            }
        }
        if (this.getBundleOrderItemFeePrices() != null) {
            for (BundleOrderItemFeePrice feePrice : this.getBundleOrderItemFeePrices()) {
                BundleOrderItemFeePrice cloneFeePrice = feePrice.clone();
                cloneFeePrice.setBundleOrderItem(orderItem);
                orderItem.getBundleOrderItemFeePrices().add(cloneFeePrice);
            }
        }
        orderItem.setBaseRetailPrice(this.getBaseRetailPrice());
        orderItem.setBaseSalePrice(this.getBaseSalePrice());
        orderItem.setSku(this.sku);
        orderItem.setProductBundle(this.productBundle);
        return orderItem;
    }

    @Override
    public int hashCode() {
        int prime = super.hashCode();
        int result = 1;
        result = prime * result + (this.name == null ? 0 : this.name.hashCode());
        return result;
    }

    @Override
    public void accept(OrderItemVisitor visitor) throws PricingException {
        visitor.visit(this);
    }
}

