/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.core.offer.dao;

import java.util.List;
import javax.annotation.Resource;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;
import org.broadleafcommerce.common.persistence.EntityConfiguration;
import org.broadleafcommerce.common.persistence.Status;
import org.broadleafcommerce.common.time.SystemTime;
import org.broadleafcommerce.core.offer.dao.OfferDao;
import org.broadleafcommerce.core.offer.domain.CandidateFulfillmentGroupOffer;
import org.broadleafcommerce.core.offer.domain.CandidateItemOffer;
import org.broadleafcommerce.core.offer.domain.CandidateOrderOffer;
import org.broadleafcommerce.core.offer.domain.FulfillmentGroupAdjustment;
import org.broadleafcommerce.core.offer.domain.Offer;
import org.broadleafcommerce.core.offer.domain.OfferImpl;
import org.broadleafcommerce.core.offer.domain.OfferInfo;
import org.broadleafcommerce.core.offer.domain.OrderAdjustment;
import org.broadleafcommerce.core.offer.domain.OrderItemAdjustment;
import org.springframework.stereotype.Repository;

@Repository(value="blOfferDao")
public class OfferDaoImpl
implements OfferDao {
    @PersistenceContext(unitName="blPU")
    protected EntityManager em;
    @Resource(name="blEntityConfiguration")
    protected EntityConfiguration entityConfiguration;

    @Override
    public Offer create() {
        return (Offer)this.entityConfiguration.createEntityInstance(Offer.class.getName());
    }

    @Override
    public OfferInfo createOfferInfo() {
        return (OfferInfo)this.entityConfiguration.createEntityInstance(OfferInfo.class.getName());
    }

    @Override
    public CandidateOrderOffer createCandidateOrderOffer() {
        return (CandidateOrderOffer)this.entityConfiguration.createEntityInstance(CandidateOrderOffer.class.getName());
    }

    @Override
    public CandidateItemOffer createCandidateItemOffer() {
        return (CandidateItemOffer)this.entityConfiguration.createEntityInstance(CandidateItemOffer.class.getName());
    }

    @Override
    public CandidateFulfillmentGroupOffer createCandidateFulfillmentGroupOffer() {
        return (CandidateFulfillmentGroupOffer)this.entityConfiguration.createEntityInstance(CandidateFulfillmentGroupOffer.class.getName());
    }

    @Override
    public OrderItemAdjustment createOrderItemAdjustment() {
        return (OrderItemAdjustment)this.entityConfiguration.createEntityInstance(OrderItemAdjustment.class.getName());
    }

    @Override
    public OrderAdjustment createOrderAdjustment() {
        return (OrderAdjustment)this.entityConfiguration.createEntityInstance(OrderAdjustment.class.getName());
    }

    @Override
    public FulfillmentGroupAdjustment createFulfillmentGroupAdjustment() {
        return (FulfillmentGroupAdjustment)this.entityConfiguration.createEntityInstance(FulfillmentGroupAdjustment.class.getName());
    }

    @Override
    public void delete(Offer offer) {
        ((Status)offer).setArchived(Character.valueOf('Y'));
        this.em.merge((Object)offer);
    }

    @Override
    public void delete(OfferInfo offerInfo) {
        if (!this.em.contains((Object)offerInfo)) {
            offerInfo = (OfferInfo)this.em.find(this.entityConfiguration.lookupEntityClass(OfferInfo.class.getName()), (Object)offerInfo.getId());
        }
        this.em.remove((Object)offerInfo);
    }

    @Override
    public Offer save(Offer offer) {
        return (Offer)this.em.merge((Object)offer);
    }

    @Override
    public OfferInfo save(OfferInfo offerInfo) {
        return (OfferInfo)this.em.merge((Object)offerInfo);
    }

    @Override
    public List<Offer> readAllOffers() {
        Query query = this.em.createNamedQuery("BC_READ_ALL_OFFERS");
        return query.getResultList();
    }

    @Override
    public Offer readOfferById(Long offerId) {
        return (Offer)this.em.find(OfferImpl.class, (Object)offerId);
    }

    @Override
    public List<Offer> readOffersByAutomaticDeliveryType() {
        Query query = this.em.createNamedQuery("BC_READ_OFFERS_BY_AUTOMATIC_DELIVERY_TYPE");
        query.setParameter("specifiedDate", (Object)SystemTime.asDate());
        List result = query.getResultList();
        return result;
    }
}

