/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.core.catalog.domain;

import java.io.Serializable;
import javax.persistence.Column;
import javax.persistence.EmbeddedId;
import javax.persistence.Entity;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import org.broadleafcommerce.core.catalog.domain.Category;
import org.broadleafcommerce.core.catalog.domain.CategoryImpl;
import org.broadleafcommerce.core.catalog.domain.CategoryProductXref;
import org.broadleafcommerce.core.catalog.domain.Product;
import org.broadleafcommerce.core.catalog.domain.ProductImpl;

@Entity
@Inheritance(strategy=InheritanceType.JOINED)
@Table(name="BLC_CATEGORY_PRODUCT_XREF")
public class CategoryProductXrefImpl
implements CategoryProductXref {
    private static final long serialVersionUID = 1L;
    @EmbeddedId
    CategoryProductXrefPk categoryProductXref = new CategoryProductXrefPk();
    @Column(name="DISPLAY_ORDER")
    protected Long displayOrder;

    public CategoryProductXrefPk getCategoryProductXref() {
        return this.categoryProductXref;
    }

    public void setCategoryProductXref(CategoryProductXrefPk categoryProductXref) {
        this.categoryProductXref = categoryProductXref;
    }

    @Override
    public Long getDisplayOrder() {
        return this.displayOrder;
    }

    @Override
    public void setDisplayOrder(Long displayOrder) {
        this.displayOrder = displayOrder;
    }

    @Override
    public Category getCategory() {
        return this.categoryProductXref.getCategory();
    }

    @Override
    public void setCategory(Category category) {
        this.categoryProductXref.setCategory(category);
    }

    @Override
    public Product getProduct() {
        return this.categoryProductXref.getProduct();
    }

    @Override
    public void setProduct(Product product) {
        this.categoryProductXref.setProduct(product);
    }

    public static class CategoryProductXrefPk
    implements Serializable {
        private static final long serialVersionUID = 1L;
        @ManyToOne(targetEntity=CategoryImpl.class, optional=false)
        @JoinColumn(name="CATEGORY_ID")
        protected Category category = new CategoryImpl();
        @ManyToOne(targetEntity=ProductImpl.class, optional=false)
        @JoinColumn(name="PRODUCT_ID")
        protected Product product = new ProductImpl();

        public Category getCategory() {
            return this.category;
        }

        public void setCategory(Category category) {
            this.category = category;
        }

        public Product getProduct() {
            return this.product;
        }

        public void setProduct(Product product) {
            this.product = product;
        }

        public int hashCode() {
            return this.category.hashCode() + this.product.hashCode();
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof CategoryProductXrefPk)) {
                return false;
            }
            return this.category.getId().equals(((CategoryProductXrefPk)obj).category.getId()) && this.product.getId().equals(((CategoryProductXrefPk)obj).product.getId());
        }
    }
}

