/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.core.search.service.solr;

import java.io.IOException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import javax.annotation.Resource;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.solr.client.solrj.SolrQuery;
import org.apache.solr.client.solrj.SolrServer;
import org.apache.solr.client.solrj.SolrServerException;
import org.apache.solr.client.solrj.embedded.EmbeddedSolrServer;
import org.apache.solr.client.solrj.response.FacetField;
import org.apache.solr.client.solrj.response.QueryResponse;
import org.apache.solr.common.SolrDocument;
import org.apache.solr.common.SolrDocumentList;
import org.apache.solr.common.SolrInputDocument;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.core.CoreContainer;
import org.broadleafcommerce.common.exception.ServiceException;
import org.broadleafcommerce.common.time.SystemTime;
import org.broadleafcommerce.core.catalog.dao.ProductDao;
import org.broadleafcommerce.core.catalog.domain.Category;
import org.broadleafcommerce.core.catalog.domain.Product;
import org.broadleafcommerce.core.search.dao.FieldDao;
import org.broadleafcommerce.core.search.dao.SearchFacetDao;
import org.broadleafcommerce.core.search.domain.CategorySearchFacet;
import org.broadleafcommerce.core.search.domain.Field;
import org.broadleafcommerce.core.search.domain.ProductSearchCriteria;
import org.broadleafcommerce.core.search.domain.ProductSearchResult;
import org.broadleafcommerce.core.search.domain.SearchFacet;
import org.broadleafcommerce.core.search.domain.SearchFacetDTO;
import org.broadleafcommerce.core.search.domain.SearchFacetRange;
import org.broadleafcommerce.core.search.domain.SearchFacetResultDTO;
import org.broadleafcommerce.core.search.domain.solr.FieldType;
import org.broadleafcommerce.core.search.service.SearchService;
import org.broadleafcommerce.core.util.StopWatch;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.transaction.annotation.Transactional;
import org.xml.sax.SAXException;

public class SolrSearchServiceImpl
implements SearchService,
DisposableBean {
    private static final Log LOG = LogFactory.getLog(SolrSearchServiceImpl.class);
    protected static final String GLOBAL_FACET_TAG_FIELD = "a";
    @Resource(name="blProductDao")
    protected ProductDao productDao;
    @Resource(name="blFieldDao")
    protected FieldDao fieldDao;
    @Resource(name="blSearchFacetDao")
    protected SearchFacetDao searchFacetDao;
    protected SolrServer server;

    public SolrSearchServiceImpl(String solrServer) throws IOException, ParserConfigurationException, SAXException {
        System.setProperty("solr.solr.home", solrServer);
        CoreContainer.Initializer initializer = new CoreContainer.Initializer();
        CoreContainer coreContainer = initializer.initialize();
        EmbeddedSolrServer server = new EmbeddedSolrServer(coreContainer, "");
        this.server = server;
    }

    public SolrSearchServiceImpl(SolrServer solrServer) {
        this.server = solrServer;
    }

    public void destroy() throws Exception {
        if (this.server instanceof EmbeddedSolrServer) {
            ((EmbeddedSolrServer)this.server).shutdown();
        }
    }

    @Override
    @Transactional(value="blTransactionManager")
    public void rebuildIndex() throws ServiceException, IOException {
        LOG.info((Object)"Rebuilding the solr index...");
        StopWatch s = new StopWatch();
        List<Product> products = this.productDao.readAllActiveProducts(SystemTime.asDate());
        List<Field> fields = this.fieldDao.readAllProductFields();
        ArrayList<SolrInputDocument> documents = new ArrayList<SolrInputDocument>();
        for (Product product : products) {
            SolrInputDocument document = new SolrInputDocument();
            document.addField("id", (Object)product.getId());
            for (Category category : product.getAllParentCategories()) {
                document.addField("explicitCategory", (Object)category.getId());
                String categorySortField = this.getCategorySortField(category);
                int listIndex = category.getAllProducts().indexOf(product);
                document.addField(categorySortField, (Object)listIndex);
            }
            TreeSet<Category> fullCategoryHierarchy = new TreeSet<Category>(new Comparator<Category>(){

                @Override
                public int compare(Category o1, Category o2) {
                    if (o1.equals(o2)) {
                        return 0;
                    }
                    return 1;
                }
            });
            for (Category category : product.getAllParentCategories()) {
                fullCategoryHierarchy.addAll(category.buildFullCategoryHierarchy(null));
            }
            for (Category category : fullCategoryHierarchy) {
                document.addField("category", (Object)category.getId());
            }
            ArrayList<String> addedProperties = new ArrayList<String>();
            ArrayList<String> copyFieldValue = new ArrayList<String>();
            for (Field field : fields) {
                try {
                    String solrFacetPropertyName;
                    String propertyName = field.getPropertyName();
                    if (propertyName.contains("productAttributes.")) {
                        propertyName = this.convertToMappedProperty(propertyName, "productAttributes", "mappedProductAttributes");
                    }
                    Object propertyValue = PropertyUtils.getProperty((Object)product, (String)propertyName);
                    for (FieldType searchableFieldType : field.getSearchableFieldTypes()) {
                        String solrPropertyName = field.getPropertyName() + "_" + searchableFieldType.getType();
                        document.addField(solrPropertyName, propertyValue);
                        addedProperties.add(solrPropertyName);
                        copyFieldValue.add(propertyValue.toString());
                    }
                    FieldType facetFieldType = field.getFacetFieldType();
                    if (facetFieldType == null || addedProperties.contains(solrFacetPropertyName = field.getPropertyName() + "_" + facetFieldType.getType())) continue;
                    document.addField(solrFacetPropertyName, propertyValue);
                }
                catch (Exception e) {
                    LOG.debug((Object)("Could not get value for property[" + field.getQualifiedFieldName() + "] for product id[" + product.getId() + "]"));
                }
            }
            document.addField("searchable", (Object)StringUtils.join(copyFieldValue, (String)" "));
            documents.add(document);
        }
        if (LOG.isTraceEnabled()) {
            for (SolrInputDocument document : documents) {
                LOG.trace((Object)document);
            }
        }
        try {
            this.server.deleteByQuery("*:*");
            this.server.commit();
            this.server.add(documents);
            this.server.commit();
        }
        catch (SolrServerException e) {
            throw new ServiceException("Could not rebuild index", (Throwable)e);
        }
        LOG.info((Object)("Finished rebuilding the solr index in " + s.toLapString()));
    }

    @Override
    public ProductSearchResult findExplicitProductsByCategory(Category category, ProductSearchCriteria searchCriteria) throws ServiceException {
        List<SearchFacetDTO> facets = this.getCategoryFacets(category);
        String query = "explicitCategory:" + category.getId();
        return this.findProducts(query, facets, searchCriteria, this.getCategorySortField(category) + " asc");
    }

    @Override
    public ProductSearchResult findProductsByCategory(Category category, ProductSearchCriteria searchCriteria) throws ServiceException {
        List<SearchFacetDTO> facets = this.getCategoryFacets(category);
        String query = "category:" + category.getId();
        return this.findProducts(query, facets, searchCriteria, this.getCategorySortField(category) + " asc");
    }

    @Override
    public ProductSearchResult findProductsByQuery(String query, ProductSearchCriteria searchCriteria) throws ServiceException {
        List<SearchFacetDTO> facets = this.getSearchFacets();
        query = "searchable:*" + query + "*";
        return this.findProducts(query, facets, searchCriteria, null);
    }

    @Override
    public ProductSearchResult findProductsByCategoryAndQuery(Category category, String query, ProductSearchCriteria searchCriteria) throws ServiceException {
        List<SearchFacetDTO> facets = this.getSearchFacets();
        StringBuilder sb = new StringBuilder();
        sb.append("category:").append(category.getId()).append(" AND ").append("searchable:*").append(query).append("*");
        return this.findProducts(sb.toString(), facets, searchCriteria, null);
    }

    @Override
    public List<SearchFacetDTO> getSearchFacets() {
        return this.buildSearchFacetDTOs(this.searchFacetDao.readAllSearchFacets());
    }

    @Override
    public List<SearchFacetDTO> getCategoryFacets(Category category) {
        List<CategorySearchFacet> categorySearchFacets = category.getCumulativeSearchFacets();
        ArrayList<SearchFacet> searchFacets = new ArrayList<SearchFacet>();
        for (CategorySearchFacet categorySearchFacet : categorySearchFacets) {
            searchFacets.add(categorySearchFacet.getSearchFacet());
        }
        return this.buildSearchFacetDTOs(searchFacets);
    }

    protected ProductSearchResult findProducts(String qualifiedSolrQuery, List<SearchFacetDTO> facets, ProductSearchCriteria searchCriteria, String defaultSort) throws ServiceException {
        QueryResponse response;
        Map<String, SearchFacetDTO> namedFacetMap = this.getNamedFacetMap(facets, searchCriteria);
        SolrQuery solrQuery = new SolrQuery().setQuery(qualifiedSolrQuery).setFields(new String[]{"id"}).setRows(searchCriteria.getPageSize()).setStart(Integer.valueOf((searchCriteria.getPage() - 1) * searchCriteria.getPageSize()));
        this.attachSortClause(solrQuery, searchCriteria, defaultSort);
        this.attachActiveFacetFilters(solrQuery, namedFacetMap, searchCriteria);
        this.attachFacets(solrQuery, namedFacetMap);
        try {
            response = this.server.query((SolrParams)solrQuery);
        }
        catch (SolrServerException e) {
            throw new ServiceException("Could not perform search", (Throwable)e);
        }
        this.setFacetResults(namedFacetMap, response);
        this.sortFacetResults(namedFacetMap);
        List<Product> products = this.getProducts(response);
        ProductSearchResult result = new ProductSearchResult();
        result.setFacets(facets);
        result.setProducts(products);
        this.setPagingAttributes(result, response, searchCriteria);
        return result;
    }

    protected void attachSortClause(SolrQuery query, ProductSearchCriteria searchCriteria, String defaultSort) {
        Map<String, String> solrFieldKeyMap = this.getSolrFieldKeyMap(searchCriteria);
        String sortQuery = searchCriteria.getSortQuery();
        if (StringUtils.isBlank((String)sortQuery)) {
            sortQuery = defaultSort;
        }
        if (StringUtils.isNotBlank((String)sortQuery)) {
            String[] sortFields;
            for (String sortField : sortFields = sortQuery.split(",")) {
                SolrQuery.ORDER order;
                String field = sortField.split(" ")[0];
                if (solrFieldKeyMap.containsKey(field)) {
                    field = solrFieldKeyMap.get(field);
                }
                SolrQuery.ORDER oRDER = order = "desc".equals(sortField.split(" ")[1]) ? SolrQuery.ORDER.desc : SolrQuery.ORDER.asc;
                if (field == null) continue;
                query.addSortField(field, order);
            }
        }
    }

    protected void attachActiveFacetFilters(SolrQuery query, Map<String, SearchFacetDTO> namedFacetMap, ProductSearchCriteria searchCriteria) {
        for (Map.Entry<String, String[]> entry : searchCriteria.getFilterCriteria().entrySet()) {
            String solrKey = null;
            for (Map.Entry<String, SearchFacetDTO> dtoEntry : namedFacetMap.entrySet()) {
                if (!dtoEntry.getValue().getFacet().getField().getAbbreviation().equals(entry.getKey())) continue;
                solrKey = dtoEntry.getKey();
                dtoEntry.getValue().setActive(true);
            }
            if (solrKey == null) continue;
            String solrTag = this.getSolrFieldTag(GLOBAL_FACET_TAG_FIELD, "tag");
            Object[] selectedValues = (String[])entry.getValue().clone();
            for (int i = 0; i < selectedValues.length; ++i) {
                if (selectedValues[i].contains("range[")) {
                    String rangeValue = ((String)selectedValues[i]).substring(((String)selectedValues[i]).indexOf(91) + 1, ((String)selectedValues[i]).indexOf(93));
                    String[] rangeValues = StringUtils.split((String)rangeValue, (char)':');
                    if (rangeValues[1].equals("null")) {
                        rangeValues[1] = "*";
                    }
                    selectedValues[i] = solrKey + ":[" + rangeValues[0] + " TO " + rangeValues[1] + "]";
                    continue;
                }
                selectedValues[i] = solrKey + ":\"" + (String)selectedValues[i] + "\"";
            }
            String valueString = StringUtils.join((Object[])selectedValues, (String)" OR ");
            StringBuilder sb = new StringBuilder();
            sb.append(solrTag).append("(").append(valueString).append(")");
            query.addFilterQuery(new String[]{sb.toString()});
        }
    }

    protected void attachFacets(SolrQuery query, Map<String, SearchFacetDTO> namedFacetMap) {
        query.setFacet(true);
        for (Map.Entry<String, SearchFacetDTO> entry : namedFacetMap.entrySet()) {
            String facetTagField;
            SearchFacetDTO dto = entry.getValue();
            String string = facetTagField = entry.getValue().isActive() ? GLOBAL_FACET_TAG_FIELD : entry.getKey();
            if (dto.getFacet().getSearchFacetRanges().size() > 0) {
                for (SearchFacetRange range : dto.getFacet().getSearchFacetRanges()) {
                    query.addFacetQuery(this.getSolrTaggedFieldString(entry.getKey(), facetTagField, "ex", range));
                }
                continue;
            }
            query.addFacetField(new String[]{this.getSolrTaggedFieldString(entry.getKey(), facetTagField, "ex", null)});
        }
    }

    protected void setFacetResults(Map<String, SearchFacetDTO> namedFacetMap, QueryResponse response) {
        if (response.getFacetFields() != null) {
            for (FacetField facetField : response.getFacetFields()) {
                String facetFieldName = facetField.getName();
                SearchFacetDTO facetDTO = namedFacetMap.get(facetFieldName);
                for (FacetField.Count value : facetField.getValues()) {
                    SearchFacetResultDTO resultDTO = new SearchFacetResultDTO();
                    resultDTO.setFacet(facetDTO.getFacet());
                    resultDTO.setQuantity(new Long(value.getCount()).intValue());
                    resultDTO.setValue(value.getName());
                    facetDTO.getFacetValues().add(resultDTO);
                }
            }
        }
        if (response.getFacetQuery() != null) {
            for (Map.Entry entry : response.getFacetQuery().entrySet()) {
                String key = (String)entry.getKey();
                String facetFieldName = key.substring(key.indexOf("}") + 1, key.indexOf(58));
                SearchFacetDTO facetDTO = namedFacetMap.get(facetFieldName);
                String minValue = key.substring(key.indexOf("[") + 1, key.indexOf(" TO"));
                String maxValue = key.substring(key.indexOf(" TO ") + 4, key.indexOf("]"));
                if (maxValue.equals("*")) {
                    maxValue = null;
                }
                SearchFacetResultDTO resultDTO = new SearchFacetResultDTO();
                resultDTO.setFacet(facetDTO.getFacet());
                resultDTO.setQuantity((Integer)entry.getValue());
                resultDTO.setMinValue(new BigDecimal(minValue));
                resultDTO.setMaxValue(maxValue == null ? null : new BigDecimal(maxValue));
                facetDTO.getFacetValues().add(resultDTO);
            }
        }
    }

    protected void sortFacetResults(Map<String, SearchFacetDTO> namedFacetMap) {
        for (Map.Entry<String, SearchFacetDTO> entry : namedFacetMap.entrySet()) {
            Collections.sort(entry.getValue().getFacetValues(), new Comparator<SearchFacetResultDTO>(){

                @Override
                public int compare(SearchFacetResultDTO o1, SearchFacetResultDTO o2) {
                    if (o1.getValue() != null && o2.getValue() != null) {
                        return o1.getValue().compareTo(o2.getValue());
                    }
                    if (o1.getMinValue() != null && o2.getMinValue() != null) {
                        return o1.getMinValue().compareTo(o2.getMinValue());
                    }
                    return 0;
                }
            });
        }
    }

    public void setPagingAttributes(ProductSearchResult result, QueryResponse response, ProductSearchCriteria searchCriteria) {
        result.setTotalResults(new Long(response.getResults().getNumFound()).intValue());
        result.setPage(searchCriteria.getPage());
        result.setPageSize(searchCriteria.getPageSize());
    }

    protected List<Product> getProducts(QueryResponse response) {
        final ArrayList<Long> productIds = new ArrayList<Long>();
        SolrDocumentList docs = response.getResults();
        for (SolrDocument doc : docs) {
            productIds.add((Long)doc.getFieldValue("id"));
        }
        List<Product> products = this.productDao.readProductsByIds(productIds);
        if (products != null) {
            Collections.sort(products, new Comparator<Product>(){

                @Override
                public int compare(Product o1, Product o2) {
                    return new Integer(productIds.indexOf(o1.getId())).compareTo(productIds.indexOf(o2.getId()));
                }
            });
        }
        return products;
    }

    protected String getSolrTaggedFieldString(String indexField, String tagField, String tag, SearchFacetRange range) {
        return this.getSolrFieldTag(tagField, tag) + this.getSolrFieldString(indexField, range);
    }

    protected String getSolrFieldTag(String tagField, String tag) {
        StringBuilder sb = new StringBuilder();
        if (StringUtils.isNotBlank((String)tag)) {
            sb.append("{!").append(tag).append("=").append(tagField).append("}");
        }
        return sb.toString();
    }

    protected String getSolrFieldString(String indexField, SearchFacetRange range) {
        StringBuilder sb = new StringBuilder();
        sb.append(indexField);
        if (range != null) {
            String minValue = range.getMinValue().toPlainString();
            String maxValue = range.getMaxValue() == null ? "*" : range.getMaxValue().toPlainString();
            sb.append(":[").append(minValue).append(" TO ").append(maxValue).append("]");
        }
        return sb.toString();
    }

    protected String getCategorySortField(Category category) {
        return "category_" + category.getId() + "_sort_i";
    }

    protected List<SearchFacetDTO> buildSearchFacetDTOs(List<SearchFacet> searchFacets) {
        ArrayList<SearchFacetDTO> facets = new ArrayList<SearchFacetDTO>();
        for (SearchFacet facet : searchFacets) {
            SearchFacetDTO dto = new SearchFacetDTO();
            dto.setFacet(facet);
            dto.setShowQuantity(true);
            facets.add(dto);
        }
        return facets;
    }

    protected String convertToMappedProperty(String propertyName, String listPropertyName, String mapPropertyName) {
        String[] splitName = StringUtils.split((String)propertyName, (String)".");
        StringBuilder convertedProperty = new StringBuilder();
        for (int i = 0; i < splitName.length; ++i) {
            if (convertedProperty.length() > 0) {
                convertedProperty.append(".");
            }
            if (splitName[i].equals(listPropertyName)) {
                convertedProperty.append(mapPropertyName).append("(");
                convertedProperty.append(splitName[i + 1]).append(").value");
                ++i;
                continue;
            }
            convertedProperty.append(splitName[i]);
        }
        return convertedProperty.toString();
    }

    protected String getSolrFieldKey(Field field, ProductSearchCriteria searchCriteria) {
        if (field.getFacetFieldType() != null) {
            return field.getPropertyName() + "_" + field.getFacetFieldType().getType();
        }
        return null;
    }

    protected Map<String, String> getSolrFieldKeyMap(ProductSearchCriteria searchCriteria) {
        List<Field> fields = this.fieldDao.readAllProductFields();
        HashMap<String, String> solrFieldKeyMap = new HashMap<String, String>();
        for (Field field : fields) {
            solrFieldKeyMap.put(field.getAbbreviation(), this.getSolrFieldKey(field, searchCriteria));
        }
        return solrFieldKeyMap;
    }

    protected Map<String, SearchFacetDTO> getNamedFacetMap(List<SearchFacetDTO> facets, ProductSearchCriteria searchCriteria) {
        HashMap<String, SearchFacetDTO> namedFacetMap = new HashMap<String, SearchFacetDTO>();
        for (SearchFacetDTO facet : facets) {
            Field facetField = facet.getFacet().getField();
            namedFacetMap.put(this.getSolrFieldKey(facetField, searchCriteria), facet);
        }
        return namedFacetMap;
    }
}

