/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.core.pricing.service;

import java.util.HashMap;
import java.util.List;
import java.util.Set;
import javax.annotation.Resource;
import org.broadleafcommerce.common.money.Money;
import org.broadleafcommerce.common.vendor.service.exception.FulfillmentPriceException;
import org.broadleafcommerce.core.order.domain.FulfillmentGroup;
import org.broadleafcommerce.core.order.domain.FulfillmentOption;
import org.broadleafcommerce.core.order.service.FulfillmentGroupService;
import org.broadleafcommerce.core.pricing.service.FulfillmentPricingService;
import org.broadleafcommerce.core.pricing.service.fulfillment.provider.FulfillmentEstimationResponse;
import org.broadleafcommerce.core.pricing.service.fulfillment.provider.FulfillmentPricingProvider;
import org.springframework.stereotype.Service;

@Service(value="blFulfillmentPricingService")
public class FulfillmentPricingServiceImpl
implements FulfillmentPricingService {
    @Resource(name="blFulfillmentPricingProviders")
    protected List<FulfillmentPricingProvider> providers;
    @Resource(name="blFulfillmentGroupService")
    protected FulfillmentGroupService fulfillmentGroupService;

    @Override
    public FulfillmentGroup calculateCostForFulfillmentGroup(FulfillmentGroup fulfillmentGroup) throws FulfillmentPriceException {
        if (fulfillmentGroup.getFulfillmentOption() == null) {
            fulfillmentGroup.setRetailShippingPrice(Money.ZERO);
            fulfillmentGroup.setShippingPrice(Money.ZERO);
            fulfillmentGroup.setSaleShippingPrice(Money.ZERO);
            return fulfillmentGroup;
        }
        for (FulfillmentPricingProvider processor : this.providers) {
            if (!processor.canCalculateCostForFulfillmentGroup(fulfillmentGroup, fulfillmentGroup.getFulfillmentOption())) continue;
            return processor.calculateCostForFulfillmentGroup(fulfillmentGroup);
        }
        throw new FulfillmentPriceException("No valid processor was found to calculate the FulfillmentGroup cost with FulfillmentOption id: " + fulfillmentGroup.getFulfillmentOption().getId() + " and name: " + fulfillmentGroup.getFulfillmentOption().getName());
    }

    @Override
    public FulfillmentEstimationResponse estimateCostForFulfillmentGroup(FulfillmentGroup fulfillmentGroup, Set<FulfillmentOption> options) throws FulfillmentPriceException {
        FulfillmentEstimationResponse response = new FulfillmentEstimationResponse();
        HashMap<? extends FulfillmentOption, Money> prices = new HashMap<FulfillmentOption, Money>();
        response.setFulfillmentOptionPrices(prices);
        for (FulfillmentPricingProvider processor : this.providers) {
            FulfillmentEstimationResponse processorResponse = processor.estimateCostForFulfillmentGroup(fulfillmentGroup, options);
            if (processorResponse == null || processorResponse.getFulfillmentOptionPrices() == null || processorResponse.getFulfillmentOptionPrices().size() <= 0) continue;
            prices.putAll(processorResponse.getFulfillmentOptionPrices());
        }
        return response;
    }

    @Override
    public List<FulfillmentPricingProvider> getProviders() {
        return this.providers;
    }

    public void setProviders(List<FulfillmentPricingProvider> providers) {
        this.providers = providers;
    }
}

