/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.core.payment.domain;

import java.math.BigDecimal;
import java.util.Date;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.persistence.TableGenerator;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import org.broadleafcommerce.common.money.Money;
import org.broadleafcommerce.common.presentation.AdminPresentation;
import org.broadleafcommerce.core.payment.domain.PaymentLog;
import org.broadleafcommerce.core.payment.service.type.PaymentLogEventType;
import org.broadleafcommerce.core.payment.service.type.TransactionType;
import org.broadleafcommerce.profile.core.domain.Customer;
import org.broadleafcommerce.profile.core.domain.CustomerImpl;
import org.hibernate.annotations.Index;

@Entity
@Inheritance(strategy=InheritanceType.JOINED)
@Table(name="BLC_PAYMENT_LOG")
public class PaymentLogImpl
implements PaymentLog {
    private static final long serialVersionUID = 1L;
    @Id
    @GeneratedValue(generator="PaymentLogId", strategy=GenerationType.TABLE)
    @TableGenerator(name="PaymentLogId", table="SEQUENCE_GENERATOR", pkColumnName="ID_NAME", valueColumnName="ID_VAL", pkColumnValue="PaymentLogImpl", allocationSize=50)
    @Column(name="PAYMENT_LOG_ID")
    protected Long id;
    @Column(name="USER_NAME", nullable=false)
    @Index(name="PAYMENTLOG_USER_INDEX", columnNames={"USER_NAME"})
    @AdminPresentation(friendlyName="PaymentLogImpl_User_Name", order=1, group="PaymentLogImpl_Payment_Log", readOnly=true)
    protected String userName;
    @Column(name="TRANSACTION_TIMESTAMP", nullable=false)
    @Temporal(value=TemporalType.TIMESTAMP)
    @AdminPresentation(friendlyName="PaymentLogImpl_Transaction_Time", order=3, group="PaymentLogImpl_Payment_Log", readOnly=true)
    protected Date transactionTimestamp;
    @Column(name="ORDER_PAYMENT_ID")
    @Index(name="PAYMENTLOG_ORDERPAYMENT_INDEX", columnNames={"ORDER_PAYMENT_ID"})
    @AdminPresentation(excluded=true, readOnly=true)
    protected Long paymentInfoId;
    @ManyToOne(targetEntity=CustomerImpl.class)
    @JoinColumn(name="CUSTOMER_ID")
    @Index(name="PAYMENTLOG_CUSTOMER_INDEX", columnNames={"CUSTOMER_ID"})
    protected Customer customer;
    @Column(name="PAYMENT_INFO_REFERENCE_NUMBER")
    @Index(name="PAYMENTLOG_REFERENCE_INDEX", columnNames={"PAYMENT_INFO_REFERENCE_NUMBER"})
    @AdminPresentation(friendlyName="PaymentLogImpl_Payment_Ref_Number", order=4, group="PaymentLogImpl_Payment_Log", readOnly=true)
    protected String paymentInfoReferenceNumber;
    @Column(name="TRANSACTION_TYPE", nullable=false)
    @Index(name="PAYMENTLOG_TRANTYPE_INDEX", columnNames={"TRANSACTION_TYPE"})
    @AdminPresentation(friendlyName="PaymentLogImpl_Transaction_Type", order=5, group="PaymentLogImpl_Payment_Log", readOnly=true)
    protected String transactionType;
    @Column(name="TRANSACTION_SUCCESS")
    @AdminPresentation(friendlyName="PaymentLogImpl_Transaction_Successfule", order=6, group="PaymentLogImpl_Payment_Log", readOnly=true)
    protected Boolean transactionSuccess;
    @Column(name="EXCEPTION_MESSAGE")
    @AdminPresentation(friendlyName="PaymentLogImpl_Exception_Message", order=7, group="PaymentLogImpl_Payment_Log", readOnly=true)
    protected String exceptionMessage;
    @Column(name="LOG_TYPE", nullable=false)
    @Index(name="PAYMENTLOG_LOGTYPE_INDEX", columnNames={"LOG_TYPE"})
    @AdminPresentation(friendlyName="PaymentLogImpl_Type", order=8, group="PaymentLogImpl_Payment_Log", readOnly=true)
    protected String logType;
    @Column(name="AMOUNT_PAID", precision=19, scale=5)
    @AdminPresentation(friendlyName="PaymentLogImpl_Amount", order=2, group="PaymentLogImpl_Payment_Log", readOnly=true)
    protected BigDecimal amountPaid;

    @Override
    public Long getId() {
        return this.id;
    }

    @Override
    public void setId(Long id) {
        this.id = id;
    }

    @Override
    public String getUserName() {
        return this.userName;
    }

    @Override
    public void setUserName(String userName) {
        this.userName = userName;
    }

    @Override
    public Date getTransactionTimestamp() {
        return this.transactionTimestamp;
    }

    @Override
    public void setTransactionTimestamp(Date transactionTimestamp) {
        this.transactionTimestamp = transactionTimestamp;
    }

    @Override
    public Long getPaymentInfoId() {
        return this.paymentInfoId;
    }

    @Override
    public void setPaymentInfoId(Long paymentInfoId) {
        this.paymentInfoId = paymentInfoId;
    }

    @Override
    public Customer getCustomer() {
        return this.customer;
    }

    @Override
    public void setCustomer(Customer customer) {
        this.customer = customer;
    }

    @Override
    public String getPaymentInfoReferenceNumber() {
        return this.paymentInfoReferenceNumber;
    }

    @Override
    public void setPaymentInfoReferenceNumber(String paymentInfoReferenceNumber) {
        this.paymentInfoReferenceNumber = paymentInfoReferenceNumber;
    }

    @Override
    public TransactionType getTransactionType() {
        return TransactionType.getInstance(this.transactionType);
    }

    @Override
    public void setTransactionType(TransactionType transactionType) {
        this.transactionType = transactionType.getType();
    }

    @Override
    public PaymentLogEventType getLogType() {
        return PaymentLogEventType.getInstance(this.logType);
    }

    @Override
    public void setLogType(PaymentLogEventType logType) {
        this.logType = logType.getType();
    }

    @Override
    public Boolean getTransactionSuccess() {
        return this.transactionSuccess;
    }

    @Override
    public void setTransactionSuccess(Boolean transactionSuccess) {
        this.transactionSuccess = transactionSuccess;
    }

    @Override
    public String getExceptionMessage() {
        return this.exceptionMessage;
    }

    @Override
    public void setExceptionMessage(String exceptionMessage) {
        this.exceptionMessage = exceptionMessage;
    }

    @Override
    public Money getAmountPaid() {
        return new Money(this.amountPaid);
    }

    @Override
    public void setAmountPaid(Money amountPaid) {
        this.amountPaid = Money.toAmount((Money)amountPaid);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.customer == null ? 0 : this.customer.hashCode());
        result = 31 * result + (this.paymentInfoId == null ? 0 : this.paymentInfoId.hashCode());
        result = 31 * result + (this.paymentInfoReferenceNumber == null ? 0 : this.paymentInfoReferenceNumber.hashCode());
        result = 31 * result + (this.transactionTimestamp == null ? 0 : this.transactionTimestamp.hashCode());
        result = 31 * result + (this.userName == null ? 0 : this.userName.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PaymentLogImpl other = (PaymentLogImpl)obj;
        if (this.id != null && other.id != null) {
            return this.id.equals(other.id);
        }
        if (this.customer == null ? other.customer != null : !this.customer.equals(other.customer)) {
            return false;
        }
        if (this.paymentInfoId == null ? other.paymentInfoId != null : !this.paymentInfoId.equals(other.paymentInfoId)) {
            return false;
        }
        if (this.paymentInfoReferenceNumber == null ? other.paymentInfoReferenceNumber != null : !this.paymentInfoReferenceNumber.equals(other.paymentInfoReferenceNumber)) {
            return false;
        }
        if (this.transactionTimestamp == null ? other.transactionTimestamp != null : !this.transactionTimestamp.equals(other.transactionTimestamp)) {
            return false;
        }
        return !(this.userName == null ? other.userName != null : !this.userName.equals(other.userName));
    }
}

