/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.core.order.service.workflow.update;

import java.util.HashMap;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.broadleafcommerce.core.catalog.domain.Sku;
import org.broadleafcommerce.core.offer.service.OrderItemMergeService;
import org.broadleafcommerce.core.order.domain.BundleOrderItem;
import org.broadleafcommerce.core.order.domain.DiscreteOrderItem;
import org.broadleafcommerce.core.order.domain.Order;
import org.broadleafcommerce.core.order.domain.OrderItem;
import org.broadleafcommerce.core.order.service.OrderService;
import org.broadleafcommerce.core.order.service.call.OrderItemRequestDTO;
import org.broadleafcommerce.core.order.service.exception.ItemNotFoundException;
import org.broadleafcommerce.core.order.service.workflow.CartOperationContext;
import org.broadleafcommerce.core.order.service.workflow.CartOperationRequest;
import org.broadleafcommerce.core.workflow.BaseActivity;
import org.broadleafcommerce.core.workflow.ProcessContext;

public class UpdateOrderItemActivity
extends BaseActivity {
    private static Log LOG = LogFactory.getLog(UpdateOrderItemActivity.class);
    @Resource(name="blOrderService")
    protected OrderService orderService;
    @Resource(name="blOrderItemMergeService")
    protected OrderItemMergeService orderItemMergeService;

    @Override
    public ProcessContext execute(ProcessContext context) throws Exception {
        CartOperationRequest request = ((CartOperationContext)context).getSeedData();
        OrderItemRequestDTO orderItemRequestDTO = request.getItemRequest();
        Order order = request.getOrder();
        this.orderItemMergeService.gatherSplitItemsInBundles(order);
        OrderItem orderItem = null;
        for (OrderItem oi : order.getOrderItems()) {
            if (!oi.getId().equals(orderItemRequestDTO.getOrderItemId())) continue;
            orderItem = oi;
        }
        if (orderItem == null || !order.getOrderItems().contains(orderItem)) {
            throw new ItemNotFoundException("Order Item (" + orderItem.getId() + ") not found in Order (" + order.getId() + ")");
        }
        OrderItem itemFromOrder = order.getOrderItems().get(order.getOrderItems().indexOf(orderItem));
        request.setOrderItemQuantityDelta(orderItemRequestDTO.getQuantity() - itemFromOrder.getQuantity());
        Integer oldQuantity = itemFromOrder.getQuantity();
        itemFromOrder.setQuantity(orderItemRequestDTO.getQuantity());
        if (itemFromOrder instanceof BundleOrderItem) {
            HashMap<Sku, Integer> libraryQty = new HashMap<Sku, Integer>();
            for (DiscreteOrderItem discreteOrderItem : ((BundleOrderItem)itemFromOrder).getDiscreteOrderItems()) {
                if (!libraryQty.containsKey(discreteOrderItem.getSku())) {
                    libraryQty.put(discreteOrderItem.getSku(), 0);
                }
                libraryQty.put(discreteOrderItem.getSku(), (Integer)libraryQty.get(discreteOrderItem.getSku()) + discreteOrderItem.getQuantity());
            }
            for (Map.Entry entry : libraryQty.entrySet()) {
                entry.setValue((Integer)entry.getValue() / oldQuantity * orderItemRequestDTO.getQuantity());
            }
            for (DiscreteOrderItem discreteOrderItem : ((BundleOrderItem)itemFromOrder).getDiscreteOrderItems()) {
                Integer newQty = (Integer)libraryQty.get(discreteOrderItem.getSku());
                discreteOrderItem.setQuantity(newQty);
                libraryQty.put(discreteOrderItem.getSku(), 0);
            }
        }
        order = this.orderService.save(order, false);
        request.setAddedOrderItem(itemFromOrder);
        request.setOrder(order);
        return context;
    }
}

