/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.core.pricing.service.workflow.type;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.broadleafcommerce.presentation.BroadleafEnumerationType;

public class ShippingServiceType
implements Serializable,
BroadleafEnumerationType {
    private static final long serialVersionUID = 1L;
    private static final Map<String, ShippingServiceType> TYPES = new HashMap<String, ShippingServiceType>();
    public static final ShippingServiceType BANDED_SHIPPING = new ShippingServiceType("BANDED_SHIPPING", "Banded Shipping");
    public static final ShippingServiceType USPS = new ShippingServiceType("USPS", "United States Postal Service");
    public static final ShippingServiceType FED_EX = new ShippingServiceType("FED_EX", "Federal Express");
    public static final ShippingServiceType UPS = new ShippingServiceType("UPS", "United Parcel Service");
    public static final ShippingServiceType DHL = new ShippingServiceType("DHL", "DHL");
    private String type;
    private String friendlyType;

    public static ShippingServiceType getInstance(String type) {
        return TYPES.get(type);
    }

    public ShippingServiceType() {
    }

    public ShippingServiceType(String type, String friendlyType) {
        this.friendlyType = friendlyType;
        this.setType(type);
    }

    public String getType() {
        return this.type;
    }

    public String getFriendlyType() {
        return this.friendlyType;
    }

    private void setType(String type) {
        this.type = type;
        if (!TYPES.containsKey(type)) {
            TYPES.put(type, this);
        }
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ShippingServiceType other = (ShippingServiceType)obj;
        return !(this.type == null ? other.type != null : !this.type.equals(other.type));
    }
}

