/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.core.offer.service.processor;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.beanutils.BeanComparator;
import org.broadleafcommerce.core.offer.domain.CandidateItemOffer;
import org.broadleafcommerce.core.offer.domain.Offer;
import org.broadleafcommerce.core.offer.domain.OfferItemCriteria;
import org.broadleafcommerce.core.offer.domain.OrderItemAdjustment;
import org.broadleafcommerce.core.offer.service.discount.CandidatePromotionItems;
import org.broadleafcommerce.core.offer.service.discount.ItemOfferComparator;
import org.broadleafcommerce.core.offer.service.discount.OrderItemPriceComparator;
import org.broadleafcommerce.core.offer.service.discount.PromotionDiscount;
import org.broadleafcommerce.core.offer.service.discount.domain.PromotableCandidateItemOffer;
import org.broadleafcommerce.core.offer.service.discount.domain.PromotableCandidateOrderOffer;
import org.broadleafcommerce.core.offer.service.discount.domain.PromotableFulfillmentGroup;
import org.broadleafcommerce.core.offer.service.discount.domain.PromotableOrder;
import org.broadleafcommerce.core.offer.service.discount.domain.PromotableOrderItem;
import org.broadleafcommerce.core.offer.service.discount.domain.PromotableOrderItemAdjustment;
import org.broadleafcommerce.core.offer.service.processor.ItemOfferProcessor;
import org.broadleafcommerce.core.offer.service.processor.OrderOfferProcessorImpl;
import org.broadleafcommerce.core.offer.service.type.OfferType;
import org.broadleafcommerce.money.Money;
import org.compass.core.util.CollectionUtils;
import org.springframework.stereotype.Service;

@Service(value="blItemOfferProcessor")
public class ItemOfferProcessorImpl
extends OrderOfferProcessorImpl
implements ItemOfferProcessor {
    @Override
    public void filterItemLevelOffer(PromotableOrder order, List<PromotableCandidateItemOffer> qualifiedItemOffers, Offer offer) {
        boolean isNewFormat = offer.getQualifyingItemCriteria() != null && offer.getQualifyingItemCriteria().size() > 0 || offer.getTargetItemCriteria() != null;
        boolean itemLevelQualification = false;
        boolean offerCreated = false;
        block0: for (PromotableOrderItem promotableOrderItem : order.getDiscountableDiscreteOrderItems(offer.getApplyDiscountToSalePrice())) {
            if (this.couldOfferApplyToOrder(offer, order, promotableOrderItem)) {
                if (!isNewFormat) {
                    PromotableCandidateItemOffer candidate = this.createCandidateItemOffer(qualifiedItemOffers, offer, promotableOrderItem);
                    if (!candidate.getCandidateTargets().contains(promotableOrderItem)) {
                        candidate.getCandidateTargets().add(promotableOrderItem);
                    }
                    offerCreated = true;
                    continue;
                }
                itemLevelQualification = true;
                break;
            }
            for (PromotableFulfillmentGroup fulfillmentGroup : order.getFulfillmentGroups()) {
                if (!this.couldOfferApplyToOrder(offer, order, promotableOrderItem, fulfillmentGroup)) continue;
                if (!isNewFormat) {
                    PromotableCandidateItemOffer candidate = this.createCandidateItemOffer(qualifiedItemOffers, offer, promotableOrderItem);
                    if (!candidate.getCandidateTargets().contains(promotableOrderItem)) {
                        candidate.getCandidateTargets().add(promotableOrderItem);
                    }
                    offerCreated = true;
                    continue;
                }
                itemLevelQualification = true;
                continue block0;
            }
        }
        if (itemLevelQualification && !offerCreated) {
            CandidatePromotionItems candidates = this.couldOfferApplyToOrderItems(offer, order.getDiscountableDiscreteOrderItems(offer.getApplyDiscountToSalePrice()));
            PromotableCandidateItemOffer candidateOffer = null;
            if (candidates.isMatchedQualifier()) {
                candidateOffer = this.createCandidateItemOffer(qualifiedItemOffers, offer, null);
                candidateOffer.getCandidateQualifiersMap().putAll(candidates.getCandidateQualifiersMap());
            }
            if (candidates.isMatchedTarget() && candidates.isMatchedQualifier()) {
                if (candidateOffer == null) {
                    candidateOffer = this.createCandidateItemOffer(qualifiedItemOffers, offer, null);
                }
                for (PromotableOrderItem candidateItem : candidates.getCandidateTargets()) {
                    PromotableCandidateItemOffer itemOffer = candidateOffer.clone();
                    itemOffer.setOrderItem(candidateItem);
                    candidateItem.addCandidateItemOffer(itemOffer);
                }
                candidateOffer.getCandidateTargets().addAll(candidates.getCandidateTargets());
            }
        }
    }

    protected PromotableCandidateItemOffer createCandidateItemOffer(List<PromotableCandidateItemOffer> qualifiedItemOffers, Offer offer, PromotableOrderItem promotableOrderItem) {
        CandidateItemOffer candidateOffer = this.offerDao.createCandidateItemOffer();
        candidateOffer.setOffer(offer);
        PromotableCandidateItemOffer promotableCandidateItemOffer = this.promotableItemFactory.createPromotableCandidateItemOffer(candidateOffer);
        if (promotableOrderItem != null) {
            promotableOrderItem.addCandidateItemOffer(promotableCandidateItemOffer);
        }
        promotableCandidateItemOffer.setOrderItem(promotableOrderItem);
        qualifiedItemOffers.add(promotableCandidateItemOffer);
        return promotableCandidateItemOffer;
    }

    @Override
    public boolean applyAllItemOffers(List<PromotableCandidateItemOffer> itemOffers, PromotableOrder order) {
        boolean itemOffersApplied = false;
        int appliedItemOffersCount = 0;
        boolean isLegacyFormat = false;
        for (PromotableCandidateItemOffer itemOffer : itemOffers) {
            int beforeCount = appliedItemOffersCount;
            PromotableOrderItem orderItem = itemOffer.getOrderItem();
            if (orderItem != null) {
                isLegacyFormat = true;
                appliedItemOffersCount = this.applyLegacyAdjustments(appliedItemOffersCount, itemOffer, beforeCount, orderItem);
                continue;
            }
            appliedItemOffersCount = this.applyAdjustments(order, appliedItemOffersCount, itemOffer, beforeCount);
        }
        appliedItemOffersCount = isLegacyFormat ? this.checkLegacyAdjustments(order.getDiscountableDiscreteOrderItems(), appliedItemOffersCount) : this.checkAdjustments(order, appliedItemOffersCount);
        if (appliedItemOffersCount > 0) {
            itemOffersApplied = true;
        }
        return itemOffersApplied;
    }

    protected int applyAdjustments(PromotableOrder order, int appliedItemOffersCount, PromotableCandidateItemOffer itemOffer, int beforeCount) {
        boolean notCombinableOfferApplied = false;
        boolean offerApplied = false;
        List<PromotableOrderItem> allSplitItems = order.getAllSplitItems();
        for (PromotableOrderItem targetItem : allSplitItems) {
            notCombinableOfferApplied = targetItem.isNotCombinableOfferApplied();
            if (!offerApplied) {
                offerApplied = targetItem.isHasOrderItemAdjustments();
            }
            if (!notCombinableOfferApplied) continue;
            break;
        }
        if (!(notCombinableOfferApplied || !itemOffer.getOffer().isCombinableWithOtherOffers() && itemOffer.getOffer().isTotalitarianOffer() != null && itemOffer.getOffer().isTotalitarianOffer().booleanValue() && offerApplied)) {
            this.applyItemQualifiersAndTargets(itemOffer, order);
            allSplitItems = order.getAllSplitItems();
            block1: for (PromotableOrderItem splitItem : allSplitItems) {
                for (PromotionDiscount discount : splitItem.getPromotionDiscounts()) {
                    if (!discount.getPromotion().equals(itemOffer.getOffer())) continue;
                    this.applyOrderItemAdjustment(itemOffer, splitItem);
                    ++appliedItemOffersCount;
                    continue block1;
                }
            }
        }
        if ((!itemOffer.getOffer().isCombinableWithOtherOffers() || itemOffer.getOffer().isTotalitarianOffer() != null && itemOffer.getOffer().isTotalitarianOffer().booleanValue()) && appliedItemOffersCount > beforeCount) {
            Money adjustmentTotal = new Money(0.0);
            Money saleTotal = new Money(0.0);
            for (PromotableOrderItem splitItem : allSplitItems) {
                adjustmentTotal = adjustmentTotal.add(splitItem.getCurrentPrice().multiply(splitItem.getQuantity()));
                saleTotal = saleTotal.add(splitItem.getPriceBeforeAdjustments(true).multiply(splitItem.getQuantity()));
            }
            if (adjustmentTotal.greaterThanOrEqual(saleTotal)) {
                for (PromotableOrderItem splitItem : allSplitItems) {
                    if (!splitItem.isHasOrderItemAdjustments()) continue;
                    --appliedItemOffersCount;
                }
                order.getSplitItems().clear();
            }
        }
        return appliedItemOffersCount;
    }

    protected int checkAdjustments(PromotableOrder order, int appliedItemOffersCount) {
        if (appliedItemOffersCount > 0) {
            List<PromotableOrderItem> allSplitItems = order.getAllSplitItems();
            for (PromotableOrderItem splitItem : allSplitItems) {
                if (!splitItem.isHasOrderItemAdjustments()) continue;
                boolean useSaleAdjustments = false;
                int adjustmentsRemoved = 0;
                if (splitItem.getDelegate().getIsOnSale()) {
                    Money adjustmentPrice;
                    if (splitItem.getSaleAdjustmentPrice().lessThanOrEqual(splitItem.getRetailAdjustmentPrice())) {
                        adjustmentPrice = splitItem.getSaleAdjustmentPrice();
                        useSaleAdjustments = true;
                    } else {
                        adjustmentPrice = splitItem.getRetailAdjustmentPrice();
                    }
                    if (!adjustmentPrice.lessThan(splitItem.getSalePrice())) {
                        adjustmentsRemoved += splitItem.removeAllAdjustments();
                    }
                } else if (!splitItem.getRetailAdjustmentPrice().lessThan(splitItem.getRetailPrice())) {
                    adjustmentsRemoved += splitItem.removeAllAdjustments();
                }
                appliedItemOffersCount -= (adjustmentsRemoved += splitItem.fixAdjustments(useSaleAdjustments));
            }
            this.mergeSplitItems(order);
        }
        return appliedItemOffersCount;
    }

    protected int checkLegacyAdjustments(List<PromotableOrderItem> discreteOrderItems, int appliedItemOffersCount) {
        if (appliedItemOffersCount > 0) {
            for (PromotableOrderItem discreteOrderItem : discreteOrderItems) {
                if (!discreteOrderItem.isHasOrderItemAdjustments()) continue;
                boolean useSaleAdjustments = false;
                int adjustmentsRemoved = 0;
                if (discreteOrderItem.getDelegate().getIsOnSale()) {
                    Money adjustmentPrice;
                    if (discreteOrderItem.getSaleAdjustmentPrice().lessThanOrEqual(discreteOrderItem.getRetailAdjustmentPrice())) {
                        adjustmentPrice = discreteOrderItem.getSaleAdjustmentPrice();
                        useSaleAdjustments = true;
                    } else {
                        adjustmentPrice = discreteOrderItem.getRetailAdjustmentPrice();
                    }
                    if (!adjustmentPrice.lessThanOrEqual(discreteOrderItem.getSalePrice())) {
                        adjustmentsRemoved += discreteOrderItem.removeAllAdjustments();
                    }
                } else if (!discreteOrderItem.getRetailAdjustmentPrice().lessThanOrEqual(discreteOrderItem.getRetailPrice())) {
                    adjustmentsRemoved += discreteOrderItem.removeAllAdjustments();
                }
                appliedItemOffersCount -= (adjustmentsRemoved += discreteOrderItem.fixAdjustments(useSaleAdjustments));
            }
        }
        return appliedItemOffersCount;
    }

    protected int applyLegacyAdjustments(int appliedItemOffersCount, PromotableCandidateItemOffer itemOffer, int beforeCount, PromotableOrderItem orderItem) {
        if (!orderItem.isNotCombinableOfferApplied() && (itemOffer.getOffer().isCombinableWithOtherOffers() && itemOffer.getOffer().isStackable() || !orderItem.isHasOrderItemAdjustments())) {
            this.applyOrderItemAdjustment(itemOffer, orderItem);
            ++appliedItemOffersCount;
        }
        if (!itemOffer.getOffer().isCombinableWithOtherOffers() && appliedItemOffersCount > beforeCount) {
            Money adjustmentTotal = new Money(0.0);
            Money saleTotal = new Money(0.0);
            if ((adjustmentTotal = adjustmentTotal.add(orderItem.getCurrentPrice().multiply(orderItem.getQuantity()))).greaterThanOrEqual(saleTotal = saleTotal.add(orderItem.getPriceBeforeAdjustments(true).multiply(orderItem.getQuantity())))) {
                orderItem.removeAllAdjustments();
                --appliedItemOffersCount;
            }
        }
        return appliedItemOffersCount;
    }

    protected void applyItemQualifiersAndTargets(PromotableCandidateItemOffer itemOffer, PromotableOrder order) {
        Offer promotion = itemOffer.getOffer();
        OrderItemPriceComparator priceComparator = new OrderItemPriceComparator(promotion.getApplyDiscountToSalePrice());
        boolean matchFound = false;
        do {
            int receiveQtyNeeded;
            int totalQualifiersNeeded;
            block11: {
                matchFound = false;
                totalQualifiersNeeded = 0;
                for (OfferItemCriteria itemCriteria : itemOffer.getCandidateQualifiersMap().keySet()) {
                    totalQualifiersNeeded += itemCriteria.getQuantity().intValue();
                }
                receiveQtyNeeded = promotion.getTargetItemCriteria().getQuantity();
                for (OfferItemCriteria itemCriteria : itemOffer.getCandidateQualifiersMap().keySet()) {
                    List<PromotableOrderItem> chargeableItems = itemOffer.getCandidateQualifiersMap().get(itemCriteria);
                    Collections.sort(chargeableItems, priceComparator);
                    int qualifierQtyNeeded = itemCriteria.getQuantity();
                    for (PromotableOrderItem chargeableItem : chargeableItems) {
                        int itemQtyAvailableToBeUsedAsQualifier;
                        if (qualifierQtyNeeded > 0 && (itemQtyAvailableToBeUsedAsQualifier = chargeableItem.getQuantityAvailableToBeUsedAsQualifier(promotion)) > 0) {
                            int qtyToMarkAsQualifier = Math.min(qualifierQtyNeeded, itemQtyAvailableToBeUsedAsQualifier);
                            qualifierQtyNeeded -= qtyToMarkAsQualifier;
                            chargeableItem.addPromotionQualifier(itemOffer, itemCriteria, qtyToMarkAsQualifier);
                        }
                        if (qualifierQtyNeeded != 0) continue;
                        totalQualifiersNeeded -= itemCriteria.getQuantity().intValue();
                        break;
                    }
                    if (qualifierQtyNeeded == 0) continue;
                    break block11;
                }
                List<PromotableOrderItem> chargeableItems = itemOffer.getCandidateTargets();
                Collections.sort(chargeableItems, priceComparator);
                for (PromotableOrderItem chargeableItem : chargeableItems) {
                    int itemQtyAvailableToBeUsedAsTarget;
                    if (receiveQtyNeeded > 0 && (itemQtyAvailableToBeUsedAsTarget = chargeableItem.getQuantityAvailableToBeUsedAsTarget(promotion)) > 0 && (promotion.getMaxUses() == 0 || itemOffer.getUses() < promotion.getMaxUses())) {
                        int qtyToMarkAsTarget = Math.min(receiveQtyNeeded, itemQtyAvailableToBeUsedAsTarget);
                        receiveQtyNeeded -= qtyToMarkAsTarget;
                        chargeableItem.addPromotionDiscount(itemOffer, itemOffer.getOffer().getTargetItemCriteria(), qtyToMarkAsTarget);
                    }
                    if (receiveQtyNeeded != 0) continue;
                    break;
                }
            }
            boolean criteriaMatched = true;
            if (receiveQtyNeeded != 0 || totalQualifiersNeeded != 0) {
                for (OfferItemCriteria itemCriteria : itemOffer.getCandidateQualifiersMap().keySet()) {
                    List<PromotableOrderItem> chargeableItems = itemOffer.getCandidateQualifiersMap().get(itemCriteria);
                    this.clearAllNonFinalizedQuantities(chargeableItems);
                }
                this.clearAllNonFinalizedQuantities(itemOffer.getCandidateTargets());
                criteriaMatched = false;
            }
            if (!criteriaMatched) continue;
            matchFound = true;
            this.finalizeQuantities(order.getDiscountableDiscreteOrderItems());
        } while (matchFound);
        if (order.getSplitItems().size() == 0) {
            this.initializeSplitItems(order);
        }
        List<PromotableOrderItem> allSplitItems = order.getAllSplitItems();
        for (PromotableOrderItem chargeableItem : allSplitItems) {
            List<PromotableOrderItem> temp;
            List<PromotableOrderItem> splitItems;
            if (!itemOffer.getCandidateTargets().contains(chargeableItem) || (splitItems = chargeableItem.split()) == null || splitItems.size() <= 0 || CollectionUtils.isEmpty(temp = order.searchSplitItems(chargeableItem))) continue;
            temp.remove(chargeableItem);
            temp.addAll(splitItems);
        }
    }

    protected void applyOrderItemAdjustment(PromotableCandidateItemOffer itemOffer, PromotableOrderItem orderItem) {
        OrderItemAdjustment itemAdjustment = this.offerDao.createOrderItemAdjustment();
        itemAdjustment.init(orderItem.getDelegate(), itemOffer.getOffer(), itemOffer.getOffer().getName());
        PromotableOrderItemAdjustment promotableOrderItemAdjustment = this.promotableItemFactory.createPromotableOrderItemAdjustment(itemAdjustment, orderItem);
        orderItem.addOrderItemAdjustment(promotableOrderItemAdjustment);
    }

    @Override
    public void filterOffers(PromotableOrder order, List<Offer> filteredOffers, List<PromotableCandidateOrderOffer> qualifiedOrderOffers, List<PromotableCandidateItemOffer> qualifiedItemOffers) {
        order.setSubTotal(order.calculateOrderItemsFinalPrice(true));
        for (Offer offer : filteredOffers) {
            if (offer.getType().equals(OfferType.ORDER)) {
                this.filterOrderLevelOffer(order, qualifiedOrderOffers, offer);
                continue;
            }
            if (!offer.getType().equals(OfferType.ORDER_ITEM)) continue;
            this.filterItemLevelOffer(order, qualifiedItemOffers, offer);
        }
    }

    @Override
    public void applyAndCompareOrderAndItemOffers(PromotableOrder order, List<PromotableCandidateOrderOffer> qualifiedOrderOffers, List<PromotableCandidateItemOffer> qualifiedItemOffers) {
        if (!qualifiedItemOffers.isEmpty()) {
            Collections.sort(qualifiedItemOffers, ItemOfferComparator.INSTANCE);
            this.applyAllItemOffers(qualifiedItemOffers, order);
        }
        if (!qualifiedOrderOffers.isEmpty()) {
            Collections.sort(qualifiedOrderOffers, new BeanComparator("discountedPrice"));
            Collections.sort(qualifiedOrderOffers, new BeanComparator("priority"));
            qualifiedOrderOffers = this.removeTrailingNotCombinableOrderOffers(qualifiedOrderOffers);
            this.applyAllOrderOffers(qualifiedOrderOffers, order);
        }
        this.compileOrderTotal(order);
        if (!qualifiedOrderOffers.isEmpty() && !qualifiedItemOffers.isEmpty()) {
            ArrayList<PromotableCandidateOrderOffer> finalQualifiedOrderOffers = new ArrayList<PromotableCandidateOrderOffer>();
            order.removeAllOrderAdjustments();
            for (PromotableCandidateOrderOffer candidateOrderOffer : qualifiedOrderOffers) {
                if (!this.couldOfferApplyToOrder(candidateOrderOffer.getOffer(), order)) continue;
                finalQualifiedOrderOffers.add(candidateOrderOffer);
            }
            Collections.sort(finalQualifiedOrderOffers, new BeanComparator("discountedPrice"));
            Collections.sort(finalQualifiedOrderOffers, new BeanComparator("priority"));
            if (!finalQualifiedOrderOffers.isEmpty()) {
                this.applyAllOrderOffers(finalQualifiedOrderOffers, order);
            }
        }
    }
}

