/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.core.offer.service.discount.domain;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.broadleafcommerce.core.offer.domain.CandidateOrderOffer;
import org.broadleafcommerce.core.offer.domain.FulfillmentGroupAdjustment;
import org.broadleafcommerce.core.offer.domain.OrderAdjustment;
import org.broadleafcommerce.core.offer.domain.OrderItemAdjustment;
import org.broadleafcommerce.core.offer.service.discount.OrderItemPriceComparator;
import org.broadleafcommerce.core.offer.service.discount.domain.PromotableCandidateOrderOffer;
import org.broadleafcommerce.core.offer.service.discount.domain.PromotableFulfillmentGroup;
import org.broadleafcommerce.core.offer.service.discount.domain.PromotableItemFactory;
import org.broadleafcommerce.core.offer.service.discount.domain.PromotableOrder;
import org.broadleafcommerce.core.offer.service.discount.domain.PromotableOrderAdjustment;
import org.broadleafcommerce.core.offer.service.discount.domain.PromotableOrderItem;
import org.broadleafcommerce.core.order.domain.BundleOrderItem;
import org.broadleafcommerce.core.order.domain.DiscreteOrderItem;
import org.broadleafcommerce.core.order.domain.DynamicPriceDiscreteOrderItem;
import org.broadleafcommerce.core.order.domain.FulfillmentGroup;
import org.broadleafcommerce.core.order.domain.GiftWrapOrderItem;
import org.broadleafcommerce.core.order.domain.Order;
import org.broadleafcommerce.core.order.domain.OrderItem;
import org.broadleafcommerce.core.order.service.manipulation.BundleOrderItemSplitContainer;
import org.broadleafcommerce.core.order.service.manipulation.OrderItemSplitContainer;
import org.broadleafcommerce.core.order.service.manipulation.OrderItemVisitorAdapter;
import org.broadleafcommerce.core.pricing.service.exception.PricingException;
import org.broadleafcommerce.money.Money;
import org.broadleafcommerce.profile.core.domain.Customer;

public class PromotableOrderImpl
implements PromotableOrder {
    private static final long serialVersionUID = 1L;
    protected boolean totalitarianOfferApplied = false;
    protected boolean notCombinableOfferAppliedAtAnyLevel = false;
    protected boolean notCombinableOfferApplied = false;
    protected boolean hasOrderAdjustments = false;
    protected List<OrderItemSplitContainer> splitItems = new ArrayList<OrderItemSplitContainer>();
    protected List<BundleOrderItemSplitContainer> bundleSplitItems = new ArrayList<BundleOrderItemSplitContainer>();
    protected BigDecimal adjustmentPrice;
    protected Order delegate;
    protected List<PromotableFulfillmentGroup> fulfillmentGroups;
    protected List<PromotableOrderItem> discreteOrderItems;
    protected List<PromotableOrderItem> discountableDiscreteOrderItems;
    protected boolean currentSortParam = false;
    protected PromotableItemFactory itemFactory;

    public PromotableOrderImpl(Order order, PromotableItemFactory itemFactory) {
        this.delegate = order;
        this.itemFactory = itemFactory;
    }

    public void reset() {
        this.delegate = null;
        this.resetFulfillmentGroups();
        this.resetDiscreteOrderItems();
    }

    @Override
    public void resetFulfillmentGroups() {
        for (PromotableFulfillmentGroup fulfillmentGroup : this.fulfillmentGroups) {
            fulfillmentGroup.reset();
        }
        this.fulfillmentGroups = null;
    }

    @Override
    public void resetDiscreteOrderItems() {
        if (this.discreteOrderItems != null) {
            for (PromotableOrderItem orderItem : this.discreteOrderItems) {
                orderItem.reset();
            }
            this.discreteOrderItems = null;
        }
        if (this.discountableDiscreteOrderItems != null) {
            for (PromotableOrderItem orderItem : this.discountableDiscreteOrderItems) {
                orderItem.reset();
            }
            this.discountableDiscreteOrderItems = null;
        }
    }

    @Override
    public void resetTotalitarianOfferApplied() {
        this.totalitarianOfferApplied = false;
        this.notCombinableOfferAppliedAtAnyLevel = false;
        for (OrderAdjustment adjustment : this.delegate.getOrderAdjustments()) {
            if (adjustment.getOffer().isTotalitarianOffer() != null && adjustment.getOffer().isTotalitarianOffer().booleanValue()) {
                this.totalitarianOfferApplied = true;
                break;
            }
            if (adjustment.getOffer().isCombinableWithOtherOffers()) continue;
            this.notCombinableOfferAppliedAtAnyLevel = true;
            break;
        }
        if (!this.totalitarianOfferApplied || !this.notCombinableOfferAppliedAtAnyLevel) {
            block1: for (OrderItem orderItem : this.delegate.getOrderItems()) {
                for (OrderItemAdjustment orderItemAdjustment : orderItem.getOrderItemAdjustments()) {
                    if (orderItemAdjustment.getOffer().isTotalitarianOffer() != null && orderItemAdjustment.getOffer().isTotalitarianOffer().booleanValue()) {
                        this.totalitarianOfferApplied = true;
                        break block1;
                    }
                    if (orderItemAdjustment.getOffer().isCombinableWithOtherOffers()) continue;
                    this.notCombinableOfferAppliedAtAnyLevel = true;
                    break block1;
                }
            }
        }
        if (!this.totalitarianOfferApplied || !this.notCombinableOfferAppliedAtAnyLevel) {
            block3: for (FulfillmentGroup fg : this.delegate.getFulfillmentGroups()) {
                for (FulfillmentGroupAdjustment fulfillmentGroupAdjustment : fg.getFulfillmentGroupAdjustments()) {
                    if (fulfillmentGroupAdjustment.getOffer().isTotalitarianOffer() != null && fulfillmentGroupAdjustment.getOffer().isTotalitarianOffer().booleanValue()) {
                        this.totalitarianOfferApplied = true;
                        break block3;
                    }
                    if (fulfillmentGroupAdjustment.getOffer().isCombinableWithOtherOffers()) continue;
                    this.notCombinableOfferAppliedAtAnyLevel = true;
                    break block3;
                }
            }
        }
    }

    @Override
    public void addOrderAdjustments(PromotableOrderAdjustment orderAdjustment) {
        if (this.delegate.getOrderAdjustments().size() == 0) {
            this.adjustmentPrice = this.delegate.getSubTotal().getAmount();
        }
        this.adjustmentPrice = this.adjustmentPrice.subtract(orderAdjustment.getValue().getAmount());
        this.delegate.getOrderAdjustments().add(orderAdjustment.getDelegate());
        if (!orderAdjustment.getDelegate().getOffer().isCombinableWithOtherOffers()) {
            this.notCombinableOfferApplied = true;
        }
        this.resetTotalitarianOfferApplied();
        this.hasOrderAdjustments = true;
    }

    @Override
    public void removeAllAdjustments() {
        this.removeAllItemAdjustments();
        this.removeAllFulfillmentAdjustments();
        this.removeAllOrderAdjustments();
    }

    @Override
    public void removeAllOrderAdjustments() {
        if (this.delegate.getOrderAdjustments() != null) {
            for (OrderAdjustment adjustment : this.delegate.getOrderAdjustments()) {
                adjustment.setOrder(null);
            }
            this.delegate.getOrderAdjustments().clear();
        }
        this.adjustmentPrice = null;
        this.notCombinableOfferApplied = false;
        this.hasOrderAdjustments = false;
        this.resetTotalitarianOfferApplied();
    }

    @Override
    public void removeAllItemAdjustments() {
        for (OrderItem orderItem : this.getDelegate().getOrderItems()) {
            orderItem.removeAllAdjustments();
            this.adjustmentPrice = null;
            this.resetTotalitarianOfferApplied();
            if (orderItem instanceof BundleOrderItem) {
                for (DiscreteOrderItem discreteOrderItem : ((BundleOrderItem)orderItem).getDiscreteOrderItems()) {
                    discreteOrderItem.setPrice(null);
                }
            }
            orderItem.setPrice(null);
            orderItem.assignFinalPrice();
        }
        this.splitItems.clear();
    }

    @Override
    public void removeAllFulfillmentAdjustments() {
        for (PromotableFulfillmentGroup fulfillmentGroup : this.getFulfillmentGroups()) {
            fulfillmentGroup.removeAllAdjustments();
        }
    }

    @Override
    public Money getAdjustmentPrice() {
        return this.adjustmentPrice == null ? null : new Money(this.adjustmentPrice, this.delegate.getSubTotal().getCurrency(), this.adjustmentPrice.scale() == 0 ? 2 : this.adjustmentPrice.scale());
    }

    @Override
    public void setAdjustmentPrice(Money adjustmentPrice) {
        this.adjustmentPrice = Money.toAmount((Money)adjustmentPrice);
    }

    @Override
    public boolean isNotCombinableOfferApplied() {
        return this.notCombinableOfferApplied;
    }

    @Override
    public boolean isHasOrderAdjustments() {
        return this.hasOrderAdjustments;
    }

    @Override
    public boolean isTotalitarianOfferApplied() {
        return this.totalitarianOfferApplied;
    }

    @Override
    public void setTotalitarianOfferApplied(boolean totalitarianOfferApplied) {
        this.totalitarianOfferApplied = totalitarianOfferApplied;
    }

    @Override
    public boolean isNotCombinableOfferAppliedAtAnyLevel() {
        return this.notCombinableOfferAppliedAtAnyLevel;
    }

    @Override
    public void setNotCombinableOfferAppliedAtAnyLevel(boolean notCombinableOfferAppliedAtAnyLevel) {
        this.notCombinableOfferAppliedAtAnyLevel = notCombinableOfferAppliedAtAnyLevel;
    }

    @Override
    public List<OrderItemSplitContainer> getSplitItems() {
        return this.splitItems;
    }

    @Override
    public void setSplitItems(List<OrderItemSplitContainer> splitItems) {
        this.splitItems = splitItems;
    }

    @Override
    public List<PromotableOrderItem> searchSplitItems(PromotableOrderItem key) {
        for (OrderItemSplitContainer container : this.splitItems) {
            if (!container.getKey().equals(key.getDelegate())) continue;
            return container.getSplitItems();
        }
        return null;
    }

    @Override
    public List<BundleOrderItem> searchBundleSplitItems(BundleOrderItem key) {
        for (BundleOrderItemSplitContainer container : this.bundleSplitItems) {
            if (!container.getKey().equals(key)) continue;
            return container.getSplitItems();
        }
        return null;
    }

    @Override
    public void removeAllCandidateOffers() {
        this.removeAllCandidateOrderOffers();
        for (OrderItem orderItem : this.getDelegate().getOrderItems()) {
            orderItem.removeAllCandidateItemOffers();
        }
        this.removeAllCandidateFulfillmentGroupOffers();
    }

    @Override
    public void removeAllCandidateFulfillmentGroupOffers() {
        if (this.getFulfillmentGroups() != null) {
            for (PromotableFulfillmentGroup fg : this.getFulfillmentGroups()) {
                fg.removeAllCandidateOffers();
            }
        }
    }

    @Override
    public void removeAllCandidateOrderOffers() {
        if (this.delegate.getCandidateOrderOffers() != null) {
            for (CandidateOrderOffer candidate : this.delegate.getCandidateOrderOffers()) {
                candidate.setOrder(null);
            }
            this.delegate.getCandidateOrderOffers().clear();
        }
    }

    @Override
    public boolean containsNotStackableFulfillmentGroupOffer() {
        boolean isContainsNotStackableFulfillmentGroupOffer = false;
        block0: for (FulfillmentGroup fg : this.delegate.getFulfillmentGroups()) {
            for (FulfillmentGroupAdjustment fgAdjustment : fg.getFulfillmentGroupAdjustments()) {
                if (fgAdjustment.getOffer().isStackable()) continue;
                isContainsNotStackableFulfillmentGroupOffer = true;
                continue block0;
            }
        }
        return isContainsNotStackableFulfillmentGroupOffer;
    }

    @Override
    public boolean containsNotStackableOrderOffer() {
        boolean isContainsNotStackableOrderOffer = false;
        for (OrderAdjustment orderAdjustment : this.delegate.getOrderAdjustments()) {
            if (orderAdjustment.getOffer().isStackable()) continue;
            isContainsNotStackableOrderOffer = true;
            break;
        }
        return isContainsNotStackableOrderOffer;
    }

    @Override
    public void removeAllAddedOfferCodes() {
        if (this.delegate.getAddedOfferCodes() != null) {
            this.delegate.getAddedOfferCodes().clear();
        }
    }

    @Override
    public void addCandidateOrderOffer(PromotableCandidateOrderOffer candidateOrderOffer) {
        this.delegate.getCandidateOrderOffers().add(candidateOrderOffer.getDelegate());
    }

    @Override
    public Money calculateOrderItemsCurrentPrice() {
        Money calculatedSubTotal = new Money();
        for (PromotableOrderItem orderItem : this.getDiscountableDiscreteOrderItems()) {
            Money currentPrice = orderItem.getCurrentPrice();
            calculatedSubTotal = calculatedSubTotal.add(currentPrice.multiply(orderItem.getQuantity()));
        }
        return calculatedSubTotal;
    }

    @Override
    public Money calculateOrderItemsPriceWithoutAdjustments() {
        Money calculatedSubTotal = new Money();
        for (OrderItem orderItem : this.delegate.getOrderItems()) {
            Money price = orderItem.getPriceBeforeAdjustments(true);
            calculatedSubTotal = calculatedSubTotal.add(price.multiply(orderItem.getQuantity()));
        }
        return calculatedSubTotal;
    }

    @Override
    public List<PromotableOrderItem> getAllSplitItems() {
        ArrayList<PromotableOrderItem> response = new ArrayList<PromotableOrderItem>();
        for (OrderItemSplitContainer container : this.getSplitItems()) {
            response.addAll(container.getSplitItems());
        }
        return response;
    }

    @Override
    public Money getSubTotal() {
        return this.delegate.getSubTotal();
    }

    @Override
    public List<PromotableFulfillmentGroup> getFulfillmentGroups() {
        if (this.fulfillmentGroups == null) {
            this.fulfillmentGroups = new ArrayList<PromotableFulfillmentGroup>();
            for (FulfillmentGroup fulfillmentGroup : this.delegate.getFulfillmentGroups()) {
                this.fulfillmentGroups.add(this.itemFactory.createPromotableFulfillmentGroup(fulfillmentGroup, this));
            }
        }
        return Collections.unmodifiableList(this.fulfillmentGroups);
    }

    @Override
    public void setTotalShipping(Money totalShipping) {
        this.delegate.setTotalShipping(totalShipping);
    }

    @Override
    public Money calculateOrderItemsFinalPrice(boolean includeNonTaxableItems) {
        return this.delegate.calculateOrderItemsFinalPrice(includeNonTaxableItems);
    }

    @Override
    public void setSubTotal(Money subTotal) {
        this.delegate.setSubTotal(subTotal);
    }

    @Override
    public void assignOrderItemsFinalPrice() {
        for (PromotableOrderItem promotableOrderItem : this.getDiscountableDiscreteOrderItems()) {
            promotableOrderItem.assignFinalPrice();
        }
        for (OrderItem orderItem : this.getDelegate().getOrderItems()) {
            if (!(orderItem instanceof BundleOrderItem)) continue;
            orderItem.assignFinalPrice();
        }
    }

    @Override
    public Customer getCustomer() {
        return this.delegate.getCustomer();
    }

    @Override
    public List<PromotableOrderItem> getDiscreteOrderItems() {
        if (this.discreteOrderItems == null) {
            this.discreteOrderItems = new ArrayList<PromotableOrderItem>();
            OrderItemVisitorAdapter visitor = new OrderItemVisitorAdapter(){

                @Override
                public void visit(BundleOrderItem bundleOrderItem) throws PricingException {
                    for (DiscreteOrderItem discreteOrderItem : bundleOrderItem.getDiscreteOrderItems()) {
                        this.addDiscreteItem(discreteOrderItem);
                    }
                }

                @Override
                public void visit(DiscreteOrderItem discreteOrderItem) throws PricingException {
                    this.addDiscreteItem(discreteOrderItem);
                }

                @Override
                public void visit(DynamicPriceDiscreteOrderItem dynamicPriceDiscreteOrderItem) throws PricingException {
                    this.addDiscreteItem(dynamicPriceDiscreteOrderItem);
                }

                @Override
                public void visit(GiftWrapOrderItem giftWrapOrderItem) throws PricingException {
                    this.addDiscreteItem(giftWrapOrderItem);
                }

                private void addDiscreteItem(DiscreteOrderItem discreteOrderItem) {
                    PromotableOrderItem item = PromotableOrderImpl.this.itemFactory.createPromotableOrderItem(discreteOrderItem, PromotableOrderImpl.this);
                    item.computeAdjustmentPrice();
                    PromotableOrderImpl.this.discreteOrderItems.add(item);
                }
            };
            ArrayList<OrderItem> basicOrderItems = new ArrayList<OrderItem>();
            basicOrderItems.addAll(this.delegate.getOrderItems());
            Iterator itr = basicOrderItems.iterator();
            while (itr.hasNext()) {
                OrderItem temp = (OrderItem)itr.next();
                if (!(temp instanceof BundleOrderItem)) continue;
                itr.remove();
            }
            for (BundleOrderItemSplitContainer container : this.bundleSplitItems) {
                basicOrderItems.addAll(container.getSplitItems());
            }
            try {
                for (OrderItem temp : basicOrderItems) {
                    temp.accept(visitor);
                }
            }
            catch (PricingException e) {
                throw new RuntimeException(e);
            }
        }
        return this.discreteOrderItems;
    }

    @Override
    public List<PromotableOrderItem> getDiscountableDiscreteOrderItems() {
        return this.getDiscountableDiscreteOrderItems(false);
    }

    @Override
    public List<PromotableOrderItem> getDiscountableDiscreteOrderItems(boolean applyDiscountToSalePrice) {
        OrderItemPriceComparator priceComparator;
        if (this.discountableDiscreteOrderItems == null) {
            this.discountableDiscreteOrderItems = new ArrayList<PromotableOrderItem>();
            for (PromotableOrderItem orderItem : this.getDiscreteOrderItems()) {
                if (orderItem.getSku().isDiscountable() != null && !orderItem.getSku().isDiscountable().booleanValue()) continue;
                this.discountableDiscreteOrderItems.add(orderItem);
            }
            priceComparator = new OrderItemPriceComparator(applyDiscountToSalePrice);
            Collections.sort(this.discountableDiscreteOrderItems, priceComparator);
            this.currentSortParam = applyDiscountToSalePrice;
        }
        if (this.currentSortParam != applyDiscountToSalePrice) {
            priceComparator = new OrderItemPriceComparator(applyDiscountToSalePrice);
            Collections.sort(this.discountableDiscreteOrderItems, priceComparator);
            this.currentSortParam = applyDiscountToSalePrice;
        }
        return this.discountableDiscreteOrderItems;
    }

    @Override
    public Order getDelegate() {
        return this.delegate;
    }

    @Override
    public List<BundleOrderItemSplitContainer> getBundleSplitItems() {
        return this.bundleSplitItems;
    }

    @Override
    public void setBundleSplitItems(List<BundleOrderItemSplitContainer> bundleSplitItems) {
        this.bundleSplitItems = bundleSplitItems;
    }
}

