/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.core.content.service;

import java.io.Reader;
import java.io.Serializable;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.collections.map.LRUMap;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.broadleafcommerce.core.content.dao.ContentDao;
import org.broadleafcommerce.core.content.dao.ContentDetailsDao;
import org.broadleafcommerce.core.content.domain.Content;
import org.broadleafcommerce.core.content.domain.ContentDetails;
import org.broadleafcommerce.core.content.domain.ContentDetailsImpl;
import org.broadleafcommerce.core.content.domain.ContentImpl;
import org.broadleafcommerce.core.content.domain.ContentPageInfo;
import org.broadleafcommerce.core.content.domain.ContentXmlData;
import org.broadleafcommerce.core.content.service.ContentService;
import org.broadleafcommerce.openadmin.time.SystemTime;
import org.compass.core.util.reader.StringReader;
import org.mvel2.MVEL;
import org.mvel2.ParserContext;
import org.springframework.stereotype.Service;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

@Service(value="blContentService")
public class ContentServiceImpl
implements ContentService {
    private static final Log LOG = LogFactory.getLog(ContentServiceImpl.class);
    private static final LRUMap EXPRESSION_CACHE = new LRUMap(1000);
    @Resource(name="blContentDao")
    protected ContentDao contentDao;
    @Resource(name="blContentDetailsDao")
    protected ContentDetailsDao contentDetailsDao;

    @Override
    public Content findContentById(Integer id) {
        return this.contentDao.readContentById(id);
    }

    @Override
    public ContentDetails findContentDetailsById(Integer id) {
        return this.contentDetailsDao.readContentDetailsById(id);
    }

    @Override
    public String findContentDetailsXmlById(Integer id) {
        return this.findContentDetailsById(id).getXmlContent();
    }

    @Override
    public Map<String, Object> findContentDetailsMapById(Integer id) throws Exception {
        HashMap<String, Object> root = new HashMap<String, Object>();
        String xmlContent = this.findContentDetailsXmlById(id);
        StringReader reader = new StringReader(xmlContent);
        InputSource inputSource = new InputSource((Reader)reader);
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        Document doc = null;
        try {
            DocumentBuilder db = dbf.newDocumentBuilder();
            doc = db.parse(inputSource);
        }
        catch (Exception e) {
            LOG.error((Object)"Parse exception. ", (Throwable)e);
            throw e;
        }
        Element rootElm = doc.getDocumentElement();
        NodeList nodeLst = rootElm.getChildNodes();
        for (int s = 0; s < nodeLst.getLength(); ++s) {
            Node fstNode = nodeLst.item(s);
            if (fstNode.getNodeType() != 1) continue;
            Element fstElmnt = (Element)fstNode;
            String elName = fstNode.getNodeName();
            NodeList nl = fstElmnt.getChildNodes();
            Node dataNode = nl.item(0);
            if (dataNode == null) continue;
            String nodeData = dataNode.getNodeValue();
            if (elName.contains("64")) {
                try {
                    root.put(elName, new String(Base64.decodeBase64((byte[])nodeData.getBytes()), "UTF-8"));
                    continue;
                }
                catch (Exception e) {
                    LOG.error((Object)"Error during decode. ", (Throwable)e);
                    throw e;
                }
            }
            if (nodeData.contains("<![CDATA[")) {
                nodeData.replace("<![CDATA[", "");
                nodeData.replace("]]>", "");
                root.put(elName, nodeData);
                continue;
            }
            root.put(elName, nodeData);
        }
        return root;
    }

    @Override
    public List<ContentXmlData> findContentDetailsListById(Integer id) throws Exception {
        Map<String, Object> map = this.findContentDetailsMapById(id);
        ArrayList<ContentXmlData> xmlDataList = new ArrayList<ContentXmlData>();
        Iterator<String> itr = map.keySet().iterator();
        while (itr.hasNext()) {
            ContentXmlData xmlData = new ContentXmlData();
            String name = itr.next();
            xmlData.setName(name);
            xmlData.setData(map.get(name));
            xmlDataList.add(xmlData);
        }
        return xmlDataList;
    }

    @Override
    public List<ContentDetails> findContentDetails(String sandbox, String contentType, Map<String, Object> mvelParameters) {
        return this.findContentDetails(sandbox, contentType, mvelParameters, SystemTime.asDate());
    }

    @Override
    public List<ContentDetails> findContentDetails(String sandbox, String contentType, Map<String, Object> mvelParameters, Date displayDate) {
        List<Content> contents = this.contentDao.readContentSpecified(sandbox, contentType, displayDate);
        ArrayList<Integer> contentIds = new ArrayList<Integer>();
        for (Content content : contents) {
            if (mvelParameters != null && content.getDisplayRule() != null && content.getDisplayRule() != "") {
                if (this.executeExpression(content.getDisplayRule(), mvelParameters).booleanValue()) continue;
                contentIds.add(content.getId());
                continue;
            }
            contentIds.add(content.getId());
        }
        if (contentIds.size() > 0) {
            return this.contentDetailsDao.readContentDetailsByOrderedIds(contentIds);
        }
        return new ArrayList<ContentDetails>();
    }

    @Override
    public List<Content> findContent(String sandbox, String contentType, Map<String, Object> mvelParameters, Date displayDate) {
        return this.contentDao.readContentSpecified(sandbox, contentType, displayDate);
    }

    @Override
    public String renderedContentDetails(String styleSheetString, List<ContentDetails> contentDetails) throws Exception {
        return this.renderedContentDetails(styleSheetString, contentDetails, -1);
    }

    @Override
    public String renderedContentDetails(String styleSheetString, List<ContentDetails> contentDetails, int rowCount) throws Exception {
        int maxCount = rowCount > -1 && contentDetails.size() > 0 ? rowCount : contentDetails.size();
        StringWriter resultWriter = new StringWriter();
        StreamResult result = new StreamResult(resultWriter);
        Source styleSheetSource = this.getSource(styleSheetString);
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        Transformer transformer = transformerFactory.newTransformer(styleSheetSource);
        for (int i = 0; i < maxCount; ++i) {
            ContentDetails contentDetail = contentDetails.get(i);
            Source xmlSource = this.getSource(contentDetail.getXmlContent());
            try {
                transformer.transform(xmlSource, result);
                continue;
            }
            catch (Exception e) {
                LOG.error((Object)"Error during transformation. ", (Throwable)e);
                throw e;
            }
        }
        return StringEscapeUtils.unescapeXml((String)((Object)resultWriter).toString());
    }

    @Override
    public String renderedContent(String styleSheetString, List<Content> contentList, int rowCount) throws Exception {
        int maxCount = rowCount > -1 && contentList.size() > 0 ? rowCount : contentList.size();
        StringWriter resultWriter = new StringWriter();
        StreamResult result = new StreamResult(resultWriter);
        Source styleSheetSource = this.getSource(styleSheetString);
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        Transformer transformer = transformerFactory.newTransformer(styleSheetSource);
        ContentComparator cntntCompare = new ContentComparator();
        Collections.sort(contentList, cntntCompare);
        for (int i = 0; i < maxCount; ++i) {
            ContentDetails contentDetail = this.findContentDetailsById(contentList.get(i).getId());
            Source xmlSource = this.getSource(contentDetail.getXmlContent());
            try {
                transformer.transform(xmlSource, result);
                continue;
            }
            catch (Exception e) {
                LOG.error((Object)"Error during transformation. ", (Throwable)e);
                throw e;
            }
        }
        return StringEscapeUtils.unescapeXml((String)((Object)resultWriter).toString());
    }

    protected Boolean executeExpression(String expression, Map<String, Object> vars) {
        Serializable exp = (Serializable)EXPRESSION_CACHE.get((Object)expression);
        if (exp == null) {
            ParserContext context = new ParserContext();
            exp = MVEL.compileExpression((String)expression.toString(), (ParserContext)context);
        }
        EXPRESSION_CACHE.put((Object)expression, (Object)exp);
        return (Boolean)MVEL.executeExpression((Object)exp, vars);
    }

    private Source getSource(String sourceString) {
        StringReader styleSheetSourceReader = new StringReader(sourceString);
        InputSource inputStyleSheetSource = new InputSource((Reader)styleSheetSourceReader);
        return new SAXSource(inputStyleSheetSource);
    }

    @Override
    public void approveContent(List<Integer> contentIds, String sandboxName, String username) {
        List<Content> contentList = this.contentDao.readContentByIdsAndSandbox(contentIds, sandboxName);
        List<Content> stageContentList = this.contentDao.readStagedContent();
        ArrayList<Content> deleteList = new ArrayList<Content>();
        ArrayList<Content> saveList = new ArrayList<Content>();
        for (Content content : contentList) {
            for (Content stageContent : stageContentList) {
                if (!stageContent.getTitle().equals(content.getTitle()) || !stageContent.getContentType().equals(content.getContentType())) continue;
                deleteList.add(stageContent);
            }
            content.setSandbox(null);
            content.setApprovedBy(username);
            content.setApprovedDate(SystemTime.asDate());
            saveList.add(content);
        }
        this.contentDao.saveContent(saveList);
        this.contentDao.delete(deleteList);
    }

    @Override
    public List<Content> checkoutContentToSandbox(List<Integer> contentIds, String sandboxName) {
        List<Content> contentList = this.contentDao.readContentByIdsAndSandbox(contentIds, null);
        List<ContentDetails> contentDetailsList = this.contentDetailsDao.readContentDetailsByOrderedIds(contentIds);
        ArrayList<Content> newContentList = new ArrayList<Content>();
        block0: for (Content content : contentList) {
            ContentImpl newContent = new ContentImpl(content, sandboxName, false);
            Content createdContent = this.contentDao.saveContent(newContent);
            newContentList.add(createdContent);
            for (ContentDetails contentDetails : contentDetailsList) {
                if (!contentDetails.getId().equals(content.getId())) continue;
                ContentDetailsImpl newContentDetails = new ContentDetailsImpl(contentDetails, createdContent.getId());
                this.contentDetailsDao.save(newContentDetails);
                continue block0;
            }
        }
        return newContentList;
    }

    @Override
    public List<Content> readContentAwaitingApproval() {
        return this.contentDao.readContentAwaitingApproval();
    }

    @Override
    public List<Content> readContentForSandbox(String sandbox) {
        List<Content> list = this.contentDao.readContentBySandbox(sandbox);
        return list;
    }

    @Override
    public List<Content> readContentForSandboxAndType(String sandbox, String contentType) {
        List<Content> list = this.contentDao.readContentBySandboxAndType(sandbox, contentType);
        return list;
    }

    @Override
    public void rejectContent(List<Integer> contentIds, String sandbox, String username) {
        List<Content> contentList = this.contentDao.readContentByIdsAndSandbox(contentIds, sandbox);
        for (Content content : contentList) {
            content.setRejectedBy(username);
            content.setRejectedDate(SystemTime.asDate());
            content.setSandbox(content.getSubmittedBy());
            content.setSubmittedBy(null);
            content.setSubmittedDate(null);
        }
        this.contentDao.saveContent(contentList);
    }

    @Override
    public void removeContentFromSandbox(List<Integer> contentIds, String sandbox) {
        if (sandbox != null) {
            List<Content> contentList = this.contentDao.readContentByIdsAndSandbox(contentIds, sandbox);
            this.contentDao.delete(contentList);
        }
    }

    @Override
    public void submitContentFromSandbox(List<Integer> contentIds, String sandboxName, String username, String note) {
        List<Content> contentList = this.contentDao.readContentByIdsAndSandbox(contentIds, sandboxName);
        for (Content content : contentList) {
            content.setSubmittedBy(username);
            content.setSubmittedDate(SystemTime.asDate());
            content.setNote(note);
            content.setSandbox("AwaitingApproval_" + username + "_" + SystemTime.asDate().getTime());
        }
        this.contentDao.saveContent(contentList);
    }

    @Override
    public Content saveContent(Content content, List<ContentXmlData> details) {
        String xmlContent;
        ContentDetails contentDetails = this.contentDetailsDao.readContentDetailsById(content.getId());
        if (contentDetails == null) {
            contentDetails = new ContentDetailsImpl();
        }
        if ((xmlContent = this.constructXmlContent(details)) != null) {
            contentDetails.setXmlContent(xmlContent);
            try {
                contentDetails.setContentHash(this.SHA1(xmlContent));
            }
            catch (NoSuchAlgorithmException e) {
                LOG.error((Object)"NoSuchAlgorithmException", (Throwable)e);
            }
            catch (UnsupportedEncodingException e) {
                LOG.error((Object)"UnsupportedEncodingException", (Throwable)e);
            }
            Content saved = this.contentDao.saveContent(content);
            contentDetails.setId(saved.getId());
            this.contentDetailsDao.save(contentDetails);
        }
        return null;
    }

    @Override
    public List<ContentPageInfo> readAllContentPageInfos() {
        Map<Integer, String> parentMap = this.constructParentUrlMap();
        if (parentMap != null) {
            ArrayList<ContentPageInfo> pageInfoList = new ArrayList<ContentPageInfo>();
            for (Integer key : parentMap.keySet()) {
                ContentPageInfo pageInfo = new ContentPageInfo();
                pageInfo.setId(key);
                pageInfo.setFullUrl(parentMap.get(key));
                pageInfoList.add(pageInfo);
            }
            return pageInfoList;
        }
        return null;
    }

    @Override
    public Map<Integer, String> constructParentUrlMap() {
        List<Content> content = this.contentDao.readAllContent();
        if (content != null) {
            HashMap<Integer, Content> idContentMap = new HashMap<Integer, Content>();
            HashMap<Integer, String> parentUrlMap = new HashMap<Integer, String>();
            for (Content c : content) {
                idContentMap.put(c.getId(), c);
            }
            for (Content c : content) {
                String fullPath = this.constructFullPath(c.getUrlTitle(), c.getParentContentId(), idContentMap);
                parentUrlMap.put(c.getId(), fullPath);
            }
            return parentUrlMap;
        }
        return null;
    }

    private String constructFullPath(String path, Integer parentId, Map<Integer, Content> idContentMap) {
        if (idContentMap.get(parentId) != null && parentId != 0) {
            path = idContentMap.get(parentId).getUrlTitle() + "/" + path;
            this.constructFullPath(path, idContentMap.get(parentId).getParentContentId(), idContentMap);
        }
        return path;
    }

    private String constructXmlContent(List<ContentXmlData> details) {
        if (details != null) {
            String xml = "";
            xml = xml + "<?xml version=\"1.0\" encoding=\"UTF-8\"?><content>";
            for (ContentXmlData data : details) {
                xml = xml + "<" + data.getName() + ">";
                xml = xml + "<![CDATA[";
                xml = xml + data.getData().toString();
                xml = xml + "]]>";
                xml = xml + "</" + data.getName() + ">";
            }
            xml = xml + "</content>";
            return xml;
        }
        return null;
    }

    private String convertToHex(byte[] data) {
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < data.length; ++i) {
            int halfbyte = data[i] >>> 4 & 0xF;
            int two_halfs = 0;
            do {
                if (0 <= halfbyte && halfbyte <= 9) {
                    buf.append((char)(48 + halfbyte));
                } else {
                    buf.append((char)(97 + (halfbyte - 10)));
                }
                halfbyte = data[i] & 0xF;
            } while (two_halfs++ < 1);
        }
        return buf.toString();
    }

    private String SHA1(String text) throws NoSuchAlgorithmException, UnsupportedEncodingException {
        MessageDigest md = MessageDigest.getInstance("SHA-1");
        byte[] sha1hash = new byte[40];
        md.update(text.getBytes("iso-8859-1"), 0, text.length());
        sha1hash = md.digest();
        return this.convertToHex(sha1hash);
    }

    public class ContentComparator
    implements Comparator<Content> {
        @Override
        public int compare(Content o1, Content o2) {
            if (o1.getPriority() < o2.getPriority()) {
                return -1;
            }
            if (o1.getPriority() > o2.getPriority()) {
                return 1;
            }
            return 0;
        }
    }
}

