/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.core.offer.service.discount.domain;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import org.broadleafcommerce.core.offer.domain.CandidateFulfillmentGroupOffer;
import org.broadleafcommerce.core.offer.domain.FulfillmentGroupAdjustment;
import org.broadleafcommerce.core.offer.service.discount.domain.PromotableCandidateFulfillmentGroupOffer;
import org.broadleafcommerce.core.offer.service.discount.domain.PromotableFulfillmentGroup;
import org.broadleafcommerce.core.offer.service.discount.domain.PromotableFulfillmentGroupAdjustment;
import org.broadleafcommerce.core.offer.service.discount.domain.PromotableItemFactory;
import org.broadleafcommerce.core.offer.service.discount.domain.PromotableOrder;
import org.broadleafcommerce.core.offer.service.discount.domain.PromotableOrderItem;
import org.broadleafcommerce.core.order.domain.BundleOrderItemImpl;
import org.broadleafcommerce.core.order.domain.DiscreteOrderItem;
import org.broadleafcommerce.core.order.domain.FulfillmentGroup;
import org.broadleafcommerce.core.order.domain.FulfillmentGroupFee;
import org.broadleafcommerce.core.order.domain.FulfillmentGroupItem;
import org.broadleafcommerce.core.order.domain.Order;
import org.broadleafcommerce.core.order.domain.OrderItem;
import org.broadleafcommerce.core.order.domain.PersonalMessage;
import org.broadleafcommerce.core.order.service.manipulation.DiscreteOrderItemDecorator;
import org.broadleafcommerce.core.order.service.type.FulfillmentGroupStatusType;
import org.broadleafcommerce.core.order.service.type.FulfillmentGroupType;
import org.broadleafcommerce.money.Money;
import org.broadleafcommerce.profile.core.domain.Address;
import org.broadleafcommerce.profile.core.domain.Phone;

public class PromotableFulfillmentGroupImpl
implements PromotableFulfillmentGroup {
    private static final long serialVersionUID = 1L;
    protected BigDecimal adjustmentPrice;
    protected FulfillmentGroup delegate;
    protected PromotableOrder order;
    protected PromotableItemFactory itemFactory;

    public PromotableFulfillmentGroupImpl(FulfillmentGroup fulfillmentGroup, PromotableOrder order, PromotableItemFactory itemFactory) {
        this.delegate = fulfillmentGroup;
        this.order = order;
        this.itemFactory = itemFactory;
    }

    @Override
    public void reset() {
        this.delegate = null;
    }

    @Override
    public FulfillmentGroup getDelegate() {
        return this.delegate;
    }

    @Override
    public List<PromotableOrderItem> getDiscountableDiscreteOrderItems() {
        ArrayList<PromotableOrderItem> discreteOrderItems = new ArrayList<PromotableOrderItem>();
        for (FulfillmentGroupItem fgItem : this.delegate.getFulfillmentGroupItems()) {
            OrderItem orderItem = fgItem.getOrderItem();
            if (orderItem instanceof BundleOrderItemImpl) {
                BundleOrderItemImpl bundleOrderItem = (BundleOrderItemImpl)orderItem;
                for (DiscreteOrderItem discreteOrderItem : bundleOrderItem.getDiscreteOrderItems()) {
                    if (!discreteOrderItem.getSku().isDiscountable().booleanValue()) continue;
                    discreteOrderItems.add(this.itemFactory.createPromotableOrderItem(discreteOrderItem, this.order));
                }
                continue;
            }
            DiscreteOrderItem discreteOrderItem = (DiscreteOrderItem)orderItem;
            if (!discreteOrderItem.getSku().isDiscountable().booleanValue()) continue;
            discreteOrderItems.add(this.itemFactory.createPromotableOrderItem(new DiscreteOrderItemDecorator(discreteOrderItem, fgItem.getQuantity()), this.order));
        }
        return discreteOrderItems;
    }

    @Override
    public void addFulfillmentGroupAdjustment(PromotableFulfillmentGroupAdjustment fulfillmentGroupAdjustment) {
        if (this.delegate.getFulfillmentGroupAdjustments().size() == 0) {
            this.adjustmentPrice = this.delegate.getRetailShippingPrice().getAmount();
        }
        this.adjustmentPrice = this.adjustmentPrice.subtract(fulfillmentGroupAdjustment.getValue().getAmount());
        this.delegate.getFulfillmentGroupAdjustments().add(fulfillmentGroupAdjustment.getDelegate());
        this.order.resetTotalitarianOfferApplied();
    }

    @Override
    public void removeAllAdjustments() {
        this.delegate.removeAllAdjustments();
        this.order.resetTotalitarianOfferApplied();
        this.adjustmentPrice = null;
    }

    @Override
    public Money getPriceBeforeAdjustments(boolean allowSalesPrice) {
        Money currentPrice = this.delegate.getSaleShippingPrice() != null && allowSalesPrice ? this.delegate.getSaleShippingPrice() : this.delegate.getRetailShippingPrice();
        return currentPrice;
    }

    @Override
    public Money getAdjustmentPrice() {
        return this.adjustmentPrice == null ? null : new Money(this.adjustmentPrice, this.delegate.getRetailShippingPrice().getCurrency(), this.adjustmentPrice.scale() == 0 ? 2 : this.adjustmentPrice.scale());
    }

    @Override
    public void setAdjustmentPrice(Money adjustmentPrice) {
        this.adjustmentPrice = Money.toAmount((Money)adjustmentPrice);
    }

    @Override
    public Money getRetailShippingPrice() {
        return this.delegate.getRetailShippingPrice();
    }

    @Override
    public Money getSaleShippingPrice() {
        return this.delegate.getSaleShippingPrice();
    }

    @Override
    public void removeAllCandidateOffers() {
        this.delegate.removeAllCandidateOffers();
    }

    @Override
    public Money getShippingPrice() {
        return this.delegate.getShippingPrice();
    }

    @Override
    public void setShippingPrice(Money shippingPrice) {
        this.delegate.setShippingPrice(shippingPrice);
    }

    @Override
    public void addCandidateFulfillmentGroupOffer(PromotableCandidateFulfillmentGroupOffer candidateOffer) {
        this.delegate.addCandidateFulfillmentGroupOffer(candidateOffer.getDelegate());
    }

    public Long getId() {
        return this.delegate.getId();
    }

    public void setId(Long id) {
        this.delegate.setId(id);
    }

    public Order getOrder() {
        return this.delegate.getOrder();
    }

    public void setOrder(Order order) {
        this.delegate.setOrder(order);
    }

    public Address getAddress() {
        return this.delegate.getAddress();
    }

    public void setAddress(Address address) {
        this.delegate.setAddress(address);
    }

    public Phone getPhone() {
        return this.delegate.getPhone();
    }

    public void setPhone(Phone phone) {
        this.delegate.setPhone(phone);
    }

    public List<FulfillmentGroupItem> getFulfillmentGroupItems() {
        return this.delegate.getFulfillmentGroupItems();
    }

    public void setFulfillmentGroupItems(List<FulfillmentGroupItem> fulfillmentGroupItems) {
        this.delegate.setFulfillmentGroupItems(fulfillmentGroupItems);
    }

    public void addFulfillmentGroupItem(FulfillmentGroupItem fulfillmentGroupItem) {
        this.delegate.addFulfillmentGroupItem(fulfillmentGroupItem);
    }

    public String getMethod() {
        return this.delegate.getMethod();
    }

    public void setMethod(String fulfillmentMethod) {
        this.delegate.setMethod(fulfillmentMethod);
    }

    public String getReferenceNumber() {
        return this.delegate.getReferenceNumber();
    }

    public void setReferenceNumber(String referenceNumber) {
        this.delegate.setReferenceNumber(referenceNumber);
    }

    public FulfillmentGroupType getType() {
        return this.delegate.getType();
    }

    public void setType(FulfillmentGroupType type) {
        this.delegate.setType(type);
    }

    public List<CandidateFulfillmentGroupOffer> getCandidateFulfillmentGroupOffers() {
        return this.delegate.getCandidateFulfillmentGroupOffers();
    }

    public void setCandidateFulfillmentGroupOffer(List<CandidateFulfillmentGroupOffer> candidateOffers) {
        this.delegate.setCandidateFulfillmentGroupOffer(candidateOffers);
    }

    public List<FulfillmentGroupAdjustment> getFulfillmentGroupAdjustments() {
        return this.delegate.getFulfillmentGroupAdjustments();
    }

    public void setFulfillmentGroupAdjustments(List<FulfillmentGroupAdjustment> fulfillmentGroupAdjustments) {
        this.delegate.setFulfillmentGroupAdjustments(fulfillmentGroupAdjustments);
    }

    public Money getCityTax() {
        return this.delegate.getCityTax();
    }

    public void setCityTax(Money cityTax) {
        this.delegate.setCityTax(cityTax);
    }

    public Money getCountyTax() {
        return this.delegate.getCountyTax();
    }

    public void setCountyTax(Money countyTax) {
        this.delegate.setCountyTax(countyTax);
    }

    public Money getStateTax() {
        return this.delegate.getStateTax();
    }

    public void setStateTax(Money stateTax) {
        this.delegate.setStateTax(stateTax);
    }

    public Money getDistrictTax() {
        return this.delegate.getDistrictTax();
    }

    public void setDistrictTax(Money districtTax) {
        this.delegate.setDistrictTax(districtTax);
    }

    public Money getCountryTax() {
        return this.delegate.getCountryTax();
    }

    public void setCountryTax(Money countryTax) {
        this.delegate.setCountryTax(countryTax);
    }

    public Money getTotalTax() {
        return this.delegate.getTotalTax();
    }

    public void setTotalTax(Money totalTax) {
        this.delegate.setTotalTax(totalTax);
    }

    public String getDeliveryInstruction() {
        return this.delegate.getDeliveryInstruction();
    }

    public void setDeliveryInstruction(String deliveryInstruction) {
        this.delegate.setDeliveryInstruction(deliveryInstruction);
    }

    public PersonalMessage getPersonalMessage() {
        return this.delegate.getPersonalMessage();
    }

    public void setPersonalMessage(PersonalMessage personalMessage) {
        this.delegate.setPersonalMessage(personalMessage);
    }

    public boolean isPrimary() {
        return this.delegate.isPrimary();
    }

    public void setPrimary(boolean primary) {
        this.delegate.setPrimary(primary);
    }

    public Money getMerchandiseTotal() {
        return this.delegate.getMerchandiseTotal();
    }

    public void setMerchandiseTotal(Money merchandiseTotal) {
        this.delegate.setMerchandiseTotal(merchandiseTotal);
    }

    public Money getTotal() {
        return this.delegate.getTotal();
    }

    public void setTotal(Money orderTotal) {
        this.delegate.setTotal(orderTotal);
    }

    public FulfillmentGroupStatusType getStatus() {
        return this.delegate.getStatus();
    }

    public List<FulfillmentGroupFee> getFulfillmentGroupFees() {
        return this.delegate.getFulfillmentGroupFees();
    }

    public void setFulfillmentGroupFees(List<FulfillmentGroupFee> fulfillmentGroupFees) {
        this.delegate.setFulfillmentGroupFees(fulfillmentGroupFees);
    }

    public void addFulfillmentGroupFee(FulfillmentGroupFee fulfillmentGroupFee) {
        this.delegate.addFulfillmentGroupFee(fulfillmentGroupFee);
    }

    public void removeAllFulfillmentGroupFees() {
        this.delegate.removeAllFulfillmentGroupFees();
    }

    public Boolean isShippingPriceTaxable() {
        return this.delegate.isShippingPriceTaxable();
    }

    public void setIsShippingPriceTaxable(Boolean isShippingPriceTaxable) {
        this.delegate.setIsShippingPriceTaxable(isShippingPriceTaxable);
    }

    public String getService() {
        return this.delegate.getService();
    }

    public void setService(String service) {
        this.delegate.setService(service);
    }

    public List<DiscreteOrderItem> getDiscreteOrderItems() {
        return this.delegate.getDiscreteOrderItems();
    }

    public Money getFulfillmentGroupAdjustmentsValue() {
        return this.delegate.getFulfillmentGroupAdjustmentsValue();
    }
}

