/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.core.catalog.service.dynamic;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import org.broadleafcommerce.core.catalog.domain.Sku;
import org.broadleafcommerce.money.Money;

public class DefaultDynamicSkuPricingInvocationHandler
implements InvocationHandler {
    private Sku delegate;
    private Money retailPrice;
    private Money salePrice;

    public DefaultDynamicSkuPricingInvocationHandler(Sku sku) {
        this.delegate = sku;
        try {
            Field retail = this.getSingleField(this.delegate.getClass(), "retailPrice");
            retail.setAccessible(true);
            Object retailVal = retail.get(this.delegate);
            this.retailPrice = retailVal == null ? null : new Money((BigDecimal)retailVal);
            Field sale = this.getSingleField(this.delegate.getClass(), "salePrice");
            sale.setAccessible(true);
            Object saleVal = sale.get(this.delegate);
            this.salePrice = saleVal == null ? null : new Money((BigDecimal)saleVal);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private Field getSingleField(Class<?> clazz, String fieldName) throws IllegalStateException {
        try {
            return clazz.getDeclaredField(fieldName);
        }
        catch (NoSuchFieldException nsf) {
            if (clazz.getSuperclass() != null) {
                return this.getSingleField(clazz.getSuperclass(), fieldName);
            }
            return null;
        }
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        if (method.getName().equals("getRetailPrice")) {
            return this.retailPrice;
        }
        if (method.getName().equals("getSalePrice")) {
            return this.salePrice;
        }
        return method.invoke((Object)this.delegate, args);
    }

    public void reset() {
        this.delegate = null;
        this.retailPrice = null;
        this.salePrice = null;
    }
}

