/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.core.catalog.domain;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import org.broadleafcommerce.core.catalog.domain.Product;
import org.broadleafcommerce.core.catalog.domain.ProductImpl;
import org.broadleafcommerce.core.catalog.domain.RelatedProduct;
import org.broadleafcommerce.presentation.AdminPresentation;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.hibernate.annotations.GenericGenerator;
import org.hibernate.annotations.Index;
import org.hibernate.annotations.Parameter;

@Entity
@Inheritance(strategy=InheritanceType.JOINED)
@Table(name="BLC_PRODUCT_UP_SALE")
@Cache(usage=CacheConcurrencyStrategy.READ_WRITE, region="blStandardElements")
public class UpSaleProductImpl
implements RelatedProduct {
    private static final long serialVersionUID = 1L;
    @Id
    @GeneratedValue(generator="UpSaleProductId")
    @GenericGenerator(name="UpSaleProductId", strategy="org.broadleafcommerce.persistence.IdOverrideTableGenerator", parameters={@Parameter(name="table_name", value="SEQUENCE_GENERATOR"), @Parameter(name="segment_column_name", value="ID_NAME"), @Parameter(name="value_column_name", value="ID_VAL"), @Parameter(name="segment_value", value="UpSaleProductImpl"), @Parameter(name="increment_size", value="50"), @Parameter(name="entity_name", value="org.broadleafcommerce.core.catalog.domain.UpSaleProductImpl")})
    @Column(name="UP_SALE_PRODUCT_ID")
    private Long id;
    @Column(name="PROMOTION_MESSAGE")
    @AdminPresentation(friendlyName="Upsale Promotion Message", largeEntry=true)
    private String promotionMessage;
    @Column(name="SEQUENCE")
    private Long sequence;
    @ManyToOne(targetEntity=ProductImpl.class)
    @JoinColumn(name="PRODUCT_ID")
    @Index(name="UPSALE_PRODUCT_INDEX", columnNames={"PRODUCT_ID"})
    private Product product = new ProductImpl();
    @ManyToOne(targetEntity=ProductImpl.class)
    @JoinColumn(name="RELATED_SALE_PRODUCT_ID", referencedColumnName="PRODUCT_ID")
    @Index(name="UPSALE_RELATED_INDEX", columnNames={"RELATED_SALE_PRODUCT_ID"})
    private Product relatedSaleProduct = new ProductImpl();

    @Override
    public Long getId() {
        return this.id;
    }

    @Override
    public void setId(Long id) {
        this.id = id;
    }

    @Override
    public String getPromotionMessage() {
        return this.promotionMessage;
    }

    @Override
    public void setPromotionMessage(String promotionMessage) {
        this.promotionMessage = promotionMessage;
    }

    @Override
    public Long getSequence() {
        return this.sequence;
    }

    @Override
    public void setSequence(Long sequence) {
        this.sequence = sequence;
    }

    @Override
    public Product getProduct() {
        return this.product;
    }

    @Override
    public Product getRelatedProduct() {
        return this.relatedSaleProduct;
    }

    @Override
    public void setProduct(Product product) {
        this.product = product;
    }

    @Override
    public void setRelatedProduct(Product relatedSaleProduct) {
        this.relatedSaleProduct = relatedSaleProduct;
    }
}

