/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.core.payment.service;

import javax.annotation.Resource;
import org.broadleafcommerce.core.payment.domain.PaymentInfo;
import org.broadleafcommerce.core.payment.domain.PaymentLog;
import org.broadleafcommerce.core.payment.domain.PaymentResponseItem;
import org.broadleafcommerce.core.payment.service.PaymentContext;
import org.broadleafcommerce.core.payment.service.PaymentInfoService;
import org.broadleafcommerce.core.payment.service.PaymentService;
import org.broadleafcommerce.core.payment.service.exception.PaymentException;
import org.broadleafcommerce.core.payment.service.exception.PaymentProcessorException;
import org.broadleafcommerce.core.payment.service.module.PaymentModule;
import org.broadleafcommerce.core.payment.service.type.PaymentInfoType;
import org.broadleafcommerce.core.payment.service.type.PaymentLogEventType;
import org.broadleafcommerce.core.payment.service.type.TransactionType;
import org.broadleafcommerce.openadmin.time.SystemTime;

public class PaymentServiceImpl
implements PaymentService {
    protected PaymentModule paymentModule;
    @Resource(name="blPaymentInfoService")
    protected PaymentInfoService paymentInfoService;

    public PaymentModule getPaymentModule() {
        return this.paymentModule;
    }

    public void setPaymentModule(PaymentModule paymentModule) {
        this.paymentModule = paymentModule;
    }

    @Override
    public PaymentResponseItem authorize(PaymentContext paymentContext) throws PaymentException {
        this.logPaymentStartEvent(paymentContext, TransactionType.AUTHORIZE);
        PaymentResponseItem response = null;
        PaymentException paymentException = null;
        try {
            response = this.paymentModule.authorize(paymentContext);
        }
        catch (PaymentException e) {
            if (e instanceof PaymentProcessorException) {
                response = ((PaymentProcessorException)e).getPaymentResponseItem();
            }
            paymentException = e;
            throw e;
        }
        finally {
            this.logResponseItem(paymentContext, response, TransactionType.AUTHORIZE);
            this.logPaymentFinishEvent(paymentContext, TransactionType.AUTHORIZE, paymentException);
        }
        return response;
    }

    @Override
    public PaymentResponseItem authorizeAndDebit(PaymentContext paymentContext) throws PaymentException {
        this.logPaymentStartEvent(paymentContext, TransactionType.AUTHORIZEANDDEBIT);
        PaymentResponseItem response = null;
        PaymentException paymentException = null;
        try {
            response = this.paymentModule.authorizeAndDebit(paymentContext);
        }
        catch (PaymentException e) {
            if (e instanceof PaymentProcessorException) {
                response = ((PaymentProcessorException)e).getPaymentResponseItem();
            }
            paymentException = e;
            throw e;
        }
        finally {
            this.logResponseItem(paymentContext, response, TransactionType.AUTHORIZEANDDEBIT);
            this.logPaymentFinishEvent(paymentContext, TransactionType.AUTHORIZEANDDEBIT, paymentException);
        }
        return response;
    }

    @Override
    public PaymentResponseItem balance(PaymentContext paymentContext) throws PaymentException {
        this.logPaymentStartEvent(paymentContext, TransactionType.BALANCE);
        PaymentResponseItem response = null;
        PaymentException paymentException = null;
        try {
            response = this.paymentModule.balance(paymentContext);
        }
        catch (PaymentException e) {
            if (e instanceof PaymentProcessorException) {
                response = ((PaymentProcessorException)e).getPaymentResponseItem();
            }
            paymentException = e;
            throw e;
        }
        finally {
            this.logResponseItem(paymentContext, response, TransactionType.BALANCE);
            this.logPaymentFinishEvent(paymentContext, TransactionType.BALANCE, paymentException);
        }
        return response;
    }

    @Override
    public PaymentResponseItem credit(PaymentContext paymentContext) throws PaymentException {
        this.logPaymentStartEvent(paymentContext, TransactionType.CREDIT);
        PaymentResponseItem response = null;
        PaymentException paymentException = null;
        try {
            response = this.paymentModule.credit(paymentContext);
        }
        catch (PaymentException e) {
            if (e instanceof PaymentProcessorException) {
                response = ((PaymentProcessorException)e).getPaymentResponseItem();
            }
            paymentException = e;
            throw e;
        }
        finally {
            this.logResponseItem(paymentContext, response, TransactionType.CREDIT);
            this.logPaymentFinishEvent(paymentContext, TransactionType.CREDIT, paymentException);
        }
        return response;
    }

    @Override
    public PaymentResponseItem debit(PaymentContext paymentContext) throws PaymentException {
        this.logPaymentStartEvent(paymentContext, TransactionType.DEBIT);
        PaymentResponseItem response = null;
        PaymentException paymentException = null;
        try {
            response = this.paymentModule.debit(paymentContext);
        }
        catch (PaymentException e) {
            if (e instanceof PaymentProcessorException) {
                response = ((PaymentProcessorException)e).getPaymentResponseItem();
            }
            paymentException = e;
            throw e;
        }
        finally {
            this.logResponseItem(paymentContext, response, TransactionType.DEBIT);
            this.logPaymentFinishEvent(paymentContext, TransactionType.DEBIT, paymentException);
        }
        return response;
    }

    @Override
    public PaymentResponseItem voidPayment(PaymentContext paymentContext) throws PaymentException {
        this.logPaymentStartEvent(paymentContext, TransactionType.VOIDPAYMENT);
        PaymentResponseItem response = null;
        PaymentException paymentException = null;
        try {
            response = this.paymentModule.voidPayment(paymentContext);
        }
        catch (PaymentException e) {
            if (e instanceof PaymentProcessorException) {
                response = ((PaymentProcessorException)e).getPaymentResponseItem();
            }
            paymentException = e;
            throw e;
        }
        finally {
            this.logResponseItem(paymentContext, response, TransactionType.VOIDPAYMENT);
            this.logPaymentFinishEvent(paymentContext, TransactionType.VOIDPAYMENT, paymentException);
        }
        return response;
    }

    @Override
    public PaymentResponseItem reverseAuthorize(PaymentContext paymentContext) throws PaymentException {
        this.logPaymentStartEvent(paymentContext, TransactionType.REVERSEAUTHORIZE);
        PaymentResponseItem response = null;
        PaymentException paymentException = null;
        try {
            response = this.paymentModule.reverseAuthorize(paymentContext);
        }
        catch (PaymentException e) {
            if (e instanceof PaymentProcessorException) {
                response = ((PaymentProcessorException)e).getPaymentResponseItem();
            }
            paymentException = e;
            throw e;
        }
        finally {
            this.logResponseItem(paymentContext, response, TransactionType.REVERSEAUTHORIZE);
            this.logPaymentFinishEvent(paymentContext, TransactionType.REVERSEAUTHORIZE, paymentException);
        }
        return response;
    }

    @Override
    public Boolean isValidCandidate(PaymentInfoType paymentType) {
        return this.paymentModule.isValidCandidate(paymentType);
    }

    protected void logResponseItem(PaymentContext paymentContext, PaymentResponseItem response, TransactionType transactionType) {
        if (response != null) {
            response.setTransactionType(transactionType);
            response.setUserName(paymentContext.getUserName());
            PaymentInfo info = paymentContext.getPaymentInfo();
            if (info != null) {
                response.setPaymentInfoId(info.getId());
                if (info.getOrder() != null && info.getOrder().getCustomer() != null) {
                    response.setCustomer(info.getOrder().getCustomer());
                }
                response.setPaymentInfoReferenceNumber(info.getReferenceNumber());
            }
            this.paymentInfoService.save(response);
        }
    }

    protected void logPaymentStartEvent(PaymentContext paymentContext, TransactionType transactionType) {
        PaymentLog log = this.paymentInfoService.createLog();
        log.setLogType(PaymentLogEventType.START);
        log.setTransactionTimestamp(SystemTime.asDate());
        log.setTransactionSuccess(Boolean.TRUE);
        log.setTransactionType(transactionType);
        log.setUserName(paymentContext.getUserName());
        log.setExceptionMessage(null);
        PaymentInfo info = paymentContext.getPaymentInfo();
        if (info != null) {
            log.setCustomer(info.getOrder().getCustomer());
            log.setPaymentInfoReferenceNumber(info.getReferenceNumber());
            log.setAmountPaid(info.getAmount());
            log.setPaymentInfoId(info.getId());
        }
        this.paymentInfoService.save(log);
    }

    protected void logPaymentFinishEvent(PaymentContext paymentContext, TransactionType transactionType, Exception e) {
        String exceptionMessage;
        PaymentLog log = this.paymentInfoService.createLog();
        log.setLogType(PaymentLogEventType.FINISHED);
        log.setTransactionTimestamp(SystemTime.asDate());
        log.setTransactionSuccess(e == null ? Boolean.TRUE : Boolean.FALSE);
        log.setTransactionType(transactionType);
        log.setUserName(paymentContext.getUserName());
        if (e != null) {
            exceptionMessage = e.getMessage();
            if (exceptionMessage != null) {
                if (exceptionMessage.length() >= 255) {
                    exceptionMessage = exceptionMessage.substring(0, 254);
                }
            } else {
                exceptionMessage = e.getClass().getName();
            }
        } else {
            exceptionMessage = null;
        }
        log.setExceptionMessage(exceptionMessage);
        PaymentInfo info = paymentContext.getPaymentInfo();
        if (info != null) {
            log.setCustomer(info.getOrder().getCustomer());
            log.setPaymentInfoReferenceNumber(info.getReferenceNumber());
            log.setAmountPaid(info.getAmount());
            log.setPaymentInfoId(info.getId());
        }
        this.paymentInfoService.save(log);
    }
}

