/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.core.offer.service.discount.domain;

import java.math.BigDecimal;
import org.broadleafcommerce.core.offer.domain.OrderItemAdjustment;
import org.broadleafcommerce.core.offer.service.discount.domain.PromotableOrderItem;
import org.broadleafcommerce.core.offer.service.discount.domain.PromotableOrderItemAdjustment;
import org.broadleafcommerce.core.offer.service.type.OfferDiscountType;
import org.broadleafcommerce.money.Money;

public class PromotableOrderItemAdjustmentImpl
implements PromotableOrderItemAdjustment {
    private static final long serialVersionUID = 1L;
    protected PromotableOrderItem orderItem;
    protected OrderItemAdjustment delegate;

    public PromotableOrderItemAdjustmentImpl(OrderItemAdjustment orderItemAdjustment, PromotableOrderItem orderItem) {
        this.delegate = orderItemAdjustment;
        this.orderItem = orderItem;
    }

    @Override
    public void reset() {
        this.delegate = null;
    }

    @Override
    public OrderItemAdjustment getDelegate() {
        return this.delegate;
    }

    @Override
    public void computeAdjustmentValues() {
        if (this.delegate.getOffer() != null && this.orderItem != null) {
            Money retailAdjustmentPrice = this.orderItem.getRetailAdjustmentPrice();
            Money salesAdjustmentPrice = this.orderItem.getSaleAdjustmentPrice();
            if (retailAdjustmentPrice == null) {
                retailAdjustmentPrice = this.orderItem.getRetailPrice();
            }
            if (this.delegate.getOrderItem().getIsOnSale() && salesAdjustmentPrice == null) {
                salesAdjustmentPrice = this.orderItem.getSalePrice();
            }
            if (this.delegate.getOffer().getDiscountType().equals(OfferDiscountType.AMOUNT_OFF)) {
                Money amountOff = new Money(this.delegate.getOffer().getValue());
                if (this.delegate.getOffer().getApplyDiscountToSalePrice() && this.delegate.getOrderItem().getIsOnSale()) {
                    if (amountOff.lessThan(salesAdjustmentPrice)) {
                        this.delegate.setSalesPriceValue(amountOff);
                    } else {
                        this.delegate.setSalesPriceValue(salesAdjustmentPrice);
                    }
                } else {
                    this.delegate.setSalesPriceValue(Money.ZERO);
                }
                if (amountOff.lessThan(retailAdjustmentPrice)) {
                    this.delegate.setRetailPriceValue(amountOff);
                } else {
                    this.delegate.setRetailPriceValue(retailAdjustmentPrice);
                }
            }
            if (this.delegate.getOffer().getDiscountType().equals(OfferDiscountType.FIX_PRICE)) {
                Money fixPriceAmount = new Money(this.delegate.getOffer().getValue());
                if (fixPriceAmount.lessThan(retailAdjustmentPrice)) {
                    this.delegate.setRetailPriceValue(retailAdjustmentPrice.subtract(fixPriceAmount));
                } else {
                    this.delegate.setRetailPriceValue(Money.ZERO);
                }
                if (this.delegate.getOffer().getApplyDiscountToSalePrice() && this.delegate.getOrderItem().getIsOnSale()) {
                    if (fixPriceAmount.lessThan(salesAdjustmentPrice)) {
                        this.delegate.setSalesPriceValue(fixPriceAmount);
                    } else {
                        this.delegate.setSalesPriceValue(Money.ZERO);
                    }
                }
            }
            if (this.delegate.getOffer().getDiscountType().equals(OfferDiscountType.PERCENT_OFF)) {
                if (this.delegate.getOffer().getApplyDiscountToSalePrice() && this.delegate.getOrderItem().getIsOnSale()) {
                    this.delegate.setSalesPriceValue(salesAdjustmentPrice.multiply(this.delegate.getOffer().getValue().divide(new BigDecimal("100"))));
                } else {
                    this.delegate.setSalesPriceValue(Money.ZERO);
                }
                this.delegate.setRetailPriceValue(retailAdjustmentPrice.multiply(this.delegate.getOffer().getValue().divide(new BigDecimal("100"))));
            }
        }
    }

    @Override
    public Money getRetailPriceValue() {
        return this.delegate.getRetailPriceValue();
    }

    @Override
    public Money getSalesPriceValue() {
        return this.delegate.getSalesPriceValue();
    }
}

