/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.core.offer.service.discount.domain;

import java.math.BigDecimal;
import org.broadleafcommerce.core.offer.domain.OrderAdjustment;
import org.broadleafcommerce.core.offer.service.discount.domain.PromotableOrder;
import org.broadleafcommerce.core.offer.service.discount.domain.PromotableOrderAdjustment;
import org.broadleafcommerce.core.offer.service.type.OfferDiscountType;
import org.broadleafcommerce.money.Money;

public class PromotableOrderAdjustmentImpl
implements PromotableOrderAdjustment {
    private static final long serialVersionUID = 1L;
    protected OrderAdjustment delegate;
    protected PromotableOrder order;

    public PromotableOrderAdjustmentImpl(OrderAdjustment orderAdjustment, PromotableOrder order) {
        this.delegate = orderAdjustment;
        this.order = order;
    }

    @Override
    public void reset() {
        this.delegate = null;
    }

    @Override
    public OrderAdjustment getDelegate() {
        return this.delegate;
    }

    @Override
    public void computeAdjustmentValue() {
        if (this.delegate.getOffer() != null && this.order != null) {
            Money adjustmentPrice = this.order.getAdjustmentPrice();
            if (adjustmentPrice == null) {
                adjustmentPrice = this.order.getSubTotal();
            }
            if (this.delegate.getOffer().getDiscountType().equals(OfferDiscountType.AMOUNT_OFF)) {
                this.delegate.setValue(new Money(this.delegate.getOffer().getValue()));
            }
            if (this.delegate.getOffer().getDiscountType().equals(OfferDiscountType.FIX_PRICE)) {
                this.delegate.setValue(adjustmentPrice.subtract(new Money(this.delegate.getOffer().getValue())));
            }
            if (this.delegate.getOffer().getDiscountType().equals(OfferDiscountType.PERCENT_OFF)) {
                this.delegate.setValue(adjustmentPrice.multiply(this.delegate.getOffer().getValue().divide(new BigDecimal("100"))));
            }
            if (adjustmentPrice.lessThan(this.delegate.getValue())) {
                this.delegate.setValue(adjustmentPrice);
            }
        }
    }

    @Override
    public Money getValue() {
        if (this.delegate.getValue() == null || this.delegate.getValue().equals((Object)Money.ZERO)) {
            this.computeAdjustmentValue();
        }
        return this.delegate.getValue();
    }
}

