/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.core.workflow;

import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.broadleafcommerce.core.workflow.Activity;
import org.broadleafcommerce.core.workflow.BaseActivity;
import org.broadleafcommerce.core.workflow.BaseProcessor;
import org.broadleafcommerce.core.workflow.ErrorHandler;
import org.broadleafcommerce.core.workflow.ProcessContext;
import org.broadleafcommerce.core.workflow.ProcessContextFactory;
import org.broadleafcommerce.core.workflow.WorkflowException;

public class SequenceProcessor
extends BaseProcessor {
    private static final Log LOG = LogFactory.getLog(SequenceProcessor.class);
    private ProcessContextFactory processContextFactory;

    @Override
    public boolean supports(Activity activity) {
        return activity instanceof BaseActivity;
    }

    @Override
    public ProcessContext doActivities() throws WorkflowException {
        return this.doActivities(null);
    }

    @Override
    public ProcessContext doActivities(Object seedData) throws WorkflowException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)(this.getBeanName() + " processor is running.."));
        }
        List<Activity> activities = this.getActivities();
        ProcessContext context = this.createContext(seedData);
        for (Activity activity : activities) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("running activity:" + activity.getBeanName() + " using arguments:" + context));
            }
            try {
                context = activity.execute(context);
            }
            catch (Throwable th) {
                ErrorHandler errorHandler = activity.getErrorHandler();
                if (errorHandler == null) {
                    LOG.info((Object)"no error handler for this action, run default errorhandler and abort processing ");
                    this.getDefaultErrorHandler().handleError(context, th);
                    break;
                }
                LOG.info((Object)"run error handler and continue");
                errorHandler.handleError(context, th);
            }
            if (!this.processShouldStop(context, activity)) continue;
            break;
        }
        LOG.debug((Object)(this.getBeanName() + " processor is done."));
        return context;
    }

    private boolean processShouldStop(ProcessContext context, Activity activity) {
        if (context != null && context.isStopped()) {
            LOG.info((Object)("Interrupted workflow as requested by:" + activity.getBeanName()));
            return true;
        }
        return false;
    }

    private ProcessContext createContext(Object seedData) throws WorkflowException {
        return this.processContextFactory.createContext(seedData);
    }

    @Override
    public void setProcessContextFactory(ProcessContextFactory processContextFactory) {
        this.processContextFactory = processContextFactory;
    }
}

