/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.core.util.dao;

import java.util.List;
import javax.annotation.Resource;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;
import org.broadleafcommerce.core.util.dao.CodeTypeDao;
import org.broadleafcommerce.core.util.domain.CodeType;
import org.broadleafcommerce.persistence.EntityConfiguration;
import org.springframework.stereotype.Repository;

@Repository(value="blCodeTypeDao")
public class CodeTypeDaoImpl
implements CodeTypeDao {
    @PersistenceContext(unitName="blPU")
    protected EntityManager em;
    @Resource(name="blEntityConfiguration")
    protected EntityConfiguration entityConfiguration;

    @Override
    public CodeType create() {
        return (CodeType)this.entityConfiguration.createEntityInstance(CodeType.class.getName());
    }

    @Override
    public List<CodeType> readAllCodeTypes() {
        Query query = this.em.createNamedQuery("BC_READ_ALL_CODE_TYPES");
        return query.getResultList();
    }

    @Override
    public void delete(CodeType codeType) {
        if (!this.em.contains((Object)codeType)) {
            codeType = (CodeType)this.em.find(this.entityConfiguration.lookupEntityClass("org.broadleafcommerce.core.util.domain.CodeType"), (Object)codeType.getId());
        }
        this.em.remove((Object)codeType);
    }

    @Override
    public CodeType readCodeTypeById(Long codeTypeId) {
        return (CodeType)this.em.find(this.entityConfiguration.lookupEntityClass(CodeType.class.getName()), (Object)codeTypeId);
    }

    @Override
    public List<CodeType> readCodeTypeByKey(String key) {
        Query query = this.em.createNamedQuery("BC_READ_CODE_TYPE_BY_KEY");
        query.setParameter("key", (Object)key);
        List result = query.getResultList();
        return result;
    }

    @Override
    public CodeType save(CodeType codeType) {
        if (codeType.getId() == null) {
            this.em.persist((Object)codeType);
        } else {
            codeType = (CodeType)this.em.merge((Object)codeType);
        }
        return codeType;
    }
}

