/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.core.inventory.service.type;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.broadleafcommerce.presentation.BroadleafEnumerationType;

public class AvailabilityStatusType
implements Serializable,
BroadleafEnumerationType {
    private static final long serialVersionUID = 1L;
    private static final Map<String, AvailabilityStatusType> TYPES = new HashMap<String, AvailabilityStatusType>();
    public static final AvailabilityStatusType AVAILABLE = new AvailabilityStatusType("AVAILABLE", "Available");
    public static final AvailabilityStatusType UNAVAILABLE = new AvailabilityStatusType("UNAVAILABLE", "Unavailable");
    public static final AvailabilityStatusType BACKORDERED = new AvailabilityStatusType("BACKORDERED", "Back Ordered");
    private String type;
    private String friendlyType;

    public static AvailabilityStatusType getInstance(String type) {
        return TYPES.get(type);
    }

    public AvailabilityStatusType() {
    }

    public AvailabilityStatusType(String type, String friendlyType) {
        this.friendlyType = friendlyType;
        this.setType(type);
    }

    public String getType() {
        return this.type;
    }

    public String getFriendlyType() {
        return this.friendlyType;
    }

    private void setType(String type) {
        this.type = type;
        if (TYPES.containsKey(type)) {
            throw new RuntimeException("Cannot add the type: (" + type + "). It already exists as a type via " + AvailabilityStatusType.getInstance(type).getClass().getName());
        }
        TYPES.put(type, this);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AvailabilityStatusType other = (AvailabilityStatusType)obj;
        return !(this.type == null ? other.type != null : !this.type.equals(other.type));
    }
}

