/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.core.payment.service;

import java.util.Map;
import javax.annotation.Resource;
import org.broadleafcommerce.core.order.domain.Order;
import org.broadleafcommerce.core.payment.domain.PaymentInfo;
import org.broadleafcommerce.core.payment.domain.Referenced;
import org.broadleafcommerce.core.payment.service.CompositePaymentService;
import org.broadleafcommerce.core.payment.service.exception.PaymentException;
import org.broadleafcommerce.core.payment.service.module.PaymentResponse;
import org.broadleafcommerce.core.payment.service.module.PaymentResponseImpl;
import org.broadleafcommerce.core.payment.service.workflow.CompositePaymentResponse;
import org.broadleafcommerce.core.payment.service.workflow.PaymentSeed;
import org.broadleafcommerce.core.workflow.SequenceProcessor;
import org.broadleafcommerce.core.workflow.WorkflowException;
import org.springframework.stereotype.Service;

@Service(value="blCompositePaymentService")
public class CompositePaymentServiceImpl
implements CompositePaymentService {
    @Resource(name="blPaymentWorkflow")
    protected SequenceProcessor paymentWorkflow;

    @Override
    public CompositePaymentResponse executePayment(Order order, Map<PaymentInfo, Referenced> payments, PaymentResponse response) throws PaymentException {
        try {
            PaymentSeed seed = new PaymentSeed(order, payments, response);
            this.paymentWorkflow.doActivities(seed);
            return seed;
        }
        catch (WorkflowException e) {
            Throwable cause = null;
            while (!(e.getCause() == null || cause != null && cause.equals(e.getCause()))) {
                cause = e.getCause();
            }
            if (cause != null && PaymentException.class.isAssignableFrom(cause.getClass())) {
                throw (PaymentException)cause;
            }
            throw new PaymentException("Unable to execute payment for order -- id: " + order.getId(), e);
        }
    }

    @Override
    public CompositePaymentResponse executePayment(Order order, Map<PaymentInfo, Referenced> payments) throws PaymentException {
        return this.executePayment(order, payments, new PaymentResponseImpl());
    }

    @Override
    public CompositePaymentResponse executePayment(Order order) throws PaymentException {
        return this.executePayment(order, null);
    }
}

