/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.core.web.catalog;

import java.net.URLDecoder;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.broadleafcommerce.common.web.BLCAbstractHandlerMapping;
import org.broadleafcommerce.common.web.BroadleafRequestContext;
import org.broadleafcommerce.core.catalog.domain.Category;
import org.broadleafcommerce.core.catalog.service.CatalogService;
import org.springframework.beans.factory.annotation.Value;

public class CategoryHandlerMapping
extends BLCAbstractHandlerMapping {
    private String controllerName = "blCategoryController";
    protected String defaultTemplateName = "catalog/category";
    @Resource(name="blCatalogService")
    private CatalogService catalogService;
    public static final String CURRENT_CATEGORY_ATTRIBUTE_NAME = "category";
    @Value(value="${request.uri.encoding}")
    public String charEncoding;

    protected Object getHandlerInternal(HttpServletRequest request) throws Exception {
        String requestUri;
        Category category;
        BroadleafRequestContext context = BroadleafRequestContext.getBroadleafRequestContext();
        if (context != null && context.getRequestURIWithoutContext() != null && (category = this.catalogService.findCategoryByURI(requestUri = URLDecoder.decode(context.getRequestURIWithoutContext(), this.charEncoding))) != null) {
            context.getRequest().setAttribute(CURRENT_CATEGORY_ATTRIBUTE_NAME, (Object)category);
            return this.controllerName;
        }
        return null;
    }

    public String getDefaultTemplateName() {
        return this.defaultTemplateName;
    }

    public void setDefaultTemplateName(String defaultTemplateName) {
        this.defaultTemplateName = defaultTemplateName;
    }
}

