/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.core.web.order.security;

import java.util.HashMap;
import javax.annotation.Resource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.broadleafcommerce.common.crossapp.service.CrossAppAuthService;
import org.broadleafcommerce.common.web.AbstractBroadleafWebRequestProcessor;
import org.broadleafcommerce.core.order.domain.Order;
import org.broadleafcommerce.core.order.service.MergeCartService;
import org.broadleafcommerce.core.order.service.OrderService;
import org.broadleafcommerce.core.order.service.call.MergeCartResponse;
import org.broadleafcommerce.core.order.service.exception.RemoveFromCartException;
import org.broadleafcommerce.core.order.service.type.OrderStatus;
import org.broadleafcommerce.core.pricing.service.exception.PricingException;
import org.broadleafcommerce.core.web.service.UpdateCartService;
import org.broadleafcommerce.profile.core.domain.Customer;
import org.broadleafcommerce.profile.web.core.CustomerState;
import org.broadleafcommerce.profile.web.core.security.CustomerStateRequestProcessor;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;
import org.springframework.web.context.request.WebRequest;

@Component(value="blCartStateRequestProcessor")
public class CartStateRequestProcessor
extends AbstractBroadleafWebRequestProcessor {
    protected final Log LOG = LogFactory.getLog(((Object)((Object)this)).getClass());
    public static final String BLC_RULE_MAP_PARAM = "blRuleMap";
    private final String mergeCartResponseKey = "bl_merge_cart_response";
    @Resource(name="blOrderService")
    protected OrderService orderService;
    @Resource(name="blUpdateCartService")
    protected UpdateCartService updateCartService;
    @Resource(name="blMergeCartService")
    protected MergeCartService mergeCartService;
    @Resource(name="blCustomerStateRequestProcessor")
    protected CustomerStateRequestProcessor customerStateRequestProcessor;
    @Autowired(required=false)
    @Qualifier(value="blCrossAppAuthService")
    protected CrossAppAuthService crossAppAuthService;
    protected static String cartRequestAttributeName = "cart";
    protected static String anonymousCartSessionAttributeName = "anonymousCart";
    public static final String OVERRIDE_CART_ATTR_NAME = "_blc_overrideCartId";

    public void process(WebRequest request) {
        Customer customer = CustomerState.getCustomer();
        if (customer == null) {
            this.LOG.warn((Object)"No customer was found on the current request, no cart will be added to the current request. Ensure that the blCustomerStateFilter occurs prior to the blCartStateFilter");
            return;
        }
        Order cart = this.getOverrideCart(request);
        if (cart == null && this.mergeCartNeeded(customer, request)) {
            if (this.LOG.isDebugEnabled()) {
                this.LOG.debug((Object)("Merge cart required, calling mergeCart " + customer.getId()));
            }
            cart = this.mergeCart(customer, request);
        } else if (cart == null) {
            cart = this.orderService.findCartForCustomer(customer);
        }
        if (cart == null) {
            cart = this.orderService.getNullOrder();
        } else {
            this.updateCartService.updateAndValidateCart(cart);
        }
        request.setAttribute(cartRequestAttributeName, (Object)cart, 0);
        HashMap<String, Order> ruleMap = (HashMap<String, Order>)request.getAttribute(BLC_RULE_MAP_PARAM, 0);
        if (ruleMap == null) {
            ruleMap = new HashMap<String, Order>();
        }
        ruleMap.put("order", cart);
        ruleMap.put("cart", cart);
        request.setAttribute(BLC_RULE_MAP_PARAM, ruleMap, 0);
    }

    public Order getOverrideCart(WebRequest request) {
        Long orderId = (Long)request.getAttribute(OVERRIDE_CART_ATTR_NAME, 2);
        Order cart = null;
        if (orderId != null && ((cart = this.orderService.findOrderById(orderId)) == null || cart.getStatus().equals((Object)OrderStatus.SUBMITTED) || cart.getStatus().equals((Object)OrderStatus.CANCELLED))) {
            return null;
        }
        return cart;
    }

    public boolean mergeCartNeeded(Customer customer, WebRequest request) {
        if (this.crossAppAuthService != null && this.crossAppAuthService.isAuthedFromAdmin()) {
            return false;
        }
        Customer anonymousCustomer = this.customerStateRequestProcessor.getAnonymousCustomer(request);
        return anonymousCustomer != null && customer.getId() != null && !customer.getId().equals(anonymousCustomer.getId());
    }

    public Order mergeCart(Customer customer, WebRequest request) {
        MergeCartResponse mergeCartResponse;
        Customer anonymousCustomer = this.customerStateRequestProcessor.getAnonymousCustomer(request);
        try {
            Order cart = this.orderService.findCartForCustomer(anonymousCustomer);
            mergeCartResponse = this.mergeCartService.mergeCart(customer, cart);
        }
        catch (PricingException e) {
            throw new RuntimeException(e);
        }
        catch (RemoveFromCartException e) {
            throw new RuntimeException(e);
        }
        request.removeAttribute(CustomerStateRequestProcessor.getAnonymousCustomerSessionAttributeName(), 2);
        request.removeAttribute(CustomerStateRequestProcessor.getAnonymousCustomerIdSessionAttributeName(), 2);
        request.setAttribute("bl_merge_cart_response", (Object)mergeCartResponse, 2);
        return mergeCartResponse.getOrder();
    }

    public static String getCartRequestAttributeName() {
        return cartRequestAttributeName;
    }

    public static void setCartRequestAttributeName(String cartRequestAttributeName) {
        CartStateRequestProcessor.cartRequestAttributeName = cartRequestAttributeName;
    }
}

