/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.core.web.order;

import com.googlecode.concurrentlinkedhashmap.ConcurrentLinkedHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.locks.ReentrantLock;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.broadleafcommerce.core.order.domain.Order;
import org.broadleafcommerce.core.order.service.OrderLockManager;
import org.springframework.context.ApplicationListener;
import org.springframework.security.web.session.HttpSessionDestroyedEvent;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

public class SessionOrderLockManager
implements OrderLockManager,
ApplicationListener<HttpSessionDestroyedEvent> {
    private static final Log LOG = LogFactory.getLog(SessionOrderLockManager.class);
    private static final Object LOCK = new Object();
    private static final ConcurrentMap<String, ReentrantLock> SESSION_LOCKS = new ConcurrentLinkedHashMap.Builder().maximumWeightedCapacity(10000).build();

    public Object acquireLock(Order order) {
        ReentrantLock lockObject = this.getSessionLock();
        lockObject.lock();
        return lockObject;
    }

    public Object acquireLockIfAvailable(Order order) {
        ReentrantLock lockObject = this.getSessionLock();
        boolean locked = lockObject.tryLock();
        return locked ? lockObject : null;
    }

    public void releaseLock(Object lockObject) {
        ReentrantLock lock = (ReentrantLock)lockObject;
        lock.unlock();
    }

    public void onApplicationEvent(HttpSessionDestroyedEvent event) {
        ReentrantLock lock = (ReentrantLock)SESSION_LOCKS.remove(event.getSession().getId());
        if (lock != null && LOG.isDebugEnabled()) {
            LOG.debug((Object)("Destroyed lock due to session invalidation: " + lock.toString()));
        }
    }

    protected HttpServletRequest getRequest() {
        return ((ServletRequestAttributes)RequestContextHolder.getRequestAttributes()).getRequest();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ReentrantLock getSessionLock() {
        HttpSession session = this.getRequest().getSession();
        ReentrantLock lock = (ReentrantLock)SESSION_LOCKS.get(session.getId());
        if (lock == null) {
            Object object = LOCK;
            synchronized (object) {
                lock = (ReentrantLock)SESSION_LOCKS.get(session.getId());
                if (lock == null) {
                    lock = new ReentrantLock();
                    SESSION_LOCKS.put(session.getId(), lock);
                }
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Created new lock object: " + lock.toString()));
            }
        } else if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Returning previously created lock object: " + lock.toString()));
        }
        return lock;
    }
}

