/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.core.web.api.wrapper;

import javax.servlet.http.HttpServletRequest;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.broadleafcommerce.common.BroadleafEnumerationType;
import org.broadleafcommerce.core.offer.domain.Offer;
import org.broadleafcommerce.core.web.api.wrapper.APIWrapper;
import org.broadleafcommerce.core.web.api.wrapper.BaseWrapper;
import org.broadleafcommerce.core.web.api.wrapper.BroadleafEnumerationTypeWrapper;

@XmlRootElement(name="offer")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class OfferWrapper
extends BaseWrapper
implements APIWrapper<Offer> {
    @XmlElement
    protected Long offerId;
    @XmlElement
    protected String startDate;
    @XmlElement
    protected String endDate;
    @XmlElement
    protected String marketingMessage;
    @XmlElement
    protected String description;
    @XmlElement
    protected String name;
    @XmlElement
    protected Boolean automatic;
    @XmlElement
    protected BroadleafEnumerationTypeWrapper offerType;
    @XmlElement
    protected BroadleafEnumerationTypeWrapper discountType;
    @XmlElement
    protected int maxUses;

    @Override
    public void wrapDetails(Offer model, HttpServletRequest request) {
        this.wrapSummary(model, request);
        this.startDate = model.getStartDate().toString();
        this.endDate = model.getStartDate().toString();
        this.description = model.getDescription();
        this.maxUses = model.getMaxUses();
    }

    @Override
    public void wrapSummary(Offer model, HttpServletRequest request) {
        this.automatic = model.isAutomaticallyAdded();
        this.offerType = (BroadleafEnumerationTypeWrapper)this.context.getBean(BroadleafEnumerationTypeWrapper.class.getName());
        this.offerType.wrapDetails((BroadleafEnumerationType)model.getType(), request);
        this.discountType = (BroadleafEnumerationTypeWrapper)this.context.getBean(BroadleafEnumerationTypeWrapper.class.getName());
        this.discountType.wrapDetails((BroadleafEnumerationType)model.getDiscountType(), request);
        this.offerId = model.getId();
        this.marketingMessage = model.getMarketingMessage();
        this.name = model.getName();
    }
}

