/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.core.web.layout.tags;

import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.tagext.BodyTagSupport;
import org.broadleafcommerce.core.order.domain.Order;
import org.broadleafcommerce.core.order.domain.OrderItem;
import org.broadleafcommerce.core.order.service.legacy.LegacyCartService;
import org.broadleafcommerce.profile.core.domain.Customer;
import org.broadleafcommerce.profile.web.core.CustomerState;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;

public class OrderLookupTag
extends BodyTagSupport {
    private static final long serialVersionUID = 1L;
    private Long orderId;
    private String orderName;
    private String orderVar;
    private String totalQuantityVar;

    public int doStartTag() throws JspException {
        WebApplicationContext applicationContext = WebApplicationContextUtils.getWebApplicationContext((ServletContext)this.pageContext.getServletContext());
        Customer customer = CustomerState.getCustomer((HttpServletRequest)((HttpServletRequest)this.pageContext.getRequest()));
        LegacyCartService cartService = (LegacyCartService)applicationContext.getBean("blOrderService");
        Order order = null;
        if (this.orderName != null && this.orderId != null) {
            throw new IllegalArgumentException("Only orderName or orderId attribute may be specified on orderLookup tag");
        }
        if (this.orderId != null) {
            order = cartService.findOrderById(this.orderId);
        } else if (this.orderName != null) {
            order = cartService.findNamedOrderForCustomer(this.orderName, customer);
        } else if (customer != null) {
            order = cartService.findCartForCustomer(customer);
        }
        if (this.orderVar != null) {
            this.pageContext.setAttribute(this.orderVar, (Object)order);
        }
        if (this.totalQuantityVar != null) {
            int orderItemsCount = 0;
            if (order != null && order.getOrderItems() != null) {
                for (OrderItem orderItem : order.getOrderItems()) {
                    orderItemsCount += orderItem.getQuantity();
                }
            }
            this.pageContext.setAttribute(this.totalQuantityVar, (Object)orderItemsCount);
        } else if (this.totalQuantityVar != null) {
            this.pageContext.setAttribute(this.totalQuantityVar, (Object)0);
        }
        return 6;
    }

    public String getOrderVar() {
        return this.orderVar;
    }

    public void setOrderVar(String orderVar) {
        this.orderVar = orderVar;
    }

    public String getTotalQuantityVar() {
        return this.totalQuantityVar;
    }

    public void setTotalQuantityVar(String totalQuantityVar) {
        this.totalQuantityVar = totalQuantityVar;
    }

    public String getOrderName() {
        return this.orderName;
    }

    public void setOrderName(String orderName) {
        this.orderName = orderName;
    }

    public Long getOrderId() {
        return this.orderId;
    }

    public void setOrderId(Long orderId) {
        this.orderId = orderId;
    }
}

