/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.core.web.checkout.section;

import java.io.Serializable;
import java.util.LinkedHashMap;
import java.util.Map;
import org.broadleafcommerce.common.BroadleafEnumerationType;

public class CheckoutSectionViewType
implements Serializable,
BroadleafEnumerationType {
    private static final long serialVersionUID = 1L;
    private static final Map<String, CheckoutSectionViewType> TYPES = new LinkedHashMap<String, CheckoutSectionViewType>();
    public static final CheckoutSectionViewType ORDER_INFO = new CheckoutSectionViewType("ORDER_INFO", "Order Info (Contact Info) View");
    public static final CheckoutSectionViewType BILLING_INFO = new CheckoutSectionViewType("BILLING_INFO", "Billing Info View");
    public static final CheckoutSectionViewType SHIPPING_INFO = new CheckoutSectionViewType("SHIPPING_INFO", "Shipping Info View");
    public static final CheckoutSectionViewType PAYMENT_INFO = new CheckoutSectionViewType("PAYMENT_INFO", "Payment Info View");
    private String type;
    private String friendlyType;

    public static CheckoutSectionViewType getInstance(String type) {
        return TYPES.get(type);
    }

    public CheckoutSectionViewType() {
    }

    public CheckoutSectionViewType(String type, String friendlyType) {
        this.friendlyType = friendlyType;
        this.setType(type);
    }

    public String getType() {
        return this.type;
    }

    public String getFriendlyType() {
        return this.friendlyType;
    }

    private void setType(String type) {
        this.type = type;
        if (!TYPES.containsKey(type)) {
            TYPES.put(type, this);
        }
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CheckoutSectionViewType other = (CheckoutSectionViewType)obj;
        return !(this.type == null ? other.type != null : !this.type.equals(other.type));
    }
}

