/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.core.web.processor;

import java.util.Currency;
import java.util.Locale;
import org.broadleafcommerce.common.currency.util.BroadleafCurrencyUtils;
import org.broadleafcommerce.common.money.Money;
import org.broadleafcommerce.common.web.BroadleafRequestContext;
import org.thymeleaf.Arguments;
import org.thymeleaf.Configuration;
import org.thymeleaf.context.IProcessingContext;
import org.thymeleaf.dom.Element;
import org.thymeleaf.processor.attr.AbstractTextChildModifierAttrProcessor;
import org.thymeleaf.standard.expression.Expression;
import org.thymeleaf.standard.expression.StandardExpressions;

public class PriceTextDisplayProcessor
extends AbstractTextChildModifierAttrProcessor {
    public PriceTextDisplayProcessor() {
        super("price");
    }

    public int getPrecedence() {
        return 1500;
    }

    protected String getText(Arguments arguments, Element element, String attributeName) {
        Money price = null;
        Expression expression = (Expression)StandardExpressions.getExpressionParser((Configuration)arguments.getConfiguration()).parseExpression(arguments.getConfiguration(), (IProcessingContext)arguments, element.getAttributeValue(attributeName));
        Object result = expression.execute(arguments.getConfiguration(), (IProcessingContext)arguments);
        if (result instanceof Money) {
            price = (Money)result;
        } else if (result instanceof Number) {
            price = new Money(((Number)result).doubleValue());
        }
        if (price == null) {
            return "Not Available";
        }
        BroadleafRequestContext brc = BroadleafRequestContext.getBroadleafRequestContext();
        if (brc.getJavaLocale() != null) {
            return BroadleafCurrencyUtils.getNumberFormatFromCache((Locale)brc.getJavaLocale(), (Currency)price.getCurrency()).format(price.getAmount());
        }
        return "$ " + price.getAmount().toString();
    }
}

