/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.core.web.controller.checkout;

import java.beans.PropertyEditor;
import java.beans.PropertyEditorSupport;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.broadleafcommerce.common.payment.service.PaymentGatewayCheckoutService;
import org.broadleafcommerce.common.web.controller.BroadleafAbstractController;
import org.broadleafcommerce.core.checkout.service.CheckoutService;
import org.broadleafcommerce.core.order.service.FulfillmentGroupService;
import org.broadleafcommerce.core.order.service.FulfillmentOptionService;
import org.broadleafcommerce.core.order.service.OrderMultishipOptionService;
import org.broadleafcommerce.core.order.service.OrderService;
import org.broadleafcommerce.core.payment.service.OrderPaymentService;
import org.broadleafcommerce.core.payment.service.OrderToPaymentRequestDTOService;
import org.broadleafcommerce.core.web.checkout.validator.BillingInfoFormValidator;
import org.broadleafcommerce.core.web.checkout.validator.GiftCardInfoFormValidator;
import org.broadleafcommerce.core.web.checkout.validator.MultishipAddAddressFormValidator;
import org.broadleafcommerce.core.web.checkout.validator.OrderInfoFormValidator;
import org.broadleafcommerce.core.web.checkout.validator.ShippingInfoFormValidator;
import org.broadleafcommerce.core.web.controller.checkout.BroadleafCheckoutControllerExtensionHandler;
import org.broadleafcommerce.core.web.controller.checkout.BroadleafCheckoutControllerExtensionManager;
import org.broadleafcommerce.profile.core.domain.Country;
import org.broadleafcommerce.profile.core.domain.Phone;
import org.broadleafcommerce.profile.core.domain.PhoneImpl;
import org.broadleafcommerce.profile.core.domain.State;
import org.broadleafcommerce.profile.core.service.AddressService;
import org.broadleafcommerce.profile.core.service.CountryService;
import org.broadleafcommerce.profile.core.service.CustomerAddressService;
import org.broadleafcommerce.profile.core.service.CustomerService;
import org.broadleafcommerce.profile.core.service.PhoneService;
import org.broadleafcommerce.profile.core.service.StateService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.ui.Model;
import org.springframework.web.bind.ServletRequestDataBinder;

public abstract class AbstractCheckoutController
extends BroadleafAbstractController {
    private static final Log LOG = LogFactory.getLog(AbstractCheckoutController.class);
    protected static String cartPageRedirect = "redirect:/cart";
    protected static String checkoutView = "checkout/checkout";
    protected static String checkoutPageRedirect = "redirect:/checkout";
    protected static String baseConfirmationView = "ajaxredirect:/confirmation";
    @Autowired(required=false)
    @Qualifier(value="blPaymentGatewayCheckoutService")
    protected PaymentGatewayCheckoutService paymentGatewayCheckoutService;
    @Resource(name="blOrderService")
    protected OrderService orderService;
    @Resource(name="blOrderPaymentService")
    protected OrderPaymentService orderPaymentService;
    @Resource(name="blOrderToPaymentRequestDTOService")
    protected OrderToPaymentRequestDTOService dtoTranslationService;
    @Resource(name="blFulfillmentGroupService")
    protected FulfillmentGroupService fulfillmentGroupService;
    @Resource(name="blFulfillmentOptionService")
    protected FulfillmentOptionService fulfillmentOptionService;
    @Resource(name="blCheckoutService")
    protected CheckoutService checkoutService;
    @Resource(name="blCustomerService")
    protected CustomerService customerService;
    @Resource(name="blStateService")
    protected StateService stateService;
    @Resource(name="blCountryService")
    protected CountryService countryService;
    @Resource(name="blCustomerAddressService")
    protected CustomerAddressService customerAddressService;
    @Resource(name="blAddressService")
    protected AddressService addressService;
    @Resource(name="blPhoneService")
    protected PhoneService phoneService;
    @Resource(name="blOrderMultishipOptionService")
    protected OrderMultishipOptionService orderMultishipOptionService;
    @Resource(name="blShippingInfoFormValidator")
    protected ShippingInfoFormValidator shippingInfoFormValidator;
    @Resource(name="blBillingInfoFormValidator")
    protected BillingInfoFormValidator billingInfoFormValidator;
    @Resource(name="blGiftCardInfoFormValidator")
    protected GiftCardInfoFormValidator giftCardInfoFormValidator;
    @Resource(name="blMultishipAddAddressFormValidator")
    protected MultishipAddAddressFormValidator multishipAddAddressFormValidator;
    @Resource(name="blOrderInfoFormValidator")
    protected OrderInfoFormValidator orderInfoFormValidator;
    @Resource(name="blCheckoutControllerExtensionManager")
    protected BroadleafCheckoutControllerExtensionManager checkoutControllerExtensionManager;

    public String getCartPageRedirect() {
        return cartPageRedirect;
    }

    public String getCheckoutView() {
        return checkoutView;
    }

    public String getCheckoutPageRedirect() {
        return checkoutPageRedirect;
    }

    public String getBaseConfirmationView() {
        return baseConfirmationView;
    }

    protected String getConfirmationView(String orderNumber) {
        return this.getBaseConfirmationView() + "/" + orderNumber;
    }

    protected void populateModelWithReferenceData(HttpServletRequest request, Model model) {
        ((BroadleafCheckoutControllerExtensionHandler)this.checkoutControllerExtensionManager.getProxy()).addAdditionalModelVariables(model);
    }

    protected void initBinder(HttpServletRequest request, ServletRequestDataBinder binder) throws Exception {
        binder.registerCustomEditor(State.class, "address.state", (PropertyEditor)new PropertyEditorSupport(){

            @Override
            public void setAsText(String text) {
                if (StringUtils.isNotEmpty((String)text)) {
                    State state = AbstractCheckoutController.this.stateService.findStateByAbbreviation(text);
                    this.setValue(state);
                } else {
                    this.setValue(null);
                }
            }
        });
        binder.registerCustomEditor(Country.class, "address.country", (PropertyEditor)new PropertyEditorSupport(){

            @Override
            public void setAsText(String text) {
                Country country = AbstractCheckoutController.this.countryService.findCountryByAbbreviation(text);
                this.setValue(country);
            }
        });
        binder.registerCustomEditor(Phone.class, "address.phonePrimary", (PropertyEditor)new PropertyEditorSupport(){

            @Override
            public void setAsText(String text) {
                if (!StringUtils.isBlank((String)text)) {
                    PhoneImpl phone = new PhoneImpl();
                    phone.setPhoneNumber(text);
                    this.setValue(phone);
                } else {
                    this.setValue(null);
                }
            }
        });
    }
}

