/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.core.web.api.endpoint.order;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.core.Response;
import org.broadleafcommerce.core.checkout.service.CheckoutService;
import org.broadleafcommerce.core.order.domain.FulfillmentGroup;
import org.broadleafcommerce.core.order.domain.FulfillmentOption;
import org.broadleafcommerce.core.order.domain.Order;
import org.broadleafcommerce.core.order.domain.OrderItem;
import org.broadleafcommerce.core.order.service.FulfillmentGroupService;
import org.broadleafcommerce.core.order.service.FulfillmentOptionService;
import org.broadleafcommerce.core.order.service.OrderService;
import org.broadleafcommerce.core.order.service.call.FulfillmentGroupItemRequest;
import org.broadleafcommerce.core.order.service.call.FulfillmentGroupRequest;
import org.broadleafcommerce.core.order.service.type.FulfillmentType;
import org.broadleafcommerce.core.pricing.service.exception.PricingException;
import org.broadleafcommerce.core.web.api.BroadleafWebServicesException;
import org.broadleafcommerce.core.web.api.endpoint.BaseEndpoint;
import org.broadleafcommerce.core.web.api.wrapper.FulfillmentGroupItemWrapper;
import org.broadleafcommerce.core.web.api.wrapper.FulfillmentGroupWrapper;
import org.broadleafcommerce.core.web.api.wrapper.FulfillmentOptionWrapper;
import org.broadleafcommerce.core.web.api.wrapper.OrderWrapper;
import org.broadleafcommerce.core.web.order.CartState;

public abstract class FulfillmentEndpoint
extends BaseEndpoint {
    @Resource(name="blCheckoutService")
    protected CheckoutService checkoutService;
    @Resource(name="blOrderService")
    protected OrderService orderService;
    @Resource(name="blFulfillmentGroupService")
    protected FulfillmentGroupService fulfillmentGroupService;
    @Resource(name="blFulfillmentOptionService")
    protected FulfillmentOptionService fulfillmentOptionService;

    public List<FulfillmentGroupWrapper> findFulfillmentGroupsForOrder(HttpServletRequest request) {
        Order cart = CartState.getCart();
        if (cart != null && cart.getFulfillmentGroups() != null && !cart.getFulfillmentGroups().isEmpty()) {
            List fulfillmentGroups = cart.getFulfillmentGroups();
            ArrayList<FulfillmentGroupWrapper> fulfillmentGroupWrappers = new ArrayList<FulfillmentGroupWrapper>();
            for (FulfillmentGroup fulfillmentGroup : fulfillmentGroups) {
                FulfillmentGroupWrapper fulfillmentGroupWrapper = (FulfillmentGroupWrapper)this.context.getBean(FulfillmentGroupWrapper.class.getName());
                fulfillmentGroupWrapper.wrapSummary(fulfillmentGroup, request);
                fulfillmentGroupWrappers.add(fulfillmentGroupWrapper);
            }
            return fulfillmentGroupWrappers;
        }
        throw BroadleafWebServicesException.build(Response.Status.NOT_FOUND.getStatusCode()).addMessage("org.broadleafcommerce.core.web.api.BroadleafWebServicesException.cartNotFound");
    }

    public OrderWrapper removeAllFulfillmentGroupsFromOrder(HttpServletRequest request, boolean priceOrder) {
        Order cart = CartState.getCart();
        if (cart != null) {
            try {
                this.fulfillmentGroupService.removeAllFulfillmentGroupsFromOrder(cart, priceOrder);
                OrderWrapper wrapper = (OrderWrapper)this.context.getBean(OrderWrapper.class.getName());
                wrapper.wrapDetails(cart, request);
                return wrapper;
            }
            catch (PricingException e) {
                throw BroadleafWebServicesException.build(Response.Status.INTERNAL_SERVER_ERROR.getStatusCode(), null, null, e).addMessage("org.broadleafcommerce.core.web.api.BroadleafWebServicesException.cartPricingError");
            }
        }
        throw BroadleafWebServicesException.build(Response.Status.NOT_FOUND.getStatusCode()).addMessage("org.broadleafcommerce.core.web.api.BroadleafWebServicesException.cartNotFound");
    }

    public FulfillmentGroupWrapper addFulfillmentGroupToOrder(HttpServletRequest request, FulfillmentGroupWrapper wrapper, boolean priceOrder) {
        FulfillmentGroupRequest fulfillmentGroupRequest;
        Order cart = CartState.getCart();
        if (cart != null && (fulfillmentGroupRequest = wrapper.unwrap(request, this.context)).getOrder() != null && fulfillmentGroupRequest.getOrder().getId().equals(cart.getId())) {
            try {
                fulfillmentGroupRequest.setOrder(cart);
                FulfillmentGroup fulfillmentGroup = this.fulfillmentGroupService.addFulfillmentGroupToOrder(fulfillmentGroupRequest, priceOrder);
                FulfillmentGroupWrapper fulfillmentGroupWrapper = (FulfillmentGroupWrapper)this.context.getBean(FulfillmentGroupWrapper.class.getName());
                fulfillmentGroupWrapper.wrapDetails(fulfillmentGroup, request);
                return fulfillmentGroupWrapper;
            }
            catch (PricingException e) {
                throw BroadleafWebServicesException.build(Response.Status.INTERNAL_SERVER_ERROR.getStatusCode(), null, null, e).addMessage("org.broadleafcommerce.core.web.api.BroadleafWebServicesException.cartPricingError");
            }
        }
        throw BroadleafWebServicesException.build(Response.Status.NOT_FOUND.getStatusCode()).addMessage("org.broadleafcommerce.core.web.api.BroadleafWebServicesException.cartNotFound");
    }

    public FulfillmentGroupWrapper addItemToFulfillmentGroup(HttpServletRequest request, Long fulfillmentGroupId, FulfillmentGroupItemWrapper wrapper, boolean priceOrder) {
        FulfillmentGroupItemRequest fulfillmentGroupItemRequest;
        Order cart = CartState.getCart();
        if (cart != null && (fulfillmentGroupItemRequest = wrapper.unwrap(request, this.context)).getOrderItem() != null) {
            FulfillmentGroup fulfillmentGroup = null;
            OrderItem orderItem = null;
            for (FulfillmentGroup fg : cart.getFulfillmentGroups()) {
                if (!fg.getId().equals(fulfillmentGroupId)) continue;
                fulfillmentGroup = fg;
            }
            fulfillmentGroupItemRequest.setFulfillmentGroup(fulfillmentGroup);
            for (OrderItem oi : cart.getOrderItems()) {
                if (!oi.getId().equals(fulfillmentGroupItemRequest.getOrderItem().getId())) continue;
                orderItem = oi;
            }
            fulfillmentGroupItemRequest.setOrderItem(orderItem);
            if (fulfillmentGroup != null && orderItem != null) {
                try {
                    FulfillmentGroup fg = this.fulfillmentGroupService.addItemToFulfillmentGroup(fulfillmentGroupItemRequest, priceOrder);
                    FulfillmentGroupWrapper fulfillmentGroupWrapper = (FulfillmentGroupWrapper)this.context.getBean(FulfillmentGroupWrapper.class.getName());
                    fulfillmentGroupWrapper.wrapDetails(fg, request);
                    return fulfillmentGroupWrapper;
                }
                catch (PricingException e) {
                    throw BroadleafWebServicesException.build(Response.Status.INTERNAL_SERVER_ERROR.getStatusCode(), null, null, e).addMessage("org.broadleafcommerce.core.web.api.BroadleafWebServicesException.cartPricingError");
                }
            }
        }
        throw BroadleafWebServicesException.build(Response.Status.NOT_FOUND.getStatusCode()).addMessage("org.broadleafcommerce.core.web.api.BroadleafWebServicesException.cartNotFound");
    }

    public FulfillmentGroupWrapper addFulfillmentOptionToFulfillmentGroup(HttpServletRequest request, Long fulfillmentGroupId, Long fulfillmentOptionId, boolean priceOrder) {
        block8: {
            FulfillmentOption option = this.fulfillmentOptionService.readFulfillmentOptionById(fulfillmentOptionId);
            if (option == null) {
                throw BroadleafWebServicesException.build(Response.Status.NOT_FOUND.getStatusCode()).addMessage("org.broadleafcommerce.core.web.api.BroadleafWebServicesException.fulfillmentOptionNotFound", fulfillmentOptionId);
            }
            Order cart = CartState.getCart();
            if (cart != null) {
                boolean found = false;
                List groups = cart.getFulfillmentGroups();
                if (groups != null && !groups.isEmpty()) {
                    for (FulfillmentGroup group : groups) {
                        if (!group.getId().equals(fulfillmentGroupId)) continue;
                        group.setFulfillmentOption(option);
                        found = true;
                        break;
                    }
                }
                try {
                    if (found) {
                        cart = this.orderService.save(cart, Boolean.valueOf(priceOrder));
                        for (FulfillmentGroup fg : groups) {
                            if (!fg.getId().equals(fulfillmentGroupId)) continue;
                            FulfillmentGroupWrapper fulfillmentGroupWrapper = (FulfillmentGroupWrapper)this.context.getBean(FulfillmentGroupWrapper.class.getName());
                            fulfillmentGroupWrapper.wrapDetails(fg, request);
                            return fulfillmentGroupWrapper;
                        }
                        break block8;
                    }
                    throw BroadleafWebServicesException.build(Response.Status.NOT_FOUND.getStatusCode()).addMessage("org.broadleafcommerce.core.web.api.BroadleafWebServicesException.fulfillmentGroupNotFound", fulfillmentGroupId);
                }
                catch (PricingException e) {
                    throw BroadleafWebServicesException.build(Response.Status.INTERNAL_SERVER_ERROR.getStatusCode(), null, null, e).addMessage("org.broadleafcommerce.core.web.api.BroadleafWebServicesException.cartPricingError");
                }
            }
        }
        throw BroadleafWebServicesException.build(Response.Status.NOT_FOUND.getStatusCode()).addMessage("org.broadleafcommerce.core.web.api.BroadleafWebServicesException.cartNotFound");
    }

    public List<FulfillmentOptionWrapper> findFulfillmentOptions(HttpServletRequest request, String fulfillmentType) {
        ArrayList<FulfillmentOptionWrapper> out = new ArrayList<FulfillmentOptionWrapper>();
        List options = null;
        FulfillmentType type = FulfillmentType.getInstance((String)fulfillmentType);
        options = type != null ? this.fulfillmentOptionService.readAllFulfillmentOptionsByFulfillmentType(type) : this.fulfillmentOptionService.readAllFulfillmentOptions();
        for (FulfillmentOption option : options) {
            FulfillmentOptionWrapper fulfillmentOptionWrapper = (FulfillmentOptionWrapper)this.context.getBean(FulfillmentOptionWrapper.class.getName());
            fulfillmentOptionWrapper.wrapDetails(option, request);
            out.add(fulfillmentOptionWrapper);
        }
        return out;
    }
}

