/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.core.web.service;

import java.io.Serializable;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.broadleafcommerce.common.extension.ExtensionResultHolder;
import org.broadleafcommerce.common.extension.ExtensionResultStatusType;
import org.broadleafcommerce.common.util.BLCSystemProperty;
import org.broadleafcommerce.common.web.BroadleafRequestContext;
import org.broadleafcommerce.core.catalog.domain.ProductOptionValue;
import org.broadleafcommerce.core.catalog.domain.Sku;
import org.broadleafcommerce.core.catalog.service.CatalogService;
import org.broadleafcommerce.core.order.domain.BundleOrderItem;
import org.broadleafcommerce.core.order.domain.DiscreteOrderItem;
import org.broadleafcommerce.core.order.domain.Order;
import org.broadleafcommerce.core.order.domain.OrderItem;
import org.broadleafcommerce.core.order.domain.OrderItemAttribute;
import org.broadleafcommerce.core.order.domain.OrderItemAttributeImpl;
import org.broadleafcommerce.core.web.service.AbstractUpdateCartServiceExtensionHandler;
import org.broadleafcommerce.core.web.service.UpdateCartServiceExtensionHandler;
import org.broadleafcommerce.core.web.service.UpdateCartServiceExtensionManager;
import org.springframework.stereotype.Service;

@Service(value="bli18nUpdateCartServiceExtensionHandler")
public class i18nUpdateCartServiceExtensionHandler
extends AbstractUpdateCartServiceExtensionHandler
implements UpdateCartServiceExtensionHandler {
    protected static final Log LOG = LogFactory.getLog(i18nUpdateCartServiceExtensionHandler.class);
    @Resource(name="blCatalogService")
    protected CatalogService catalogService;
    @Resource(name="blUpdateCartServiceExtensionManager")
    protected UpdateCartServiceExtensionManager extensionManager;

    protected boolean getClearCartOnLocaleSwitch() {
        return BLCSystemProperty.resolveBooleanSystemProperty((String)"clearCartOnLocaleSwitch");
    }

    @PostConstruct
    public void init() {
        if (this.isEnabled()) {
            this.extensionManager.getHandlers().add(this);
        }
    }

    @Override
    public ExtensionResultStatusType updateAndValidateCart(Order cart, ExtensionResultHolder resultHolder) {
        BroadleafRequestContext brc;
        if (BroadleafRequestContext.hasLocale() && !(brc = BroadleafRequestContext.getBroadleafRequestContext()).getLocale().getLocaleCode().matches(cart.getLocale().getLocaleCode())) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("The cart Locale [" + cart.getLocale().getLocaleCode() + "] does not match the current locale [" + brc.getLocale().getLocaleCode() + "]"));
            }
            if (this.getClearCartOnLocaleSwitch()) {
                resultHolder.getContextMap().put("clearCart", Boolean.TRUE);
            } else {
                this.fixTranslations(cart);
                cart.setLocale(brc.getLocale());
                resultHolder.getContextMap().put("saveCart", Boolean.TRUE);
            }
        }
        return ExtensionResultStatusType.HANDLED_CONTINUE;
    }

    protected void fixTranslations(Order cart) {
        for (DiscreteOrderItem orderItem : cart.getDiscreteOrderItems()) {
            Sku sku = orderItem.getSku();
            this.translateOrderItem((OrderItem)orderItem, sku);
        }
        for (DiscreteOrderItem orderItem : cart.getOrderItems()) {
            if (!(orderItem instanceof BundleOrderItem)) continue;
            BundleOrderItem bundleItem = (BundleOrderItem)orderItem;
            Sku sku = bundleItem.getSku();
            this.translateOrderItem((OrderItem)orderItem, sku);
        }
    }

    protected void translateOrderItem(OrderItem orderItem, Sku sku) {
        if (sku != null) {
            orderItem.setName(sku.getName());
            if (sku.getProductOptionValues() != null) {
                for (ProductOptionValue optionValue : sku.getProductOptionValues()) {
                    String key = optionValue.getProductOption().getAttributeName();
                    OrderItemAttribute attr = (OrderItemAttribute)orderItem.getOrderItemAttributes().get(key);
                    if (attr != null) {
                        attr.setValue((Serializable)((Object)optionValue.getAttributeValue()));
                        continue;
                    }
                    OrderItemAttributeImpl attribute = new OrderItemAttributeImpl();
                    attribute.setName(key);
                    attribute.setValue((Serializable)((Object)optionValue.getAttributeValue()));
                    attribute.setOrderItem(orderItem);
                    orderItem.getOrderItemAttributes().put(key, attribute);
                }
            }
        }
    }
}

